/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost.regassets.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;

public class CitySphereSettings {
    public static final Codec<CitySphereSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("centerpart").forGetter(l -> Optional.ofNullable(l.centerpart)), (App)Codec.STRING.optionalFieldOf("centertype").forGetter(CitySphereSettings::getOptionalCentertype), (App)Codec.STRING.optionalFieldOf("centerpartorigin").forGetter(CitySphereSettings::getOptionalCentertype), (App)Codec.INT.optionalFieldOf("centerpartoffset").forGetter(l -> l.centerpartOffset == 0 ? Optional.empty() : Optional.of(l.centerpartOffset))).apply((Applicative)instance, CitySphereSettings::new));
    private final String centerpart;
    private final CitySphereCenterType centertype;
    private final CitySpherePartOrigin centerpartOrigin;
    private final int centerpartOffset;

    public CitySphereSettings(Optional<String> centerpart, Optional<String> centertype, Optional<String> centerpartOrigin, Optional<Integer> centerpartOffset) {
        this.centerpart = centerpart.orElse(null);
        this.centertype = centertype.map(l -> CitySphereCenterType.valueOf(l.toUpperCase())).orElse(CitySphereCenterType.DEFAULT);
        this.centerpartOrigin = centerpartOrigin.map(l -> CitySpherePartOrigin.valueOf(l.toUpperCase())).orElse(CitySpherePartOrigin.TOP);
        this.centerpartOffset = centerpartOffset.orElse(0);
    }

    public String getCenterpart() {
        return this.centerpart;
    }

    private Optional<String> getOptionalCentertype() {
        if (this.centertype == CitySphereCenterType.DEFAULT) {
            return Optional.empty();
        }
        return Optional.of(this.centertype.name().toLowerCase());
    }

    public CitySphereCenterType getCenterType() {
        return this.centertype;
    }

    public CitySpherePartOrigin getCenterPartOrigin() {
        return this.centerpartOrigin;
    }

    public int getCenterPartOffset() {
        return this.centerpartOffset;
    }

    public static enum CitySphereCenterType {
        DEFAULT,
        STREET,
        BUILDING,
        NORMAL;

    }

    public static enum CitySpherePartOrigin {
        FIXED,
        CENTER,
        FIRSTFLOOR,
        GROUND,
        TOP;

    }
}

