/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen;

import mcjty.lostcities.varia.ChunkCoord;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.lost.BuildingInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkStatus;

public class ChunkFixer {
    private static void executePostTodo(ChunkCoord coord, IDimensionInfo provider) {
        BuildingInfo info = BuildingInfo.getBuildingInfo(coord, provider);
        info.getPostTodo().forEach((pos, runnable) -> runnable.run());
        info.clearPostTodo();
    }

    private static void generateVines(ChunkCoord coord, LevelAccessor world, IDimensionInfo provider) {
        int x;
        int y;
        int z;
        int bottom;
        BuildingInfo adjacent;
        float vineChance = provider.getProfile().VINE_CHANCE;
        if ((double)vineChance < 1.0E-6) {
            return;
        }
        int chunkX = coord.chunkX();
        int chunkZ = coord.chunkZ();
        int cx = chunkX << 4;
        int cz = chunkZ << 4;
        BuildingInfo info = BuildingInfo.getBuildingInfo(coord, provider);
        int maxHeight = info.getMaxHeight();
        if (info.hasBuilding && world.m_6325_(coord.chunkX() + 1, coord.chunkZ()).m_6415_().m_62427_(ChunkStatus.f_62322_)) {
            adjacent = info.getXmax();
            bottom = Math.max(adjacent.getCityGroundLevel() + 3, adjacent.hasBuilding ? adjacent.getMaxHeight() : adjacent.getCityGroundLevel() + 3);
            for (z = 0; z < 15; ++z) {
                for (y = bottom; y < maxHeight; ++y) {
                    if (!(world.m_213780_().m_188501_() < vineChance)) continue;
                    ChunkFixer.createVineStrip(world, bottom, VineBlock.f_57837_, new BlockPos(cx + 16, y, cz + z), new BlockPos(cx + 15, y, cz + z));
                }
            }
        }
        if (info.getXmax().hasBuilding && world.m_6325_(chunkX + 1, chunkZ).m_6415_().m_62427_(ChunkStatus.f_62322_)) {
            adjacent = info.getXmax();
            bottom = Math.max(info.getCityGroundLevel() + 3, info.hasBuilding ? maxHeight : info.getCityGroundLevel() + 3);
            for (z = 0; z < 15; ++z) {
                for (y = bottom; y < adjacent.getMaxHeight(); ++y) {
                    if (!(world.m_213780_().m_188501_() < vineChance)) continue;
                    ChunkFixer.createVineStrip(world, bottom, VineBlock.f_57835_, new BlockPos(cx + 15, y, cz + z), new BlockPos(cx + 16, y, cz + z));
                }
            }
        }
        if (info.hasBuilding && world.m_6325_(chunkX, chunkZ + 1).m_6415_().m_62427_(ChunkStatus.f_62322_)) {
            adjacent = info.getZmax();
            bottom = Math.max(adjacent.getCityGroundLevel() + 3, adjacent.hasBuilding ? adjacent.getMaxHeight() : adjacent.getCityGroundLevel() + 3);
            for (x = 0; x < 15; ++x) {
                for (y = bottom; y < maxHeight; ++y) {
                    if (!(world.m_213780_().m_188501_() < vineChance)) continue;
                    ChunkFixer.createVineStrip(world, bottom, VineBlock.f_57834_, new BlockPos(cx + x, y, cz + 16), new BlockPos(cx + x, y, cz + 15));
                }
            }
        }
        if (info.getZmax().hasBuilding && world.m_6325_(chunkX, chunkZ + 1).m_6415_().m_62427_(ChunkStatus.f_62322_)) {
            adjacent = info.getZmax();
            bottom = Math.max(info.getCityGroundLevel() + 3, info.hasBuilding ? maxHeight : info.getCityGroundLevel() + 3);
            for (x = 0; x < 15; ++x) {
                for (y = bottom; y < adjacent.getMaxHeight(); ++y) {
                    if (!(world.m_213780_().m_188501_() < vineChance)) continue;
                    ChunkFixer.createVineStrip(world, bottom, VineBlock.f_57836_, new BlockPos(cx + x, y, cz + 15), new BlockPos(cx + x, y, cz + 16));
                }
            }
        }
    }

    private static void createVineStrip(LevelAccessor world, int bottom, BooleanProperty direction, BlockPos pos, BlockPos vineHolderPos) {
        if (world.m_46859_(vineHolderPos)) {
            return;
        }
        if (!world.m_46859_(pos)) {
            return;
        }
        BlockState state = (BlockState)Blocks.f_50191_.m_49966_().m_61124_((Property)direction, (Comparable)Boolean.valueOf(true));
        world.m_7731_(pos, state, 0);
        pos = pos.m_7495_();
        while (pos.m_123342_() >= bottom && world.m_213780_().m_188501_() < 0.8f) {
            if (!world.m_46859_(pos)) {
                return;
            }
            world.m_7731_(pos, state, 0);
            pos = pos.m_7495_();
        }
    }

    public static void fix(IDimensionInfo info, ChunkCoord coord) {
        ChunkFixer.generateVines(coord, (LevelAccessor)info.getWorld(), info);
        ChunkFixer.executePostTodo(coord, info);
    }
}

