/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.cultivation.init.registries;

import cofh.core.common.item.BlockNamedItemCoFH;
import cofh.core.common.item.ItemCoFH;
import cofh.lib.util.Utils;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.init.registries.ThermalCreativeTabs;
import cofh.thermal.core.util.RegistrationHelper;
import cofh.thermal.cultivation.common.item.JarredItem;
import cofh.thermal.cultivation.common.item.WateringCanItem;
import cofh.thermal.cultivation.init.registries.TCulFoods;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.RegistryObject;

public class TCulItems {
    private TCulItems() {
    }

    public static void register() {
        TCulItems.registerCrops();
        TCulItems.registerFoods();
        TCulItems.registerTools();
    }

    private static void registerCrops() {
        TCulItems.registerCropAndSeed("amaranth");
        TCulItems.registerCropAndSeed("barley");
        TCulItems.registerCropAndSeed("corn", TCulFoods.CORN);
        TCulItems.registerCropAndSeed("flax");
        TCulItems.registerCropAndSeed("onion", TCulFoods.ONION);
        TCulItems.registerCropAndSeed("radish", TCulFoods.RADISH);
        TCulItems.registerCropAndSeed("rice");
        TCulItems.registerCropAndSeed("sadiroot");
        TCulItems.registerCropAndSeed("spinach", TCulFoods.SPINACH);
        TCulItems.registerCropAndSeed("bell_pepper", TCulFoods.BELL_PEPPER);
        TCulItems.registerCropAndSeed("eggplant", TCulFoods.EGGPLANT);
        TCulItems.registerCropAndSeed("green_bean", TCulFoods.GREEN_BEAN);
        TCulItems.registerCropAndSeed("peanut", TCulFoods.PEANUT);
        TCulItems.registerCropAndSeed("strawberry", TCulFoods.STRAWBERRY);
        TCulItems.registerCropAndSeed("tomato", TCulFoods.TOMATO);
        TCulItems.registerCropAndSeed("coffee", TCulFoods.COFFEE_CHERRY);
        ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerItem((String)"hops", () -> new ItemCoFH(new Item.Properties()).setModId("thermal_cultivation")));
        ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerItem((String)RegistrationHelper.seeds((String)"hops"), () -> new ItemCoFH(new Item.Properties()).setModId("thermal_cultivation")));
        TCulItems.registerCropAndSeed("tea");
        TCulItems.registerSpores("glowstone_mushroom");
        TCulItems.registerSpores("gunpowder_mushroom");
        TCulItems.registerSpores("redstone_mushroom");
        TCulItems.registerSpores("slime_mushroom");
        ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerItem((String)"frost_melon_slice", () -> new ItemCoFH(new Item.Properties().m_41489_(TCulFoods.FROST_MELON_SLICE).m_41497_(Rarity.UNCOMMON)).setModId("thermal_cultivation")));
        ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerItem((String)RegistrationHelper.seeds((String)"frost_melon"), () -> new BlockNamedItemCoFH((Block)ThermalCore.BLOCKS.get("frost_melon_stem"), new Item.Properties().m_41497_(Rarity.UNCOMMON)).setModId("thermal_cultivation")));
    }

    private static void registerFoods() {
        ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerItem((String)"jar", () -> new ItemCoFH(new Item.Properties()).setModId("thermal_cultivation")));
        ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerItem((String)"peanut_butter", () -> new JarredItem(new Item.Properties()).setModId("thermal_cultivation")));
        ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerItem((String)"jelly", () -> new JarredItem(new Item.Properties()).setModId("thermal_cultivation")));
        ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerItem((String)"tomato_sauce", () -> new JarredItem(new Item.Properties()).setModId("thermal_cultivation")));
        ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerItem((String)"cooked_mushroom", () -> new ItemCoFH(new Item.Properties().m_41489_(TCulFoods.COOKED_MUSHROOM)).setModId("thermal_cultivation")));
        ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerItem((String)"cooked_corn", () -> new ItemCoFH(new Item.Properties().m_41489_(TCulFoods.COOKED_CORN)).setModId("thermal_cultivation")));
        ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerItem((String)"cooked_eggplant", () -> new ItemCoFH(new Item.Properties().m_41489_(TCulFoods.COOKED_EGGPLANT)).setModId("thermal_cultivation")));
        ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerItem((String)"cheese_wedge", () -> new ItemCoFH(new Item.Properties().m_41489_(TCulFoods.CHEESE)).setModId("thermal_cultivation")));
        ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerItem((String)"green_bean_pie", () -> new ItemCoFH(new Item.Properties().m_41489_(TCulFoods.GREEN_BEAN_PIE)).setModId("thermal_cultivation")));
        ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerItem((String)"pbj_sandwich", () -> new ItemCoFH(new Item.Properties().m_41489_(TCulFoods.PBJ_SANDWICH)).setModId("thermal_cultivation")));
        ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerItem((String)"stuffed_pepper", () -> new ItemCoFH(new Item.Properties().m_41489_(TCulFoods.STUFFED_PEPPER)).setModId("thermal_cultivation")));
        ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerItem((String)"sushi_maki", () -> new ItemCoFH(new Item.Properties().m_41489_(TCulFoods.SUSHI)).setModId("thermal_cultivation")));
        TCulItems.registerBowlFoodItem("spring_salad", TCulFoods.SPRING_SALAD, Rarity.UNCOMMON);
        TCulItems.registerBowlFoodItem("hearty_stew", TCulFoods.HEARTY_STEW, Rarity.UNCOMMON);
        TCulItems.registerBowlFoodItem("xp_stew", TCulFoods.XP_STEW, Rarity.UNCOMMON);
    }

    private static void registerTools() {
        ThermalCreativeTabs.toolsTab((int)20, (RegistryObject)RegistrationHelper.registerItem((String)"watering_can", () -> new WateringCanItem(new Item.Properties().m_41487_(1), 8000).setModId("thermal_cultivation")));
    }

    private static void registerCropAndSeed(String id) {
        TCulItems.registerCropAndSeed(id, null);
    }

    private static void registerCropAndSeed(String id, FoodProperties food) {
        if (food != null) {
            ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerItem((String)id, () -> new ItemCoFH(Utils.itemProperties().m_41489_(food)).setModId("thermal_cultivation")));
        } else {
            ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerItem((String)id, () -> new ItemCoFH(Utils.itemProperties()).setModId("thermal_cultivation")));
        }
        ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerItem((String)RegistrationHelper.seeds((String)id), () -> new BlockNamedItemCoFH((Block)ThermalCore.BLOCKS.get(id), Utils.itemProperties()).setModId("thermal_cultivation")));
    }

    private static void registerBowlFoodItem(String id, FoodProperties food, Rarity rarity) {
        ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerItem((String)id, () -> new ItemCoFH(Utils.itemProperties().m_41487_(1).m_41489_(food).m_41497_(rarity)){

            /*
             * Enabled aggressive block sorting
             */
            public ItemStack m_5922_(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
                ItemStack itemStack;
                ItemStack itemstack = super.m_5922_(stack, worldIn, entityLiving);
                if (entityLiving instanceof Player) {
                    Player player = (Player)entityLiving;
                    if (player.f_36077_.f_35937_) {
                        itemStack = itemstack;
                        return itemStack;
                    }
                }
                itemStack = new ItemStack((ItemLike)Items.f_42399_);
                return itemStack;
            }
        }.setModId("thermal_cultivation")));
    }

    private static void registerBottleFoodItem(String id, FoodProperties food, Rarity rarity) {
        ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerItem((String)id, () -> new ItemCoFH(Utils.itemProperties().m_41487_(16).m_41489_(food).m_41497_(rarity)){

            /*
             * Enabled aggressive block sorting
             */
            public ItemStack m_5922_(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
                ItemStack itemStack;
                ItemStack itemstack = super.m_5922_(stack, worldIn, entityLiving);
                if (entityLiving instanceof Player) {
                    Player player = (Player)entityLiving;
                    if (player.f_36077_.f_35937_) {
                        itemStack = itemstack;
                        return itemStack;
                    }
                }
                itemStack = new ItemStack((ItemLike)Items.f_42590_);
                return itemStack;
            }
        }.setModId("thermal_cultivation")));
    }

    private static void registerSpores(String id) {
        ThermalCreativeTabs.foodsTab((RegistryObject)RegistrationHelper.registerItem((String)RegistrationHelper.spores((String)id), () -> new BlockNamedItemCoFH((Block)ThermalCore.BLOCKS.get(id), Utils.itemProperties()).setModId("thermal_cultivation")));
    }
}

