/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.util;

import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonWriter;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.loot.AffixLootEntry;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;

public class MiscDatagenCode {
    private static final DynamicHolder<LootRarity> COMMON = RarityRegistry.INSTANCE.holder(Apotheosis.loc("common"));
    private static final DynamicHolder<LootRarity> UNCOMMON = RarityRegistry.INSTANCE.holder(Apotheosis.loc("uncommon"));
    private static final DynamicHolder<LootRarity> RARE = RarityRegistry.INSTANCE.holder(Apotheosis.loc("rare"));
    private static final DynamicHolder<LootRarity> EPIC = RarityRegistry.INSTANCE.holder(Apotheosis.loc("epic"));
    private static final DynamicHolder<LootRarity> MYTHIC = RarityRegistry.INSTANCE.holder(Apotheosis.loc("mythic"));
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void genAffixLootItems() {
        ImmutableSet overworld = ImmutableSet.of((Object)new ResourceLocation("overworld"));
        ImmutableSet nether = ImmutableSet.of((Object)new ResourceLocation("the_nether"));
        ImmutableSet end = ImmutableSet.of((Object)new ResourceLocation("the_end"));
        BiConsumer<String, AffixLootEntry> writerFunc = (dim, entry) -> {
            if (entry.getType().isNone()) {
                return;
            }
            File file = new File(FMLPaths.GAMEDIR.get().toFile(), "datagen/" + dim + "/" + ForgeRegistries.ITEMS.getKey((Object)entry.getStack().m_41720_()).m_135815_() + ".json");
            file.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(file);){
                JsonWriter jWriter = new JsonWriter((Writer)writer);
                jWriter.setIndent("    ");
                JsonElement json = (JsonElement)AffixLootEntry.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, entry).get().left().get();
                GSON.toJson(json, jWriter);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        };
        for (Item i : ForgeRegistries.ITEMS) {
            ArmorItem a;
            ArmorMaterial weight3;
            AffixLootEntry entry2;
            int quality;
            AffixLootEntry entry3;
            TieredItem t;
            Tier tier;
            if (i instanceof TieredItem && (tier = (t = (TieredItem)i).m_43314_()) instanceof Tiers) {
                Tiers tier2 = (Tiers)tier;
                if (tier2.ordinal() > Tiers.STONE.ordinal() && tier2.ordinal() <= Tiers.IRON.ordinal()) {
                    entry3 = new AffixLootEntry(100 - 15 * (tier2.ordinal() - 1), 1 + 3 * (tier2.ordinal() - 1), new ItemStack((ItemLike)i), (Set<ResourceLocation>)overworld, COMMON, RARE);
                    writerFunc.accept("overworld", entry3);
                }
                if (tier2.ordinal() >= Tiers.IRON.ordinal() && tier2.ordinal() <= Tiers.DIAMOND.ordinal() || tier2 == Tiers.GOLD) {
                    int weight2 = tier2 == Tiers.GOLD ? 85 : 100 - 30 * (tier2.ordinal() - 2);
                    quality = tier2 == Tiers.GOLD ? 5 : 1 + 5 * (tier2.ordinal() - 2);
                    entry2 = new AffixLootEntry(weight2, quality, new ItemStack((ItemLike)i), (Set<ResourceLocation>)nether, UNCOMMON, EPIC);
                    writerFunc.accept("the_nether", entry2);
                }
                if (tier2.ordinal() < Tiers.DIAMOND.ordinal()) continue;
                int weight3 = tier2 == Tiers.DIAMOND ? 100 : 70;
                quality = tier2 == Tiers.DIAMOND ? 5 : 10;
                entry2 = new AffixLootEntry(weight3, quality, new ItemStack((ItemLike)i), (Set<ResourceLocation>)end, RARE, MYTHIC);
                writerFunc.accept("the_end", entry2);
                continue;
            }
            if (!(i instanceof ArmorItem) || !((weight3 = (a = (ArmorItem)i).m_40401_()) instanceof ArmorMaterials)) continue;
            ArmorMaterials mat = (ArmorMaterials)weight3;
            if (mat.ordinal() <= ArmorMaterials.IRON.ordinal()) {
                entry3 = new AffixLootEntry(100 - 15 * mat.ordinal(), 1 + 2 * mat.ordinal(), new ItemStack((ItemLike)i), (Set<ResourceLocation>)overworld, COMMON, RARE);
                writerFunc.accept("overworld", entry3);
            }
            if (mat.ordinal() >= ArmorMaterials.IRON.ordinal() && mat.ordinal() <= ArmorMaterials.DIAMOND.ordinal()) {
                entry3 = new AffixLootEntry(100 - 15 * (mat.ordinal() - 2), 1 + 2 * (mat.ordinal() - 2), new ItemStack((ItemLike)i), (Set<ResourceLocation>)nether, UNCOMMON, EPIC);
                writerFunc.accept("the_nether", entry3);
            }
            if (mat != ArmorMaterials.DIAMOND && mat != ArmorMaterials.NETHERITE) continue;
            int weight2 = mat == ArmorMaterials.DIAMOND ? 100 : 70;
            quality = mat == ArmorMaterials.DIAMOND ? 5 : 10;
            entry2 = new AffixLootEntry(weight2, quality, new ItemStack((ItemLike)i), (Set<ResourceLocation>)end, RARE, MYTHIC);
            writerFunc.accept("the_end", entry2);
        }
    }
}

