/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.ench.table;

import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.advancements.EnchantedTrigger;
import dev.shadowsoffire.apotheosis.ench.Ench;
import dev.shadowsoffire.apotheosis.ench.api.IEnchantingBlock;
import dev.shadowsoffire.apotheosis.ench.table.ApothEnchantTile;
import dev.shadowsoffire.apotheosis.ench.table.ClueMessage;
import dev.shadowsoffire.apotheosis.ench.table.EnchantingRecipe;
import dev.shadowsoffire.apotheosis.ench.table.EnchantingStatRegistry;
import dev.shadowsoffire.apotheosis.ench.table.IEnchantableItem;
import dev.shadowsoffire.apotheosis.ench.table.RealEnchantmentHelper;
import dev.shadowsoffire.apotheosis.ench.table.StatsMessage;
import dev.shadowsoffire.apotheosis.util.ApothMiscUtil;
import dev.shadowsoffire.placebo.network.PacketDistro;
import dev.shadowsoffire.placebo.util.EnchantmentUtils;
import it.unimi.dsi.fastutil.floats.Float2FloatMap;
import it.unimi.dsi.fastutil.floats.Float2FloatOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.EnchantmentTableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.network.simple.SimpleChannel;

public class ApothEnchantmentMenu
extends EnchantmentMenu {
    protected TableStats stats = TableStats.INVALID;
    protected final Player player;

    public ApothEnchantmentMenu(int id, Inventory inv) {
        super(id, inv, ContainerLevelAccess.f_39287_);
        this.player = inv.f_35978_;
        this.f_38839_.clear();
        this.addSecretSlot(new Slot(this.f_39449_, 0, 15, 47){

            public boolean m_5857_(ItemStack stack) {
                return true;
            }

            public int m_6641_() {
                return 1;
            }
        });
        this.addSecretSlot(new Slot(this.f_39449_, 1, 35, 47){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_204117_(Tags.Items.ENCHANTING_FUELS);
            }
        });
        this.initCommon(inv);
    }

    public ApothEnchantmentMenu(int id, Inventory inv, ContainerLevelAccess wPos, ApothEnchantTile te) {
        super(id, inv, wPos);
        this.player = inv.f_35978_;
        this.f_38839_.clear();
        this.addSecretSlot(new Slot(this.f_39449_, 0, 15, 47){

            public boolean m_5857_(ItemStack stack) {
                return true;
            }

            public int m_6641_() {
                return 1;
            }
        });
        this.addSecretSlot((Slot)new SlotItemHandler((IItemHandler)te.inv, 0, 35, 47){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_204117_(Tags.Items.ENCHANTING_FUELS);
            }
        });
        this.initCommon(inv);
    }

    protected Slot addSecretSlot(Slot pSlot) {
        pSlot.f_40219_ = this.f_38839_.size();
        this.f_38839_.add((Object)pSlot);
        return pSlot;
    }

    private void initCommon(Inventory inv) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSecretSlot(new Slot((Container)inv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18 + 31));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSecretSlot(new Slot((Container)inv, k, 8 + k * 18, 173));
        }
    }

    public boolean m_6366_(Player player, int id) {
        int slot = id;
        int level = this.f_39446_[slot];
        ItemStack toEnchant = this.f_39449_.m_8020_(0);
        ItemStack lapis = this.m_38853_(1).m_7993_();
        int cost = slot + 1;
        if ((lapis.m_41619_() || lapis.m_41613_() < cost) && !player.m_150110_().f_35937_) {
            return false;
        }
        if (this.f_39446_[slot] <= 0 || toEnchant.m_41619_() || (player.f_36078_ < cost || player.f_36078_ < this.f_39446_[slot]) && !player.m_150110_().f_35937_) {
            return false;
        }
        this.f_39450_.m_39292_((world, pos) -> {
            ItemStack enchanted = toEnchant;
            float eterna = this.stats.eterna;
            float quanta = this.stats.quanta;
            float arcana = this.stats.arcana;
            float rectification = this.stats.rectification;
            List<EnchantmentInstance> list = this.m_39471_(toEnchant, slot, this.f_39446_[slot]);
            if (list.isEmpty()) return;
            EnchantmentUtils.chargeExperience((Player)player, (int)ApothMiscUtil.getExpCostForSlot(level, slot));
            player.m_7408_(toEnchant, 0);
            if (list.get((int)0).f_44947_ == Ench.Enchantments.INFUSION.get()) {
                EnchantingRecipe match = EnchantingRecipe.findMatch(world, toEnchant, eterna, quanta, arcana);
                if (match == null) return;
                this.f_39449_.m_6836_(0, match.assemble(toEnchant, eterna, quanta, arcana));
            } else {
                this.f_39449_.m_6836_(0, ((IEnchantableItem)toEnchant.m_41720_()).onEnchantment(toEnchant, list));
            }
            if (!player.m_150110_().f_35937_) {
                lapis.m_41774_(cost);
                if (lapis.m_41619_()) {
                    this.f_39449_.m_6836_(1, ItemStack.f_41583_);
                }
            }
            player.m_36220_(Stats.f_12964_);
            if (player instanceof ServerPlayer) {
                ((EnchantedTrigger)CriteriaTriggers.f_10575_).trigger((ServerPlayer)player, enchanted, level, eterna, quanta, arcana, rectification);
            }
            this.f_39449_.m_6596_();
            this.f_39452_.m_6422_(player.m_36322_());
            this.m_6199_(this.f_39449_);
            world.m_5594_((Player)null, pos, SoundEvents.f_11887_, SoundSource.BLOCKS, 1.0f, world.f_46441_.m_188501_() * 0.1f + 0.9f);
        });
        return true;
    }

    public void m_6199_(Container inventoryIn) {
        this.f_39450_.m_6721_((world, pos) -> {
            if (inventoryIn == this.f_39449_) {
                ItemStack toEnchant = inventoryIn.m_8020_(0);
                this.gatherStats();
                EnchantingRecipe match = EnchantingRecipe.findItemMatch(world, toEnchant);
                if (toEnchant.m_41613_() == 1 && (match != null || toEnchant.m_41720_().m_8120_(toEnchant) && ApothEnchantmentMenu.isEnchantableEnough(toEnchant))) {
                    int slot;
                    float eterna = this.stats.eterna();
                    if ((double)eterna < 1.5) {
                        eterna = 1.5f;
                    }
                    this.f_39451_.m_188584_((long)this.f_39452_.m_6501_());
                    for (slot = 0; slot < 3; ++slot) {
                        this.f_39446_[slot] = RealEnchantmentHelper.getEnchantmentCost(this.f_39451_, slot, eterna, toEnchant);
                        this.f_39447_[slot] = -1;
                        this.f_39448_[slot] = -1;
                        if (this.f_39446_[slot] < slot + 1) {
                            int n = slot;
                            this.f_39446_[n] = this.f_39446_[n] + 1;
                        }
                        this.f_39446_[slot] = ForgeEventFactory.onEnchantmentLevelSet((Level)world, (BlockPos)pos, (int)slot, (int)Math.round(eterna), (ItemStack)toEnchant, (int)this.f_39446_[slot]);
                    }
                    for (slot = 0; slot < 3; ++slot) {
                        List<EnchantmentInstance> list;
                        if (this.f_39446_[slot] <= 0 || (list = this.m_39471_(toEnchant, slot, this.f_39446_[slot])) == null || list.isEmpty()) continue;
                        EnchantmentInstance enchantmentdata = list.remove(this.f_39451_.m_188503_(list.size()));
                        this.f_39447_[slot] = BuiltInRegistries.f_256876_.m_7447_((Object)enchantmentdata.f_44947_);
                        this.f_39448_[slot] = enchantmentdata.f_44948_;
                        int clues = this.stats.clues();
                        ArrayList<EnchantmentInstance> clueList = new ArrayList<EnchantmentInstance>();
                        if (clues-- > 0) {
                            clueList.add(enchantmentdata);
                        }
                        while (clues-- > 0 && !list.isEmpty()) {
                            clueList.add(list.remove(this.f_39451_.m_188503_(list.size())));
                        }
                        PacketDistro.sendTo((SimpleChannel)Apotheosis.CHANNEL, (Object)new ClueMessage(slot, clueList, list.isEmpty()), (Player)this.player);
                    }
                    this.m_38946_();
                } else {
                    for (int i = 0; i < 3; ++i) {
                        this.f_39446_[i] = 0;
                        this.f_39447_[i] = -1;
                        this.f_39448_[i] = -1;
                    }
                    this.stats = TableStats.INVALID;
                    PacketDistro.sendTo((SimpleChannel)Apotheosis.CHANNEL, (Object)new StatsMessage(this.stats), (Player)this.player);
                }
            }
            return this;
        });
    }

    private List<EnchantmentInstance> m_39471_(ItemStack stack, int enchantSlot, int level) {
        this.f_39451_.m_188584_((long)(this.f_39452_.m_6501_() + enchantSlot));
        List<EnchantmentInstance> list = RealEnchantmentHelper.selectEnchantment(this.f_39451_, stack, level, this.stats.quanta(), this.stats.arcana(), this.stats.rectification(), this.stats.treasure(), this.stats.blacklist());
        EnchantingRecipe match = ((Optional)this.f_39450_.m_6721_((world, pos) -> Optional.ofNullable(EnchantingRecipe.findMatch(world, stack, this.stats.eterna(), this.stats.quanta(), this.stats.arcana()))).get()).orElse(null);
        if (enchantSlot == 2 && match != null) {
            list.clear();
            list.add(new EnchantmentInstance((Enchantment)Ench.Enchantments.INFUSION.get(), 1));
        }
        return list;
    }

    public void gatherStats() {
        this.f_39450_.m_6721_((world, pos) -> {
            this.stats = ApothEnchantmentMenu.gatherStats(world, pos, this.m_38853_(0).m_7993_().getEnchantmentValue());
            PacketDistro.sendTo((SimpleChannel)Apotheosis.CHANNEL, (Object)new StatsMessage(this.stats), (Player)this.player);
            return this;
        }).orElse(this);
    }

    public static TableStats gatherStats(Level level, BlockPos pos, int itemEnch) {
        TableStats.Builder builder = new TableStats.Builder(itemEnch);
        for (BlockPos offset : EnchantmentTableBlock.f_207902_) {
            if (!ApothEnchantmentMenu.canReadStatsFrom(level, pos, offset)) continue;
            ApothEnchantmentMenu.gatherStats(builder, level, pos.m_121955_((Vec3i)offset));
        }
        return builder.build();
    }

    public static boolean canReadStatsFrom(Level level, BlockPos tablePos, BlockPos offset) {
        return level.m_8055_(tablePos.m_7918_(offset.m_123341_() / 2, offset.m_123342_(), offset.m_123343_() / 2)).m_204336_(BlockTags.f_278486_);
    }

    public static void gatherStats(TableStats.Builder builder, Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (state.m_60795_()) {
            return;
        }
        float eterna = EnchantingStatRegistry.getEterna(state, world, pos);
        float max = EnchantingStatRegistry.getMaxEterna(state, world, pos);
        builder.addEterna(eterna, max);
        builder.addQuanta(EnchantingStatRegistry.getQuanta(state, world, pos));
        builder.addArcana(EnchantingStatRegistry.getArcana(state, world, pos));
        builder.addRectification(EnchantingStatRegistry.getQuantaRectification(state, world, pos));
        builder.addClues(EnchantingStatRegistry.getBonusClues(state, world, pos));
        ((IEnchantingBlock)state.m_60734_()).getBlacklistedEnchantments(state, (LevelReader)world, pos).forEach(builder::blacklistEnchant);
        if (((IEnchantingBlock)state.m_60734_()).allowsTreasure(state, (LevelReader)world, pos)) {
            builder.setAllowsTreasure(true);
        }
    }

    public MenuType<?> m_6772_() {
        return (MenuType)Apoth.Menus.ENCHANTING_TABLE.get();
    }

    public static boolean isEnchantableEnough(ItemStack stack) {
        if (!stack.m_41793_()) {
            return true;
        }
        return EnchantmentHelper.m_44831_((ItemStack)stack).keySet().stream().allMatch(Enchantment::m_6589_);
    }

    public record TableStats(float eterna, float quanta, float arcana, float rectification, int clues, Set<Enchantment> blacklist, boolean treasure) {
        public static TableStats INVALID = new TableStats(0.0f, 0.0f, 0.0f, 0.0f, 0, Collections.emptySet(), false);

        public TableStats(float eterna, float quanta, float arcana, float rectification, int clues, Set<Enchantment> blacklist, boolean treasure) {
            this.eterna = Mth.m_14036_((float)eterna, (float)0.0f, (float)EnchantingStatRegistry.getAbsoluteMaxEterna());
            this.quanta = Mth.m_14036_((float)quanta, (float)0.0f, (float)100.0f);
            this.arcana = Mth.m_14036_((float)arcana, (float)0.0f, (float)100.0f);
            this.rectification = Mth.m_14036_((float)rectification, (float)0.0f, (float)100.0f);
            this.clues = Math.max(clues, 0);
            this.blacklist = Collections.unmodifiableSet(blacklist);
            this.treasure = treasure;
        }

        public TableStats(float[] data, Set<Enchantment> blacklist, boolean treasure) {
            this(data[0], data[1], data[2], data[3], (int)data[4], blacklist, treasure);
        }

        public void write(FriendlyByteBuf buf) {
            buf.writeFloat(this.eterna);
            buf.writeFloat(this.quanta);
            buf.writeFloat(this.arcana);
            buf.writeFloat(this.rectification);
            buf.writeByte(this.clues);
            buf.writeShort(this.blacklist.size());
            for (Enchantment e : this.blacklist) {
                buf.m_130130_(BuiltInRegistries.f_256876_.m_7447_((Object)e));
            }
            buf.writeBoolean(this.treasure);
        }

        public static TableStats read(FriendlyByteBuf buf) {
            float[] data = new float[]{buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readByte()};
            int size = buf.readShort();
            HashSet<Enchantment> blacklist = new HashSet<Enchantment>(size);
            for (int i = 0; i < size; ++i) {
                blacklist.add((Enchantment)BuiltInRegistries.f_256876_.m_7942_(buf.m_130242_()));
            }
            boolean treasure = buf.readBoolean();
            return new TableStats(data, blacklist, treasure);
        }

        public static class Builder {
            private final Float2FloatMap eternaMap = new Float2FloatOpenHashMap();
            private final Set<Enchantment> blacklist = new HashSet<Enchantment>();
            private boolean allowsTreasure = false;
            private final float[] stats = new float[5];

            public Builder(int itemEnch) {
                this.addQuanta(15.0f);
                this.addArcana((float)itemEnch / 2.0f);
                this.addClues(1);
            }

            public void addEterna(float eterna, float max) {
                this.eternaMap.put(max, this.eternaMap.getOrDefault(max, 0.0f) + eterna);
            }

            public void addQuanta(float quanta) {
                this.stats[1] = this.stats[1] + quanta;
            }

            public void addArcana(float arcana) {
                this.stats[2] = this.stats[2] + arcana;
            }

            public void addRectification(float rectification) {
                this.stats[3] = this.stats[3] + rectification;
            }

            public void addClues(int clues) {
                this.stats[4] = this.stats[4] + (float)clues;
            }

            public void blacklistEnchant(Enchantment ench) {
                this.blacklist.add(ench);
            }

            public void setAllowsTreasure(boolean allowsTreasure) {
                this.allowsTreasure = allowsTreasure;
            }

            public TableStats build() {
                ArrayList entries = new ArrayList(this.eternaMap.float2FloatEntrySet());
                Collections.sort(entries, Comparator.comparing(Float2FloatMap.Entry::getFloatKey));
                for (Float2FloatMap.Entry e : entries) {
                    if (e.getFloatKey() > 0.0f) {
                        this.stats[0] = Math.min(e.getFloatKey(), this.stats[0] + e.getFloatValue());
                        continue;
                    }
                    this.stats[0] = this.stats[0] + e.getFloatValue();
                }
                return new TableStats(this.stats, this.blacklist, this.allowsTreasure);
            }
        }
    }

    public static enum Arcana {
        EMPTY(0.0f, 10, 5, 2, 1),
        LITTLE(10.0f, 8, 5, 3, 1),
        FEW(20.0f, 7, 5, 4, 2),
        SOME(30.0f, 5, 5, 4, 2),
        LESS(40.0f, 5, 5, 4, 3),
        MEDIUM(50.0f, 5, 5, 5, 5),
        MORE(60.0f, 3, 4, 5, 5),
        VALUE(70.0f, 2, 4, 5, 5),
        EXTRA(80.0f, 2, 4, 5, 7),
        ALMOST(90.0f, 1, 3, 5, 8),
        MAX(99.0f, 1, 2, 5, 10);

        final float threshold;
        final int[] rarities;
        static Arcana[] VALUES;

        private Arcana(float threshold, int ... rarities) {
            this.threshold = threshold;
            this.rarities = rarities;
        }

        public int[] getRarities() {
            return this.rarities;
        }

        public static Arcana getForThreshold(float threshold) {
            for (int i = VALUES.length - 1; i >= 0; --i) {
                if (!(threshold >= Arcana.VALUES[i].threshold)) continue;
                return VALUES[i];
            }
            return EMPTY;
        }

        static {
            VALUES = Arcana.values();
        }
    }
}

