/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixType;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;

public class PsychicAffix
extends Affix {
    public static final Codec<PsychicAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)GemBonus.VALUES_CODEC.fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, PsychicAffix::new));
    protected final Map<LootRarity, StepFunction> values;

    public PsychicAffix(Map<LootRarity, StepFunction> values) {
        super(AffixType.ABILITY);
        this.values = values;
    }

    @Override
    public MutableComponent getDescription(ItemStack stack, LootRarity rarity, float level) {
        return Component.m_237110_((String)("affix." + String.valueOf(this.getId()) + ".desc"), (Object[])new Object[]{PsychicAffix.fmt(100.0f * this.getTrueLevel(rarity, level))});
    }

    @Override
    public Component getAugmentingText(ItemStack stack, LootRarity rarity, float level) {
        MutableComponent comp = this.getDescription(stack, rarity, level);
        MutableComponent minComp = Component.m_237110_((String)"%s%%", (Object[])new Object[]{PsychicAffix.fmt(100.0f * this.getTrueLevel(rarity, 0.0f))});
        MutableComponent maxComp = Component.m_237110_((String)"%s%%", (Object[])new Object[]{PsychicAffix.fmt(100.0f * this.getTrueLevel(rarity, 1.0f))});
        return comp.m_7220_((Component)PsychicAffix.valueBounds((Component)minComp, (Component)maxComp));
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootCategory cat, LootRarity rarity) {
        return cat == LootCategory.SHIELD && this.values.containsKey(rarity);
    }

    @Override
    public float onShieldBlock(ItemStack stack, LootRarity rarity, float level, LivingEntity entity, DamageSource source, float amount) {
        Projectile arrow;
        Entity owner;
        Entity entity2 = source.m_7640_();
        if (entity2 instanceof Projectile && (owner = (arrow = (Projectile)entity2).m_19749_()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)owner;
            living.m_6469_(entity.m_269291_().m_269298_(Apoth.DamageTypes.PSYCHIC, (Entity)entity), amount * this.getTrueLevel(rarity, level));
        }
        return super.onShieldBlock(stack, rarity, level, entity, source, amount);
    }

    private float getTrueLevel(LootRarity rarity, float level) {
        return this.values.get(rarity).get(level);
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }
}

