/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.augmenting;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.shadowsoffire.apotheosis.adventure.affix.augmenting.AugmentingTableTile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import org.joml.Quaternionf;

public class AugmentingTableTileRenderer
implements BlockEntityRenderer<AugmentingTableTile> {
    public static final ResourceLocation STAR_CUBE = new ResourceLocation("apotheosis", "item/star_cube");

    public void render(AugmentingTableTile tile, float partials, PoseStack matrix, MultiBufferSource pBufferSource, int light, int overlay) {
        if (tile.stage == AugmentingTableTile.AnimationStage.HIDING) {
            return;
        }
        Minecraft.m_91087_().f_90987_.m_118506_(InventoryMenu.f_39692_).m_117960_(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ItemRenderer irenderer = Minecraft.m_91087_().m_91291_();
        BakedModel base = irenderer.m_115103_().m_109393_().getModel(STAR_CUBE);
        double px = 0.0625;
        long time = tile.time;
        matrix.m_85836_();
        matrix.m_85837_(5.0 * px, 5.0 * px, 5.0 * px);
        switch (tile.stage) {
            case HIDING: {
                break;
            }
            case RISING: {
                float progress = ((float)time + partials) / (float)AugmentingTableTile.RISE_TIME;
                double rise = Mth.m_14139_((double)progress, (double)(0.1 * px), (double)(11.0 * px));
                matrix.m_85837_(0.0, rise, 0.0);
                break;
            }
            case FALLING: {
                float progress = ((float)((long)AugmentingTableTile.RISE_TIME - time) + partials) / (float)AugmentingTableTile.RISE_TIME;
                double rise = Mth.m_14139_((double)progress, (double)(11.0 * px), (double)(0.1 * px));
                matrix.m_85837_(0.0, rise, 0.0);
                break;
            }
            case SPINNING: {
                float rotation = ((float)(time % 360L) + partials) * (float)Math.PI / 180.0f;
                matrix.m_85837_(0.0, 11.0 * px, 0.0);
                matrix.m_85837_(3.0 * px, 3.0 * px, 3.0 * px);
                matrix.m_252781_(new Quaternionf().rotationXYZ(rotation, 0.0f, rotation));
                matrix.m_85837_(-3.0 * px, -3.0 * px, -3.0 * px);
            }
        }
        irenderer.m_115189_(base, ItemStack.f_41583_, light, overlay, matrix, ItemRenderer.m_115222_((MultiBufferSource)pBufferSource, (RenderType)Sheets.m_110791_(), (boolean)true, (boolean)false));
        matrix.m_85849_();
    }
}

