/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.augmenting;

import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.adventure.Adventure;
import dev.shadowsoffire.placebo.block_entity.TickingBlockEntity;
import dev.shadowsoffire.placebo.cap.InternalItemHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class AugmentingTableTile
extends BlockEntity
implements TickingBlockEntity {
    public static int RISE_TIME = 30;
    public static int SPIN_CYCLE_TIME = 90;
    public int time = 0;
    public AnimationStage stage = AnimationStage.HIDING;
    protected InternalItemHandler inv = new InternalItemHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.m_150930_((Item)Adventure.Items.SIGIL_OF_ENHANCEMENT.get());
        }

        protected void onContentsChanged(int slot) {
            AugmentingTableTile.this.m_6596_();
        }
    };
    LazyOptional<IItemHandler> invCap = LazyOptional.of(() -> this.inv);

    public AugmentingTableTile(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)Apoth.Tiles.AUGMENTING_TABLE.get(), pPos, pBlockState);
    }

    public void clientTick(Level pLevel, BlockPos pPos, BlockState pState) {
        Player player = pLevel.m_45924_((double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5, 4.0, false);
        switch (this.stage) {
            case HIDING: {
                if (player == null) break;
                this.stage = AnimationStage.RISING;
                this.time = 0;
                break;
            }
            case RISING: {
                if (player != null) {
                    ++this.time;
                    if (this.time < RISE_TIME) break;
                    this.stage = AnimationStage.SPINNING;
                    this.time = 0;
                    break;
                }
                this.stage = AnimationStage.FALLING;
                break;
            }
            case FALLING: {
                if (player != null) {
                    this.stage = AnimationStage.RISING;
                    break;
                }
                --this.time;
                if (this.time > 0) break;
                this.stage = AnimationStage.HIDING;
                this.time = 0;
                break;
            }
            case SPINNING: {
                ++this.time;
                if (player != null || this.time % SPIN_CYCLE_TIME != 0) break;
                this.stage = AnimationStage.FALLING;
                this.time = RISE_TIME;
            }
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inventory", (Tag)this.inv.serializeNBT());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inv.deserializeNBT(tag.m_128469_("inventory"));
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.invCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.invCap.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.invCap = LazyOptional.of(() -> this.inv);
    }

    public static enum AnimationStage {
        HIDING,
        RISING,
        FALLING,
        SPINNING;

    }
}

