/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.adventure.AdventureModule;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixType;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.GemItem;
import dev.shadowsoffire.apotheosis.adventure.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.attributeslib.AttributesLib;
import dev.shadowsoffire.attributeslib.api.IFormattableAttribute;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class AttributeAffix
extends Affix {
    public static final Codec<AttributeAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ForgeRegistries.ATTRIBUTES.getCodec().fieldOf("attribute").forGetter(a -> a.attribute), (App)PlaceboCodecs.enumCodec(AttributeModifier.Operation.class).fieldOf("operation").forGetter(a -> a.operation), (App)GemBonus.VALUES_CODEC.fieldOf("values").forGetter(a -> a.values), (App)LootCategory.SET_CODEC.fieldOf("types").forGetter(a -> a.types)).apply((Applicative)inst, AttributeAffix::new));
    protected final Attribute attribute;
    protected final AttributeModifier.Operation operation;
    protected final Map<LootRarity, StepFunction> values;
    protected final Set<LootCategory> types;
    protected final transient Map<LootRarity, ModifierInst> modifiers;

    public AttributeAffix(Attribute attr, AttributeModifier.Operation op, Map<LootRarity, StepFunction> values, Set<LootCategory> types) {
        super(AffixType.STAT);
        this.attribute = attr;
        this.operation = op;
        this.values = values;
        this.types = types;
        this.modifiers = values.entrySet().stream().map(entry -> Pair.of((Object)((LootRarity)entry.getKey()), (Object)new ModifierInst(attr, op, (StepFunction)entry.getValue()))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }

    @Override
    public MutableComponent getDescription(ItemStack stack, LootRarity rarity, float level) {
        return Component.m_237119_();
    }

    @Override
    public Component getAugmentingText(ItemStack stack, LootRarity rarity, float level) {
        ModifierInst modif = this.modifiers.get(rarity);
        double value = modif.valueFactory.get(level);
        MutableComponent valueComp = IFormattableAttribute.toValueComponent((Attribute)this.attribute, (AttributeModifier.Operation)this.operation, (double)(value < 0.0 ? -value : value), (TooltipFlag)AttributesLib.getTooltipFlag());
        MutableComponent comp = value > 0.0 ? Component.m_237110_((String)"attributeslib.modifier.plus", (Object[])new Object[]{valueComp, Component.m_237115_((String)this.attribute.m_22087_())}).m_130940_(ChatFormatting.BLUE) : Component.m_237110_((String)"attributeslib.modifier.take", (Object[])new Object[]{valueComp, Component.m_237115_((String)this.attribute.m_22087_())}).m_130940_(ChatFormatting.RED);
        if (modif.valueFactory.get(0.0f) != modif.valueFactory.get(1.0f)) {
            MutableComponent minComp = IFormattableAttribute.toValueComponent((Attribute)this.attribute, (AttributeModifier.Operation)this.operation, (double)modif.valueFactory.get(0.0f), (TooltipFlag)AttributesLib.getTooltipFlag());
            MutableComponent maxComp = IFormattableAttribute.toValueComponent((Attribute)this.attribute, (AttributeModifier.Operation)this.operation, (double)modif.valueFactory.get(1.0f), (TooltipFlag)AttributesLib.getTooltipFlag());
            comp.m_7220_((Component)AttributeAffix.valueBounds((Component)minComp, (Component)maxComp));
        }
        return comp;
    }

    @Override
    public void addModifiers(ItemStack stack, LootRarity rarity, float level, EquipmentSlot type, BiConsumer<Attribute, AttributeModifier> map) {
        LootCategory cat = LootCategory.forItem(stack);
        if (cat.isNone()) {
            AdventureModule.LOGGER.debug("Attempted to apply the attributes of affix {} on item {}, but it is not an affix-compatible item!", (Object)this.getId(), (Object)stack.m_41786_().getString());
            return;
        }
        ModifierInst modif = this.modifiers.get(rarity);
        if (modif.attr == null) {
            AdventureModule.LOGGER.debug("The affix {} has attempted to apply a null attribute modifier to {}!", (Object)this.getId(), (Object)stack.m_41786_().getString());
            return;
        }
        for (EquipmentSlot slot : cat.getSlots()) {
            if (slot != type) continue;
            map.accept(modif.attr, modif.build(stack, this.getId(), level));
        }
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootCategory cat, LootRarity rarity) {
        if (cat.isNone()) {
            return false;
        }
        return (this.types.isEmpty() || this.types.contains(cat)) && this.modifiers.containsKey(rarity);
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }

    public record ModifierInst(Attribute attr, AttributeModifier.Operation op, StepFunction valueFactory) {
        private static UUID getOrCreateUUID(ItemStack stack, ResourceLocation id) {
            CompoundTag tag = stack.m_41737_("affix_data");
            return GemItem.getOrCreateUUIDs(tag, 1).get(0);
        }

        public AttributeModifier build(ItemStack stack, ResourceLocation id, float level) {
            return new AttributeModifier(ModifierInst.getOrCreateUUID(stack, id), "affix:" + String.valueOf(id), (double)this.valueFactory.get(level), this.op);
        }
    }
}

