/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.slopepanel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.shapes.CommonShapes;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.common.block.slopepanel.SlopePanelShape;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.shapes.SplitShapeGenerator;
import xfacthd.framedblocks.common.data.shapes.slopepanel.SlopePanelShapes;

public final class ExtendedSlopePanelShapes
implements SplitShapeGenerator {
    public static final ExtendedSlopePanelShapes INSTANCE = new ExtendedSlopePanelShapes();
    public static final ShapeCache<HorizontalRotation> SHAPES = ExtendedSlopePanelShapes.makeCache(SlopePanelShapes.SHAPES);
    public static final ShapeCache<HorizontalRotation> OCCLUSION_SHAPES = ExtendedSlopePanelShapes.makeCache(SlopePanelShapes.OCCLUSION_SHAPES);
    private static final ShapeCache<ShapeKey> FINAL_SHAPES = ExtendedSlopePanelShapes.makeFinalCache(SHAPES);
    private static final ShapeCache<ShapeKey> FINAL_OCCLUSION_SHAPES = ExtendedSlopePanelShapes.makeFinalCache(OCCLUSION_SHAPES);

    private ExtendedSlopePanelShapes() {
    }

    @Override
    public ShapeProvider generate(ImmutableList<BlockState> states) {
        return ExtendedSlopePanelShapes.generate(states, FINAL_SHAPES);
    }

    @Override
    public ShapeProvider generateOcclusionShapes(ImmutableList<BlockState> states) {
        return ExtendedSlopePanelShapes.generate(states, FINAL_OCCLUSION_SHAPES);
    }

    private static ShapeProvider generate(ImmutableList<BlockState> states, ShapeCache<ShapeKey> cache) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            HorizontalRotation rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
            builder.put((Object)state, (Object)cache.get(new ShapeKey(dir, rot)));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    private static ShapeCache<HorizontalRotation> makeCache(ShapeCache<SlopePanelShape> slopePanelCache) {
        return ShapeCache.createEnum(HorizontalRotation.class, map -> {
            VoxelShape shapePanel = CommonShapes.PANEL.get(Direction.NORTH);
            for (HorizontalRotation rot : HorizontalRotation.values()) {
                VoxelShape shape = ShapeUtils.orUnoptimized(shapePanel, slopePanelCache.get(SlopePanelShape.get(rot, true)));
                map.put(rot, shape);
            }
        });
    }

    private static ShapeCache<ShapeKey> makeFinalCache(ShapeCache<HorizontalRotation> cache) {
        return ShapeCache.create(map -> {
            for (HorizontalRotation rot : HorizontalRotation.values()) {
                ShapeUtils.makeHorizontalRotations(cache.get(rot), Direction.NORTH, map, rot, ShapeKey::new);
            }
        });
    }

    private record ShapeKey(Direction dir, HorizontalRotation rot) {
    }
}

