/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.slope;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.common.data.shapes.SplitShapeGenerator;

public final class PrismCornerShapes
implements SplitShapeGenerator {
    public static final PrismCornerShapes OUTER = new PrismCornerShapes(() -> ShapeUtils.orUnoptimized(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)4.0), Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)8.0), Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)4.0, (double)12.0), Block.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)4.0, (double)16.0), Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)12.0, (double)8.0, (double)4.0), Block.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)8.0, (double)8.0, (double)8.0), Block.m_49796_((double)0.0, (double)4.0, (double)8.0, (double)4.0, (double)8.0, (double)12.0), Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)12.0, (double)4.0), Block.m_49796_((double)0.0, (double)8.0, (double)4.0, (double)4.0, (double)12.0, (double)8.0), Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)4.0, (double)16.0, (double)4.0)), () -> ShapeUtils.orUnoptimized(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)0.5, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)4.0, (double)15.5), Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)4.0, (double)8.0, (double)12.0), Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0), Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)4.0, (double)15.5, (double)4.0), Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)0.5, (double)16.0, (double)0.5), Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)8.0, (double)4.0, (double)12.0), Block.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0), Block.m_49796_((double)4.0, (double)8.0, (double)0.0, (double)8.0, (double)12.0, (double)4.0), Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)8.0), Block.m_49796_((double)8.0, (double)4.0, (double)0.0, (double)12.0, (double)8.0, (double)4.0), Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)15.5, (double)4.0, (double)4.0), Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)0.5)));
    public static final PrismCornerShapes INNER = new PrismCornerShapes(() -> ShapeUtils.orUnoptimized(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)12.0), Block.m_49796_((double)0.0, (double)4.0, (double)12.0, (double)12.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)8.0), Block.m_49796_((double)0.0, (double)8.0, (double)12.0, (double)8.0, (double)12.0, (double)16.0), Block.m_49796_((double)0.0, (double)8.0, (double)8.0, (double)12.0, (double)12.0, (double)12.0), Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), Block.m_49796_((double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)16.0, (double)8.0), Block.m_49796_((double)0.0, (double)12.0, (double)8.0, (double)8.0, (double)16.0, (double)12.0), Block.m_49796_((double)0.0, (double)12.0, (double)12.0, (double)4.0, (double)16.0, (double)16.0)), () -> ShapeUtils.orUnoptimized(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)15.5), Block.m_49796_((double)0.0, (double)0.0, (double)15.5, (double)15.5, (double)4.0, (double)16.0), Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)12.0, (double)8.0, (double)16.0), Block.m_49796_((double)12.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)12.0), Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)8.0), Block.m_49796_((double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)12.0, (double)16.0), Block.m_49796_((double)8.0, (double)8.0, (double)8.0, (double)12.0, (double)12.0, (double)12.0), Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)15.5, (double)4.0), Block.m_49796_((double)0.0, (double)15.5, (double)0.0, (double)15.5, (double)16.0, (double)4.0), Block.m_49796_((double)15.5, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)0.5), Block.m_49796_((double)0.0, (double)12.0, (double)4.0, (double)4.0, (double)15.5, (double)16.0), Block.m_49796_((double)0.0, (double)15.5, (double)4.0, (double)4.0, (double)16.0, (double)15.5), Block.m_49796_((double)0.0, (double)15.5, (double)15.5, (double)0.5, (double)16.0, (double)16.0), Block.m_49796_((double)4.0, (double)12.0, (double)4.0, (double)8.0, (double)16.0, (double)12.0), Block.m_49796_((double)8.0, (double)12.0, (double)4.0, (double)12.0, (double)16.0, (double)8.0)));
    private final Supplier<VoxelShape> bottomShape;
    private final Supplier<VoxelShape> bottomOcclusionShape;

    public PrismCornerShapes(Supplier<VoxelShape> bottomShape, Supplier<VoxelShape> bottomOcclusionShape) {
        this.bottomShape = bottomShape;
        this.bottomOcclusionShape = bottomOcclusionShape;
    }

    @Override
    public ShapeProvider generate(ImmutableList<BlockState> states) {
        return PrismCornerShapes.generate(states, this.bottomShape);
    }

    @Override
    public ShapeProvider generateOcclusionShapes(ImmutableList<BlockState> states) {
        return PrismCornerShapes.generate(states, this.bottomOcclusionShape);
    }

    private static ShapeProvider generate(ImmutableList<BlockState> states, Supplier<VoxelShape> bottomShape) {
        VoxelShape shapeBottom = bottomShape.get();
        VoxelShape shapeTop = ShapeUtils.rotateShape(Direction.NORTH, Direction.WEST, ShapeUtils.rotateShapeUnoptimizedAroundZ(Direction.DOWN, Direction.UP, shapeBottom));
        VoxelShape[] shapes = ShapeUtils.makeHorizontalRotationsWithFlag(shapeBottom, shapeTop, Direction.NORTH);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            builder.put((Object)state, (Object)shapes[dir.m_122416_() + (top ? 4 : 0)]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

