/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.slab;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.shapes.CommonShapes;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;

public final class MasonryCornerSegmentShapes {
    public static ShapeProvider generate(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape preShapeBottom = ShapeUtils.orUnoptimized(CommonShapes.SLAB_EDGE.get(new CommonShapes.DirBoolKey(Direction.SOUTH, false)), CommonShapes.SLAB_EDGE.get(new CommonShapes.DirBoolKey(Direction.EAST, true)));
        VoxelShape preShapeTop = ShapeUtils.orUnoptimized(CommonShapes.SLAB_EDGE.get(new CommonShapes.DirBoolKey(Direction.EAST, false)), CommonShapes.SLAB_EDGE.get(new CommonShapes.DirBoolKey(Direction.SOUTH, true)));
        VoxelShape[] shapes = ShapeUtils.makeHorizontalRotationsWithFlag(preShapeBottom, preShapeTop, Direction.NORTH);
        for (BlockState state : states) {
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            builder.put((Object)state, (Object)shapes[dir.m_122416_() + (top ? 4 : 0)]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    private MasonryCornerSegmentShapes() {
    }
}

