/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slopepanelcorner;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.ExtPlacementStateBuilder;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;

public class FramedCornerSlopePanelWallBlock
extends FramedBlock {
    private final boolean large;

    public FramedCornerSlopePanelWallBlock(BlockType type) {
        super(type);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(true)));
        this.large = type == BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL_W || type == BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL_W;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.ROTATION, FramedProperties.Y_SLOPE, BlockStateProperties.f_61362_});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return FramedCornerSlopePanelWallBlock.getStateForPlacement(this, ctx, this.large);
    }

    public static BlockState getStateForPlacement(Block block, BlockPlaceContext ctx, boolean invert) {
        return ((ExtPlacementStateBuilder)((ExtPlacementStateBuilder)ExtPlacementStateBuilder.of(block, ctx).withHorizontalTargetFacing()).withCornerRotation(!invert).tryWithWater()).build();
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, BlockHitResult hit, Rotation rot) {
        Direction side = hit.m_82434_();
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation rotation = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
        Direction rotDir = rotation.withFacing(dir);
        Direction perpRotDir = rotation.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(dir);
        switch ((BlockType)this.getBlockType()) {
            case FRAMED_SMALL_CORNER_SLOPE_PANEL_W: 
            case FRAMED_LARGE_CORNER_SLOPE_PANEL_W: {
                if (side != rotDir.m_122424_() && side != perpRotDir.m_122424_()) break;
                side = dir;
                break;
            }
            case FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_W: 
            case FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL_W: {
                if (side != rotDir && side != perpRotDir) break;
                Vec3 hitVec = hit.m_82450_();
                double paralell = Utils.fractionInDir(hitVec, dir);
                double perp = Utils.fractionInDir(hitVec, side == rotDir ? perpRotDir : rotDir) - 0.5;
                if (!(perp * 2.0 > paralell)) break;
                side = dir;
            }
        }
        return this.rotate(state, side, rot);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        if (face.m_122434_() == dir.m_122434_()) {
            HorizontalRotation rotation = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
            return (BlockState)state.m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)rotation.rotate(rot)));
        }
        if (Utils.isY(face)) {
            return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(dir));
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return this.rotate(state, (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR), rot);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return FramedCornerSlopePanelWallBlock.mirrorCornerPanel(state, mirror);
    }

    public static BlockState mirrorCornerPanel(BlockState state, Mirror mirror) {
        HorizontalRotation rot;
        if (mirror == Mirror.NONE) {
            return state;
        }
        BlockState newState = Utils.mirrorFaceBlock(state, mirror);
        rot = rot.rotate((rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION))).isVertical() ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90);
        return (BlockState)newState.m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)rot));
    }
}

