/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.block.render;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import xfacthd.framedblocks.common.FBContent;

public final class ParticleHelper {
    public static void spawnLandingParticles(BlockState state, ServerLevel level, BlockPos pos, LivingEntity entity, int count) {
        if (state.m_60795_()) {
            state = ((Block)FBContent.BLOCK_FRAMED_CUBE.get()).m_49966_();
        }
        double x = entity.m_20185_();
        double y = entity.m_20186_();
        double z = entity.m_20189_();
        BlockPos entityPos = entity.m_20183_();
        if (pos.m_123341_() != entityPos.m_123341_() || pos.m_123343_() != entityPos.m_123343_()) {
            double offX = x - (double)pos.m_123341_() - 0.5;
            double offZ = z - (double)pos.m_123343_() - 0.5;
            double maxOff = Math.max(Math.abs(offX), Math.abs(offZ));
            x = (double)pos.m_123341_() + 0.5 + offX / maxOff * 0.5;
            z = (double)pos.m_123343_() + 0.5 + offZ / maxOff * 0.5;
        }
        level.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), x, y, z, count, 0.0, 0.0, 0.0, 0.15);
    }

    public static void spawnRunningParticles(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (state.m_60795_()) {
            state = ((Block)FBContent.BLOCK_FRAMED_CUBE.get()).m_49966_();
        }
        Vec3 delta = entity.m_20184_();
        BlockPos enityPos = entity.m_20183_();
        double x = entity.m_20208_(0.5);
        double z = entity.m_20262_(0.5);
        if (enityPos.m_123341_() != pos.m_123341_()) {
            x = Mth.m_14008_((double)x, (double)pos.m_123341_(), (double)((double)pos.m_123341_() + 1.0));
        }
        if (enityPos.m_123343_() != pos.m_123343_()) {
            z = Mth.m_14008_((double)z, (double)pos.m_123343_(), (double)((double)pos.m_123343_() + 1.0));
        }
        level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), x, entity.m_20186_() + 0.1, z, delta.f_82479_ * -4.0, 1.5, delta.f_82481_ * -4.0);
    }

    private ParticleHelper() {
    }

    public static final class Client {
        public static void addHitEffects(BlockState state, Level level, BlockHitResult target, BlockState camoState, ParticleEngine engine) {
            if (camoState.m_60795_()) {
                camoState = ((Block)FBContent.BLOCK_FRAMED_CUBE.get()).m_49966_();
            }
            BlockPos pos = target.m_82425_();
            Direction side = target.m_82434_();
            double bx = pos.m_123341_();
            double by = pos.m_123342_();
            double bz = pos.m_123343_();
            AABB aabb = state.m_60808_((BlockGetter)level, pos).m_83215_();
            double x = bx + engine.f_107292_.m_188500_() * (aabb.f_82291_ - aabb.f_82288_ - 0.2) + 0.1 + aabb.f_82288_;
            double y = by + engine.f_107292_.m_188500_() * (aabb.f_82292_ - aabb.f_82289_ - 0.2) + 0.1 + aabb.f_82289_;
            double z = bz + engine.f_107292_.m_188500_() * (aabb.f_82293_ - aabb.f_82290_ - 0.2) + 0.1 + aabb.f_82290_;
            switch (side) {
                case DOWN: {
                    y = by + aabb.f_82289_ - (double)0.1f;
                    break;
                }
                case UP: {
                    y = by + aabb.f_82292_ + (double)0.1f;
                    break;
                }
                case NORTH: {
                    z = bz + aabb.f_82290_ - (double)0.1f;
                    break;
                }
                case SOUTH: {
                    z = bz + aabb.f_82293_ + (double)0.1f;
                    break;
                }
                case WEST: {
                    x = bx + aabb.f_82288_ - (double)0.1f;
                    break;
                }
                case EAST: {
                    x = bx + aabb.f_82291_ + (double)0.1f;
                }
            }
            engine.m_107344_(new TerrainParticle((ClientLevel)level, x, y, z, 0.0, 0.0, 0.0, camoState, pos).m_107268_(0.2f).m_6569_(0.6f));
        }

        public static void addDestroyEffects(BlockState state, Level level, BlockPos pos, BlockState camoState, ParticleEngine engine) {
            if (camoState.m_60795_()) {
                camoState = ((Block)FBContent.BLOCK_FRAMED_CUBE.get()).m_49966_();
            }
            BlockState fCamoState = camoState;
            state.m_60808_((BlockGetter)level, pos).m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                double sizeX = Math.min(1.0, maxX - minX);
                double sizeY = Math.min(1.0, maxY - minY);
                double sizeZ = Math.min(1.0, maxZ - minZ);
                int xCount = Math.max(2, Mth.m_14165_((double)(sizeX / 0.25)));
                int yCount = Math.max(2, Mth.m_14165_((double)(sizeY / 0.25)));
                int zCount = Math.max(2, Mth.m_14165_((double)(sizeZ / 0.25)));
                for (int iX = 0; iX < xCount; ++iX) {
                    for (int iY = 0; iY < yCount; ++iY) {
                        for (int iZ = 0; iZ < zCount; ++iZ) {
                            double offX = ((double)iX + 0.5) / (double)xCount;
                            double offY = ((double)iY + 0.5) / (double)yCount;
                            double offZ = ((double)iZ + 0.5) / (double)zCount;
                            double x = (double)pos.m_123341_() + offX * sizeX + minX;
                            double y = (double)pos.m_123342_() + offY * sizeY + minY;
                            double z = (double)pos.m_123343_() + offZ * sizeZ + minZ;
                            engine.m_107344_((Particle)new TerrainParticle((ClientLevel)level, x, y, z, offX - 0.5, offY - 0.5, offZ - 0.5, fCamoState, pos));
                        }
                    }
                }
            });
        }

        private Client() {
        }
    }
}

