/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.monitor.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.varia.LogicFacing;
import mcjty.rftoolspower.modules.monitor.MonitorModule;
import mcjty.rftoolspower.modules.monitor.blocks.PowerLevelTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.ModelBuilder;

public class PowerLevelRenderer
implements BlockEntityRenderer<PowerLevelTileEntity> {
    public static final ResourceLocation[] DIGITS = new ResourceLocation[]{new ResourceLocation("rftoolspower", "block/monitor/powerlevel_0"), new ResourceLocation("rftoolspower", "block/monitor/powerlevel_1"), new ResourceLocation("rftoolspower", "block/monitor/powerlevel_2"), new ResourceLocation("rftoolspower", "block/monitor/powerlevel_3"), new ResourceLocation("rftoolspower", "block/monitor/powerlevel_4"), new ResourceLocation("rftoolspower", "block/monitor/powerlevel_5"), new ResourceLocation("rftoolspower", "block/monitor/powerlevel_6"), new ResourceLocation("rftoolspower", "block/monitor/powerlevel_7"), new ResourceLocation("rftoolspower", "block/monitor/powerlevel_8"), new ResourceLocation("rftoolspower", "block/monitor/powerlevel_9")};

    public PowerLevelRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(PowerLevelTileEntity te, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110463_());
        BlockState state = te.m_58904_().m_8055_(te.m_58899_());
        Block block = state.m_60734_();
        if (!(block instanceof LogicSlabBlock)) {
            return;
        }
        matrixStack.m_85836_();
        LogicFacing logicFacing = (LogicFacing)state.m_61143_((Property)LogicSlabBlock.LOGIC_FACING);
        Direction facing = logicFacing.getSide();
        RenderHelper.adjustTransformToDirection((PoseStack)matrixStack, (Direction)facing);
        int level = te.getLogicSupport().getPowerOutput();
        if (level > 9) {
            level = 9;
        }
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(DIGITS[level]);
        ModelBuilder.FaceRotation rotation = ModelBuilder.FaceRotation.values()[logicFacing.getRotationStep()];
        RenderHelper.renderNorthSouthQuad((PoseStack)matrixStack, (VertexConsumer)builder, (TextureAtlasSprite)sprite, (ModelBuilder.FaceRotation)rotation, (float)0.73f);
        matrixStack.m_85849_();
    }

    public static void register() {
        BlockEntityRenderers.m_173590_(MonitorModule.TYPE_POWER_LEVEL.get(), PowerLevelRenderer::new);
    }
}

