/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.qio;

import java.util.HashSet;
import java.util.Map;
import java.util.function.Predicate;
import mekanism.api.functions.ConstantPredicates;
import mekanism.common.Mekanism;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.qio.TileEntityQIOFilterHandler;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class TileEntityQIOImporter
extends TileEntityQIOFilterHandler {
    private static final int MAX_DELAY = 10;
    private int delay = 0;
    private boolean importWithoutFilter = true;

    public TileEntityQIOImporter(BlockPos pos, BlockState state) {
        super(MekanismBlocks.QIO_IMPORTER, pos, state);
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        if (MekanismUtils.canFunction(this)) {
            if (this.delay > 0) {
                --this.delay;
                return;
            }
            this.tryImport();
            this.delay = 10;
        }
    }

    private void tryImport() {
        Predicate<Object> canFilter;
        QIOFrequency freq = this.getQIOFrequency();
        if (freq == null) {
            return;
        }
        Direction direction = this.getDirection();
        BlockEntity back = WorldUtils.getTileEntity((BlockGetter)this.m_58904_(), this.f_58858_.m_121945_(direction.m_122424_()));
        LazyOptional lazyCapability = CapabilityUtils.getCapability((ICapabilityProvider)back, ForgeCapabilities.ITEM_HANDLER, direction);
        if (!lazyCapability.isPresent()) {
            return;
        }
        if (this.getFilterManager().hasEnabledFilters()) {
            canFilter = stack -> this.getFilterManager().anyEnabledMatch(filter -> filter.getFinder().modifies((ItemStack)stack));
        } else if (this.importWithoutFilter) {
            canFilter = ConstantPredicates.alwaysTrue();
        } else {
            return;
        }
        IItemHandler inventory = (IItemHandler)lazyCapability.orElseThrow(MekanismUtils.MISSING_CAP_ERROR);
        int slots = inventory.getSlots();
        if (slots == 0) {
            return;
        }
        HashSet<HashedItem> typesAdded = new HashSet<HashedItem>();
        int maxTypes = this.getMaxTransitTypes();
        int maxCount = this.getMaxTransitCount();
        int countAdded = 0;
        for (int i = slots - 1; i >= 0; --i) {
            ItemStack ret;
            HashedItem type;
            ItemStack stack2 = inventory.extractItem(i, maxCount - countAdded, true);
            if (stack2.m_41619_() || !typesAdded.contains(type = HashedItem.create(stack2)) && typesAdded.size() == maxTypes || !canFilter.test(stack2)) continue;
            ItemStack used = TransporterManager.getToUse(stack2, freq.addItem(stack2));
            if (!InventoryUtils.areItemsStackable(used, ret = inventory.extractItem(i, used.m_41613_(), false)) || used.m_41613_() != ret.m_41613_()) {
                Mekanism.logger.error("QIO insertion error: item handler {} returned {} during simulated extraction, but returned {} during execution. This is wrong!", new Object[]{back, stack2, ret});
            }
            typesAdded.add(type);
            countAdded += used.m_41613_();
        }
    }

    @ComputerMethod
    public boolean getImportWithoutFilter() {
        return this.importWithoutFilter;
    }

    public void toggleImportWithoutFilter() {
        this.importWithoutFilter = !this.importWithoutFilter;
        this.markForSave();
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableBoolean.create(this::getImportWithoutFilter, value -> {
            this.importWithoutFilter = value;
        }));
    }

    @Override
    public void writeSustainedData(CompoundTag dataMap) {
        super.writeSustainedData(dataMap);
        dataMap.m_128379_("auto", this.importWithoutFilter);
    }

    @Override
    public void readSustainedData(CompoundTag dataMap) {
        super.readSustainedData(dataMap);
        NBTUtils.setBooleanIfPresent(dataMap, "auto", value -> {
            this.importWithoutFilter = value;
        });
    }

    @Override
    public Map<String, String> getTileDataRemap() {
        Map<String, String> remap = super.getTileDataRemap();
        remap.put("auto", "auto");
        return remap;
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void setImportsWithoutFilter(boolean value) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.importWithoutFilter != value) {
            this.toggleImportWithoutFilter();
        }
    }
}

