/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.distribution;

import mekanism.common.lib.distribution.SplitInfo;

public class IntegerSplitInfo
extends SplitInfo<Integer> {
    private int amountToSplit;
    private int amountPerTarget;
    private int sentSoFar;

    public IntegerSplitInfo(int amountToSplit, int totalTargets) {
        super(totalTargets);
        this.amountToSplit = amountToSplit;
        this.amountPerTarget = this.toSplitAmong == 0 ? 0 : amountToSplit / this.toSplitAmong;
    }

    @Override
    public void send(Integer amountNeeded) {
        this.amountToSplit -= amountNeeded.intValue();
        this.sentSoFar += amountNeeded.intValue();
        --this.toSplitAmong;
        if (amountNeeded != this.amountPerTarget && this.toSplitAmong != 0) {
            int amountPerLast = this.amountPerTarget;
            this.amountPerTarget = this.amountToSplit / this.toSplitAmong;
            if (!this.amountPerChanged && this.amountPerTarget != amountPerLast) {
                this.amountPerChanged = true;
            }
        }
    }

    @Override
    public Integer getShareAmount() {
        return this.amountPerTarget;
    }

    @Override
    public Integer getRemainderAmount() {
        return this.toSplitAmong == 0 ? this.amountPerTarget : this.amountPerTarget + this.amountToSplit % this.toSplitAmong;
    }

    @Override
    public Integer getTotalSent() {
        return this.sentSoFar;
    }
}

