/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.miner;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2BooleanOpenHashMap;
import java.util.BitSet;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.math.MathUtils;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import mekanism.common.tags.MekanismTags;
import mekanism.common.tile.TileEntityBoundingBlock;
import mekanism.common.tile.machine.TileEntityDigitalMiner;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class ThreadMinerSearch
extends Thread {
    private final TileEntityDigitalMiner tile;
    private final Long2ObjectMap<BitSet> oresToMine = new Long2ObjectOpenHashMap();
    private PathNavigationRegion chunkCache;
    public State state = State.IDLE;
    public int found = 0;

    public ThreadMinerSearch(TileEntityDigitalMiner tile) {
        this.tile = tile;
    }

    public void setChunkCache(PathNavigationRegion cache) {
        this.chunkCache = cache;
    }

    @Override
    public void run() {
        this.state = State.SEARCHING;
        if (!this.tile.getInverse() && !this.tile.getFilterManager().hasEnabledFilters()) {
            this.state = State.FINISHED;
            return;
        }
        Reference2BooleanOpenHashMap acceptedItems = new Reference2BooleanOpenHashMap();
        BlockPos pos = this.tile.getStartingPos();
        int diameter = this.tile.getDiameter();
        int size = this.tile.getTotalSize();
        BlockPos minerPos = this.tile.m_58899_();
        for (int i = 0; i < size; ++i) {
            boolean accepted;
            Block info;
            BlockState state;
            if (this.tile.m_58901_()) {
                return;
            }
            BlockPos testPos = TileEntityDigitalMiner.getOffsetForIndex(pos, diameter, i);
            if (minerPos.equals((Object)testPos) || WorldUtils.getTileEntity(TileEntityBoundingBlock.class, (BlockGetter)this.chunkCache, testPos) != null || (state = this.chunkCache.m_8055_(testPos)).m_60795_() || state.m_204336_(MekanismTags.Blocks.MINER_BLACKLIST) || this.shouldSkipState(state) || state.m_60800_((BlockGetter)this.chunkCache, testPos) < 0.0f || MekanismUtils.isLiquidBlock(info = state.m_60734_()) || !(accepted = acceptedItems.computeIfAbsent((Object)info, block -> {
                if (this.tile.isReplaceTarget(block.m_5456_())) {
                    return false;
                }
                return this.tile.getInverse() != this.tile.getFilterManager().anyEnabledMatch(filter -> filter.canFilter(state));
            }))) continue;
            long chunk = ChunkPos.m_151388_((BlockPos)testPos);
            ((BitSet)this.oresToMine.computeIfAbsent(chunk, k -> new BitSet())).set(i);
            ++this.found;
        }
        this.state = State.FINISHED;
        this.chunkCache = null;
        if (this.tile.searcher == this) {
            this.tile.updateFromSearch(this.oresToMine, this.found);
        }
    }

    private boolean shouldSkipState(BlockState state) {
        if (state.m_60734_() instanceof BedBlock) {
            return state.m_61143_((Property)BlockStateProperties.f_61391_) == BedPart.FOOT;
        }
        if (state.m_60734_() instanceof DoorBlock || state.m_60734_() instanceof DoublePlantBlock) {
            return state.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.UPPER;
        }
        return false;
    }

    @NothingNullByDefault
    public static enum State implements IHasTextComponent
    {
        IDLE(MekanismLang.MINER_IDLE),
        SEARCHING(MekanismLang.MINER_SEARCHING),
        PAUSED(MekanismLang.MINER_PAUSED),
        FINISHED(MekanismLang.MINER_READY);

        private static final State[] MODES;
        private final ILangEntry langEntry;

        private State(ILangEntry langEntry) {
            this.langEntry = langEntry;
        }

        @Override
        public Component getTextComponent() {
            return this.langEntry.translate(new Object[0]);
        }

        public static State byIndexStatic(int index) {
            return MathUtils.getByIndexMod(MODES, index);
        }

        static {
            MODES = State.values();
        }
    }
}

