/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.holder.chemical;

import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.common.capabilities.holder.ConfigHolder;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.config.slot.ChemicalSlotInfo;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigChemicalTankHolder<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, TANK extends IChemicalTank<CHEMICAL, STACK>>
extends ConfigHolder<TANK>
implements IChemicalTankHolder<CHEMICAL, STACK, TANK> {
    protected ConfigChemicalTankHolder(Supplier<Direction> facingSupplier, Supplier<TileComponentConfig> configSupplier) {
        super(facingSupplier, configSupplier);
    }

    void addTank(@NotNull TANK tank) {
        this.slots.add(tank);
    }

    @NotNull
    protected abstract List<TANK> getTanksFromSlot(ISlotInfo var1);

    @Override
    @NotNull
    public List<TANK> getTanks(@Nullable Direction direction) {
        return this.getSlots(direction, this::getTanksFromSlot);
    }

    public static class ConfigSlurryTankHolder
    extends ConfigChemicalTankHolder<Slurry, SlurryStack, ISlurryTank> {
        public ConfigSlurryTankHolder(Supplier<Direction> facingSupplier, Supplier<TileComponentConfig> configSupplier) {
            super(facingSupplier, configSupplier);
        }

        @Override
        protected TransmissionType getTransmissionType() {
            return TransmissionType.SLURRY;
        }

        @Override
        @NotNull
        protected List<ISlurryTank> getTanksFromSlot(ISlotInfo slotInfo) {
            List<ISlurryTank> list;
            if (slotInfo instanceof ChemicalSlotInfo.SlurrySlotInfo) {
                ChemicalSlotInfo.SlurrySlotInfo info = (ChemicalSlotInfo.SlurrySlotInfo)slotInfo;
                list = info.getTanks();
            } else {
                list = Collections.emptyList();
            }
            return list;
        }
    }

    public static class ConfigPigmentTankHolder
    extends ConfigChemicalTankHolder<Pigment, PigmentStack, IPigmentTank> {
        public ConfigPigmentTankHolder(Supplier<Direction> facingSupplier, Supplier<TileComponentConfig> configSupplier) {
            super(facingSupplier, configSupplier);
        }

        @Override
        protected TransmissionType getTransmissionType() {
            return TransmissionType.PIGMENT;
        }

        @Override
        @NotNull
        protected List<IPigmentTank> getTanksFromSlot(ISlotInfo slotInfo) {
            List<IPigmentTank> list;
            if (slotInfo instanceof ChemicalSlotInfo.PigmentSlotInfo) {
                ChemicalSlotInfo.PigmentSlotInfo info = (ChemicalSlotInfo.PigmentSlotInfo)slotInfo;
                list = info.getTanks();
            } else {
                list = Collections.emptyList();
            }
            return list;
        }
    }

    public static class ConfigInfusionTankHolder
    extends ConfigChemicalTankHolder<InfuseType, InfusionStack, IInfusionTank> {
        public ConfigInfusionTankHolder(Supplier<Direction> facingSupplier, Supplier<TileComponentConfig> configSupplier) {
            super(facingSupplier, configSupplier);
        }

        @Override
        protected TransmissionType getTransmissionType() {
            return TransmissionType.INFUSION;
        }

        @Override
        @NotNull
        protected List<IInfusionTank> getTanksFromSlot(ISlotInfo slotInfo) {
            List<IInfusionTank> list;
            if (slotInfo instanceof ChemicalSlotInfo.InfusionSlotInfo) {
                ChemicalSlotInfo.InfusionSlotInfo info = (ChemicalSlotInfo.InfusionSlotInfo)slotInfo;
                list = info.getTanks();
            } else {
                list = Collections.emptyList();
            }
            return list;
        }
    }

    public static class ConfigGasTankHolder
    extends ConfigChemicalTankHolder<Gas, GasStack, IGasTank> {
        public ConfigGasTankHolder(Supplier<Direction> facingSupplier, Supplier<TileComponentConfig> configSupplier) {
            super(facingSupplier, configSupplier);
        }

        @Override
        protected TransmissionType getTransmissionType() {
            return TransmissionType.GAS;
        }

        @Override
        @NotNull
        protected List<IGasTank> getTanksFromSlot(ISlotInfo slotInfo) {
            List<IGasTank> list;
            if (slotInfo instanceof ChemicalSlotInfo.GasSlotInfo) {
                ChemicalSlotInfo.GasSlotInfo info = (ChemicalSlotInfo.GasSlotInfo)slotInfo;
                list = info.getTanks();
            } else {
                list = Collections.emptyList();
            }
            return list;
        }
    }
}

