/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.config.BackpackEffect;
import com.tiviacz.travelersbackpack.config.Cooldown;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.BackpackDeathHelper;
import com.tiviacz.travelersbackpack.util.CooldownHelper;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.EnderManAngerEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class BackpackAbilities {
    public static final BackpackAbilities ABILITIES = new BackpackAbilities();
    public final AttributeModifier NETHERITE_ARMOR_MODIFIER = new AttributeModifier(UUID.fromString("49d951a4-ca9c-48b5-b549-61ef67ee53aa"), "netherite_backpack_armor", 4.0, AttributeModifier.Operation.ADDITION);
    public final AttributeModifier DIAMOND_ARMOR_MODIFIER = new AttributeModifier(UUID.fromString("294425c4-8dc6-4640-a336-d9fd72950e20"), "diamond_backpack_armor", 3.0, AttributeModifier.Operation.ADDITION);
    public final AttributeModifier IRON_ARMOR_MODIFIER = new AttributeModifier(UUID.fromString("fcf6706b-dfd9-40d6-aa25-62c4fb7a83fa"), "iron_backpack_armor", 2.0, AttributeModifier.Operation.ADDITION);
    public final AttributeModifier GOLD_ARMOR_MODIFIER = new AttributeModifier(UUID.fromString("21060f97-da7a-4460-a4e4-c94fae72ab00"), "gold_backpack_armor", 2.0, AttributeModifier.Operation.ADDITION);
    public final AttributeModifier ENDERMAN_REACH_DISTANCE_MODIFIER = new AttributeModifier(UUID.fromString("a3d7a647-1ed9-4317-94c2-ca889cd33657"), "enderman_backpack_reach", 1.0, AttributeModifier.Operation.ADDITION);
    public final AttributeModifier EMERALD_LUCK = new AttributeModifier(UUID.fromString("a3d7a647-1ed9-4317-94c2-ca000cd33657"), "emerald_backpack_luck", 1.0, AttributeModifier.Operation.ADDITION);
    public final AttributeModifier WARDEN_MAX_HEALTH_MODIFIER = new AttributeModifier(UUID.fromString("c115a1ba-9a23-4698-b07c-582a4861fbd1"), "warden_backpack_max_health", 4.0, AttributeModifier.Operation.ADDITION);
    public final AttributeModifier FOX_MOVEMENT_SPEED_MODIFIER = new AttributeModifier(UUID.fromString("21161f97-9a23-4698-b07c-582a4861fbd1"), "fox_movement_speed", 0.1, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private final TargetingConditions ocelotAbilityTargeting = TargetingConditions.m_148352_().m_26883_(64.0);
    public static final List<Item> ALLOWED_ABILITIES = new ArrayList<Item>();
    public static final Multimap<Item, BackpackEffect> BACKPACK_EFFECTS = ArrayListMultimap.create();
    public static final Map<Item, Cooldown> COOLDOWNS = new HashMap<Item, Cooldown>();
    public static List<Item> ITEM_ABILITIES_LIST = new ArrayList<TravelersBackpackItem>(List.of((TravelersBackpackItem)((Object)ModItems.NETHERITE_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.DIAMOND_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.GOLD_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.EMERALD_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.IRON_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.LAPIS_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.QUARTZ_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.CAKE_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.CACTUS_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.HAY_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.PUMPKIN_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.CREEPER_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.DRAGON_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.ENDERMAN_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.BLAZE_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.GHAST_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.MAGMA_CUBE_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.SPIDER_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.WITHER_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.WARDEN_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.BAT_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.BEE_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.OCELOT_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.COW_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.CHICKEN_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.SQUID_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.FOX_TRAVELERS_BACKPACK.get())));
    public static List<Item> ITEM_ABILITIES_REMOVAL_LIST = new ArrayList<TravelersBackpackItem>(List.of((TravelersBackpackItem)((Object)ModItems.NETHERITE_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.DIAMOND_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.GOLD_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.IRON_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.EMERALD_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.ENDERMAN_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.WARDEN_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.FOX_TRAVELERS_BACKPACK.get())));
    public static List<Item> BLOCK_ABILITIES_LIST = new ArrayList<TravelersBackpackItem>(List.of((TravelersBackpackItem)((Object)ModItems.REDSTONE_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.BOOKSHELF_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.SPONGE_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.CACTUS_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.MELON_TRAVELERS_BACKPACK.get())));
    public static List<Item> CUSTOM_DESCRIPTIONS = new ArrayList<TravelersBackpackItem>(List.of((TravelersBackpackItem)((Object)ModItems.LAPIS_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.REDSTONE_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.BOOKSHELF_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.SPONGE_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.CAKE_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.CACTUS_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.HAY_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.PUMPKIN_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.MELON_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.CREEPER_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.ENDERMAN_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.BLAZE_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.GHAST_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.SPIDER_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.WITHER_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.WARDEN_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.BEE_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.OCELOT_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.COW_TRAVELERS_BACKPACK.get()), (TravelersBackpackItem)((Object)ModItems.CHICKEN_TRAVELERS_BACKPACK.get())));

    public boolean abilityTick(@Nullable ItemStack backpack, @Nullable Player player) {
        boolean tickCooldown = false;
        if (backpack != null) {
            Item backpackItem = backpack.m_41720_();
            boolean effectHasCooldown = false;
            if (BackpackAbilities.getBackpackEffects().containsKey((Object)backpack.m_41720_())) {
                if (BackpackAbilities.getCooldowns().containsKey(backpack.m_41720_())) {
                    effectHasCooldown = true;
                }
                if (!effectHasCooldown) {
                    Collection backpackEffects = BackpackAbilities.getBackpackEffects().get((Object)backpackItem);
                    for (BackpackEffect backpackEffect : backpackEffects) {
                        if (backpack.m_41720_() == ModItems.SQUID_TRAVELERS_BACKPACK.get() && backpackEffect.effect() == MobEffects.f_19611_ && !player.m_20069_()) continue;
                        this.addTimedMobEffect(player, backpackEffect.effect(), backpackEffect.minDuration(), backpackEffect.maxDuration(), backpackEffect.amplifier(), false, false, false);
                    }
                } else {
                    if (!BackpackAbilities.hasCooldown(backpack)) {
                        Collection backpackEffects = BackpackAbilities.getBackpackEffects().get((Object)backpackItem);
                        for (BackpackEffect backpackEffect : backpackEffects) {
                            this.addTimedMobEffect(player, backpackEffect.effect(), backpackEffect.minDuration(), backpackEffect.maxDuration(), backpackEffect.amplifier(), false, false, false);
                        }
                        BackpackAbilities.setCooldown(CapabilityUtils.getBackpackWrapperArtificial(player), backpackItem);
                    }
                    tickCooldown = true;
                }
            }
            if (backpackItem == ModItems.NETHERITE_TRAVELERS_BACKPACK.get()) {
                this.attributeAbility(player, false, Attributes.f_22284_, this.NETHERITE_ARMOR_MODIFIER);
                return false;
            }
            if (backpackItem == ModItems.DIAMOND_TRAVELERS_BACKPACK.get()) {
                this.attributeAbility(player, false, Attributes.f_22284_, this.DIAMOND_ARMOR_MODIFIER);
                return false;
            }
            if (backpackItem == ModItems.GOLD_TRAVELERS_BACKPACK.get()) {
                this.attributeAbility(player, false, Attributes.f_22284_, this.GOLD_ARMOR_MODIFIER);
                return false;
            }
            if (backpackItem == ModItems.EMERALD_TRAVELERS_BACKPACK.get()) {
                this.attributeAbility(player, false, Attributes.f_22286_, this.EMERALD_LUCK);
                return false;
            }
            if (backpackItem == ModItems.IRON_TRAVELERS_BACKPACK.get()) {
                this.attributeAbility(player, false, Attributes.f_22284_, this.IRON_ARMOR_MODIFIER);
                return false;
            }
            if (backpackItem == ModItems.ENDERMAN_TRAVELERS_BACKPACK.get()) {
                this.attributeAbility(player, false, (Attribute)ForgeMod.BLOCK_REACH.get(), this.ENDERMAN_REACH_DISTANCE_MODIFIER);
                return false;
            }
            if (backpackItem == ModItems.WARDEN_TRAVELERS_BACKPACK.get()) {
                this.attributeAbility(player, false, Attributes.f_22276_, this.WARDEN_MAX_HEALTH_MODIFIER);
                return false;
            }
            if (backpackItem == ModItems.FOX_TRAVELERS_BACKPACK.get()) {
                this.attributeAbility(player, false, Attributes.f_22279_, this.FOX_MOVEMENT_SPEED_MODIFIER);
                return false;
            }
            if (backpackItem == ModItems.CAKE_TRAVELERS_BACKPACK.get()) {
                this.cakeAbility(backpack, player);
                return true;
            }
            if (backpackItem == ModItems.CACTUS_TRAVELERS_BACKPACK.get()) {
                this.cactusAbilityEquipped(player, backpack);
                return false;
            }
            if (backpackItem == ModItems.CHICKEN_TRAVELERS_BACKPACK.get()) {
                this.chickenAbility(backpack, player, false);
                return true;
            }
            if (backpackItem == ModItems.CREEPER_TRAVELERS_BACKPACK.get()) {
                return true;
            }
            if (backpackItem == ModItems.BLAZE_TRAVELERS_BACKPACK.get()) {
                this.blazeAbility(player);
                return false;
            }
            if (backpackItem == ModItems.SPIDER_TRAVELERS_BACKPACK.get()) {
                this.spiderAbility(player);
                return false;
            }
            if (backpackItem == ModItems.OCELOT_TRAVELERS_BACKPACK.get()) {
                this.ocelotAbility(player);
                return false;
            }
            if (backpackItem == ModItems.COW_TRAVELERS_BACKPACK.get()) {
                this.cowAbility(backpack, player);
                return true;
            }
            if (backpackItem == ModItems.WITHER_TRAVELERS_BACKPACK.get()) {
                BackpackAbilities.witherAbilityTick(player);
                return false;
            }
        }
        return tickCooldown;
    }

    public boolean abilityTickBlock(@Nullable BackpackBlockEntity blockEntity) {
        Item backpackItem;
        if (blockEntity.getWrapper() != null && (backpackItem = blockEntity.getWrapper().getBackpackStack().m_41720_()) == ModItems.CACTUS_TRAVELERS_BACKPACK.get()) {
            this.cactusAbilityBlockEntity(blockEntity.getWrapper(), blockEntity);
            return false;
        }
        return false;
    }

    public void abilityRemoval(@Nullable ItemStack stack, @Nullable Player player) {
        if (stack.m_41720_() == ModItems.NETHERITE_TRAVELERS_BACKPACK.get()) {
            this.attributeAbility(player, true, Attributes.f_22284_, this.NETHERITE_ARMOR_MODIFIER);
        }
        if (stack.m_41720_() == ModItems.DIAMOND_TRAVELERS_BACKPACK.get()) {
            this.attributeAbility(player, true, Attributes.f_22284_, this.DIAMOND_ARMOR_MODIFIER);
        }
        if (stack.m_41720_() == ModItems.IRON_TRAVELERS_BACKPACK.get()) {
            this.attributeAbility(player, true, Attributes.f_22284_, this.IRON_ARMOR_MODIFIER);
        }
        if (stack.m_41720_() == ModItems.GOLD_TRAVELERS_BACKPACK.get()) {
            this.attributeAbility(player, true, Attributes.f_22284_, this.GOLD_ARMOR_MODIFIER);
        }
        if (stack.m_41720_() == ModItems.EMERALD_TRAVELERS_BACKPACK.get()) {
            this.attributeAbility(player, true, Attributes.f_22286_, this.EMERALD_LUCK);
        }
        if (stack.m_41720_() == ModItems.ENDERMAN_TRAVELERS_BACKPACK.get()) {
            this.attributeAbility(player, true, (Attribute)ForgeMod.BLOCK_REACH.get(), this.ENDERMAN_REACH_DISTANCE_MODIFIER);
        }
        if (stack.m_41720_() == ModItems.WARDEN_TRAVELERS_BACKPACK.get()) {
            this.attributeAbility(player, true, Attributes.f_22276_, this.WARDEN_MAX_HEALTH_MODIFIER);
        }
        if (stack.m_41720_() == ModItems.FOX_TRAVELERS_BACKPACK.get()) {
            this.attributeAbility(player, true, Attributes.f_22279_, this.FOX_MOVEMENT_SPEED_MODIFIER);
        }
    }

    public void animateTick(BackpackBlockEntity backpackBlockEntity, BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        if (backpackBlockEntity.getWrapper() != null && backpackBlockEntity.getWrapper().isAbilityEnabled()) {
            Block block = stateIn.m_60734_();
            if (block == ModBlocks.BOOKSHELF_TRAVELERS_BACKPACK.get()) {
                this.bookshelfAbility(null, backpackBlockEntity);
            }
            if (block == ModBlocks.SPONGE_TRAVELERS_BACKPACK.get()) {
                this.spongeAbility(backpackBlockEntity);
            }
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeAbilityMultimap(ItemStack backpack) {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        if (backpack.m_41720_() == ModItems.NETHERITE_TRAVELERS_BACKPACK.get()) {
            multimap.put((Object)Attributes.f_22284_, (Object)this.NETHERITE_ARMOR_MODIFIER);
            return multimap;
        }
        if (backpack.m_41720_() == ModItems.DIAMOND_TRAVELERS_BACKPACK.get()) {
            multimap.put((Object)Attributes.f_22284_, (Object)this.DIAMOND_ARMOR_MODIFIER);
            return multimap;
        }
        if (backpack.m_41720_() == ModItems.GOLD_TRAVELERS_BACKPACK.get()) {
            multimap.put((Object)Attributes.f_22284_, (Object)this.GOLD_ARMOR_MODIFIER);
            return multimap;
        }
        if (backpack.m_41720_() == ModItems.IRON_TRAVELERS_BACKPACK.get()) {
            multimap.put((Object)Attributes.f_22284_, (Object)this.IRON_ARMOR_MODIFIER);
            return multimap;
        }
        if (backpack.m_41720_() == ModItems.ENDERMAN_TRAVELERS_BACKPACK.get()) {
            multimap.put((Object)((Attribute)ForgeMod.BLOCK_REACH.get()), (Object)this.ENDERMAN_REACH_DISTANCE_MODIFIER);
            return multimap;
        }
        if (backpack.m_41720_() == ModItems.WARDEN_TRAVELERS_BACKPACK.get()) {
            multimap.put((Object)Attributes.f_22276_, (Object)this.WARDEN_MAX_HEALTH_MODIFIER);
            return multimap;
        }
        if (backpack.m_41720_() == ModItems.FOX_TRAVELERS_BACKPACK.get()) {
            multimap.put((Object)Attributes.f_22279_, (Object)this.FOX_MOVEMENT_SPEED_MODIFIER);
            return multimap;
        }
        if (backpack.m_41720_() == ModItems.EMERALD_TRAVELERS_BACKPACK.get()) {
            multimap.put((Object)Attributes.f_22286_, (Object)this.EMERALD_LUCK);
            return multimap;
        }
        return multimap;
    }

    public void attributeAbility(Player player, boolean isRemoval, Attribute attribute, AttributeModifier modifier) {
        AttributeInstance armor = player.m_21051_(attribute);
        if (isRemoval && armor != null && armor.m_22109_(modifier)) {
            armor.m_22127_(modifier.m_22209_());
        }
        if (!isRemoval && armor != null && !armor.m_22109_(modifier)) {
            armor.m_22125_(modifier);
        }
    }

    public void armorAbilityRemovals(Player player) {
        this.attributeAbility(player, true, Attributes.f_22284_, this.NETHERITE_ARMOR_MODIFIER);
        this.attributeAbility(player, true, Attributes.f_22284_, this.DIAMOND_ARMOR_MODIFIER);
        this.attributeAbility(player, true, Attributes.f_22284_, this.IRON_ARMOR_MODIFIER);
        this.attributeAbility(player, true, Attributes.f_22284_, this.GOLD_ARMOR_MODIFIER);
        this.attributeAbility(player, true, Attributes.f_22286_, this.EMERALD_LUCK);
        this.attributeAbility(player, true, (Attribute)ForgeMod.BLOCK_REACH.get(), this.ENDERMAN_REACH_DISTANCE_MODIFIER);
        this.attributeAbility(player, true, Attributes.f_22276_, this.WARDEN_MAX_HEALTH_MODIFIER);
        this.attributeAbility(player, true, Attributes.f_22279_, this.FOX_MOVEMENT_SPEED_MODIFIER);
    }

    public void lapisAbility(Player player, ExperienceOrb orb) {
        float random;
        if (ABILITIES.checkBackpack(player, (Item)ModItems.LAPIS_TRAVELERS_BACKPACK.get()) && (random = player.m_217043_().m_188501_()) <= 0.15f) {
            if (random <= 0.025f) {
                BackpackAbilities.sendParticlesPacket((ParticleOptions)ParticleTypes.f_175827_, player, 2);
            }
            orb.f_20770_ *= 2;
        }
    }

    public void bookshelfAbility(@Nullable Player player, @Nullable BackpackBlockEntity backpackBlockEntity) {
        BlockPos enchanting = BackpackDeathHelper.findBlock3D(backpackBlockEntity.m_58904_(), backpackBlockEntity.m_58899_().m_123341_(), backpackBlockEntity.m_58899_().m_123342_(), backpackBlockEntity.m_58899_().m_123343_(), Blocks.f_50201_, 2, 2);
        if (enchanting != null) {
            if (!backpackBlockEntity.m_58904_().m_46859_(new BlockPos((enchanting.m_123341_() - backpackBlockEntity.m_58899_().m_123341_()) / 2 + backpackBlockEntity.m_58899_().m_123341_(), enchanting.m_123342_(), (enchanting.m_123343_() - backpackBlockEntity.m_58899_().m_123343_()) / 2 + backpackBlockEntity.m_58899_().m_123343_()))) {
                return;
            }
            for (int o = 0; o < 4; ++o) {
                backpackBlockEntity.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123809_, (double)enchanting.m_123341_() + 0.5, (double)enchanting.m_123342_() + 2.0, (double)enchanting.m_123343_() + 0.5, (double)((float)(backpackBlockEntity.m_58899_().m_123341_() - enchanting.m_123341_()) + backpackBlockEntity.m_58904_().f_46441_.m_188501_()) - 0.5, (double)((float)(backpackBlockEntity.m_58899_().m_123342_() - enchanting.m_123342_()) - backpackBlockEntity.m_58904_().f_46441_.m_188501_() - 1.0f), (double)((float)(backpackBlockEntity.m_58899_().m_123343_() - enchanting.m_123343_()) + backpackBlockEntity.m_58904_().f_46441_.m_188501_()) - 0.5);
            }
        }
    }

    public void spongeAbility(BackpackBlockEntity backpackBlockEntity) {
        TanksUpgrade tanksUpgrade;
        if (backpackBlockEntity.getWrapper().getUpgradeManager().getUpgrade(TanksUpgrade.class).isPresent() && !(tanksUpgrade = backpackBlockEntity.getWrapper().getUpgradeManager().getUpgrade(TanksUpgrade.class).get()).getLeftTank().isEmpty() && !tanksUpgrade.getRightTank().isEmpty() && tanksUpgrade.getLeftTank().getFluid().getFluid().m_6212_((Fluid)Fluids.f_76193_) && tanksUpgrade.getRightTank().getFluid().getFluid().m_6212_((Fluid)Fluids.f_76193_) && tanksUpgrade.getLeftTank().getFluidAmount() == tanksUpgrade.getLeftTank().getCapacity() && tanksUpgrade.getRightTank().getFluidAmount() == tanksUpgrade.getRightTank().getCapacity()) {
            float f = backpackBlockEntity.m_58904_().f_46441_.m_188501_() * (float)Math.PI * 2.0f;
            float f1 = backpackBlockEntity.m_58904_().f_46441_.m_188501_() * 0.5f + 0.5f;
            float f2 = Mth.m_14031_((float)f) * 0.5f * f1;
            float f3 = Mth.m_14089_((float)f) * 0.5f * f1;
            backpackBlockEntity.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123769_, (double)((float)backpackBlockEntity.m_58899_().m_123341_() + f2 + 0.5f), (double)((float)backpackBlockEntity.m_58899_().m_123342_() + backpackBlockEntity.m_58904_().f_46441_.m_188501_()), (double)((float)backpackBlockEntity.m_58899_().m_123343_() + f3 + 0.5f), (double)((float)Math.pow(2.0, (double)(backpackBlockEntity.m_58904_().f_46441_.m_188503_(169) - 12) / 12.0)) / 24.0, -1.0, 0.0);
        }
    }

    public void cakeAbility(ItemStack backpack, Player player) {
        if (!BackpackAbilities.hasCooldown(backpack)) {
            player.m_36324_().m_38707_(20, 0.1f);
            player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200));
            player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_11912_, SoundSource.AMBIENT, 0.6f, (player.m_9236_().f_46441_.m_188501_() - player.m_9236_().f_46441_.m_188501_()) * 0.3f + 1.0f);
            Level level = player.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                for (int i = 0; i < 3; ++i) {
                    float f = server.f_46441_.m_188501_() * (float)Math.PI * 2.0f;
                    float f1 = server.f_46441_.m_188501_() * 0.5f + 0.5f;
                    float f2 = Mth.m_14031_((float)f) * 0.5f * f1;
                    float f3 = Mth.m_14089_((float)f) * 0.5f * f1;
                    server.m_8767_((ParticleOptions)ParticleTypes.f_123750_, player.m_20182_().f_82479_ + (double)f2, player.m_20191_().f_82289_ + (double)player.m_9236_().f_46441_.m_188501_() + 0.5, player.m_20182_().f_82481_ + (double)f3, 3, (double)((float)Math.pow(2.0, (double)(player.m_9236_().f_46441_.m_188503_(169) - 12) / 12.0)) / 24.0, -1.0, 0.0, 0.0);
                }
            }
            if (BackpackAbilities.getCooldowns().containsKey(backpack.m_41720_())) {
                Cooldown config = BackpackAbilities.getCooldowns().get(backpack.m_41720_());
                NbtHelper.set(backpack, "Cooldown", CooldownHelper.createCooldown(config.minCooldown(), config.maxCooldown()));
            }
        }
    }

    public void chickenAbility(ItemStack backpack, Player player, boolean firstSwitch) {
        if (firstSwitch && !player.m_9236_().f_46443_ && !BackpackAbilities.hasCooldown(backpack)) {
            BackpackWrapper wrapper = CapabilityUtils.getBackpackWrapperArtificial(player);
            BackpackAbilities.setCooldown(wrapper, wrapper.getBackpackStack().m_41720_());
            return;
        }
        if (!BackpackAbilities.hasCooldown(backpack)) {
            BackpackWrapper wrapper = CapabilityUtils.getBackpackWrapperArtificial(player);
            player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_11752_, SoundSource.AMBIENT, 1.0f, (player.m_9236_().f_46441_.m_188501_() - player.m_9236_().f_46441_.m_188501_()) * 0.3f + 1.0f);
            player.m_19998_((ItemLike)Items.f_42521_);
            if (player.m_9236_().f_46443_) {
                return;
            }
            BackpackAbilities.setCooldown(wrapper, wrapper.getBackpackStack().m_41720_());
        }
    }

    public void cactusAbilityEquipped(@Nullable Player player, @Nullable ItemStack backpack) {
        BackpackWrapper wrapper;
        int gameTime = (int)player.m_9236_().m_46467_();
        int cooldown = NbtHelper.getOrDefault(backpack, "Cooldown", 0);
        if (cooldown >= 1000) {
            wrapper = CapabilityUtils.getBackpackWrapper(player, CapabilityUtils.UPGRADES_ONLY);
            if (wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).isPresent()) {
                TanksUpgrade upgrade = wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).get();
                FluidTank leftTank = upgrade.getLeftTank();
                FluidTank rightTank = upgrade.getRightTank();
                FluidStack water = new FluidStack((Fluid)Fluids.f_76193_, 1000);
                if (!player.m_9236_().f_46443_) {
                    leftTank.fill(water, IFluidHandler.FluidAction.EXECUTE);
                    rightTank.fill(water, IFluidHandler.FluidAction.EXECUTE);
                }
                if (player.m_9236_().f_46443_) {
                    return;
                }
                wrapper.setCooldown(0);
            } else {
                return;
            }
        }
        int drops = 0;
        if (gameTime % 100 == 0) {
            wrapper = CapabilityUtils.getBackpackWrapperArtificial(player);
            if (player.m_20069_()) {
                drops += 50;
            }
            if (this.isUnderRain(player.m_20183_(), player.m_9236_())) {
                drops += 50;
            }
            int getCurrentDrops = wrapper.getCooldown();
            if (drops > 0) {
                if (player.m_9236_().f_46443_) {
                    return;
                }
                wrapper.setCooldown(getCurrentDrops + drops);
            }
        }
    }

    public void cactusAbilityBlockEntity(@Nullable BackpackWrapper wrapper, @Nullable BackpackBlockEntity blockEntity) {
        int cooldown = wrapper.getCooldown();
        if (cooldown >= 1000) {
            if (wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).isPresent()) {
                TanksUpgrade upgrade = wrapper.getUpgradeManager().getUpgrade(TanksUpgrade.class).get();
                FluidTank leftTank = upgrade.getLeftTank();
                FluidTank rightTank = upgrade.getRightTank();
                FluidStack water = new FluidStack((Fluid)Fluids.f_76193_, 1000);
                leftTank.fill(water, IFluidHandler.FluidAction.EXECUTE);
                rightTank.fill(water, IFluidHandler.FluidAction.EXECUTE);
                wrapper.setCooldown(0);
            } else {
                return;
            }
        }
        int drops = 0;
        int gameTime = (int)blockEntity.m_58904_().m_46467_();
        if (gameTime % 100 == 0) {
            if (this.isUnderRain(blockEntity.m_58899_(), blockEntity.m_58904_())) {
                drops += 50;
            }
            int getCurrentDrops = wrapper.getCooldown();
            if (drops > 0) {
                wrapper.setCooldown(getCurrentDrops + drops);
            }
        }
    }

    public static void melonAbility(BackpackBlockEntity backpackBlockEntity) {
        if (backpackBlockEntity.getWrapper().isAbilityEnabled() && backpackBlockEntity.getWrapper().getCooldown() <= 0) {
            Block.m_49840_((Level)backpackBlockEntity.m_58904_(), (BlockPos)backpackBlockEntity.m_58899_(), (ItemStack)new ItemStack((ItemLike)Items.f_42575_, backpackBlockEntity.m_58904_().f_46441_.m_216339_(0, 3)));
            BackpackAbilities.setCooldown(backpackBlockEntity.getWrapper(), backpackBlockEntity.getWrapper().getBackpackStack().m_41720_());
        }
    }

    public static void pumpkinAbility(EnderManAngerEvent event) {
        if (ABILITIES.checkBackpack(event.getPlayer(), (Item)ModItems.PUMPKIN_TRAVELERS_BACKPACK.get())) {
            event.setCanceled(true);
        }
    }

    public static boolean creeperAbility(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            BackpackWrapper wrapper = CapabilityUtils.getBackpackWrapperArtificial(player);
            if (player.m_21224_() && wrapper != null && wrapper.getBackpackStack().m_41720_() == ModItems.CREEPER_TRAVELERS_BACKPACK.get() && wrapper.isAbilityEnabled() && wrapper.getCooldown() <= 0) {
                player.m_21153_(1.0f);
                player.m_21219_();
                player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 450, 1));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 100, 1));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 400, 0));
                player.m_9236_().m_254877_((Entity)player, player.m_269291_().m_269075_(player), null, player.m_20208_(0.5), player.m_20186_(), player.m_20262_(0.5), 3.0f, false, Level.ExplosionInteraction.NONE);
                player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_11837_, SoundSource.AMBIENT, 1.2f, 0.5f);
                if (!player.m_9236_().f_46443_) {
                    BackpackAbilities.setCooldown(wrapper, wrapper.getBackpackStack().m_41720_());
                }
                event.setCanceled(true);
                return true;
            }
        }
        return false;
    }

    public void blazeAbility(Player player) {
        if (player.f_19789_ >= 3.0f) {
            for (int i = 0; i < 4; ++i) {
                player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, player.m_20208_(0.5), player.m_20187_(), player.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
            player.f_19789_ = 0.0f;
        }
    }

    public static void blazeAbility(ProjectileImpactEvent event) {
        Projectile projectile = event.getProjectile();
        if (projectile instanceof SmallFireball) {
            Player player;
            EntityHitResult result;
            Entity entity;
            SmallFireball fireball = (SmallFireball)projectile;
            if (event.getRayTraceResult().m_6662_() == HitResult.Type.ENTITY && (entity = (result = (EntityHitResult)event.getRayTraceResult()).m_82443_()) instanceof Player && ABILITIES.checkBackpack(player = (Player)entity, (Item)ModItems.BLAZE_TRAVELERS_BACKPACK.get())) {
                player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_12346_, SoundSource.PLAYERS, 1.0f, 0.8f + player.m_9236_().f_46441_.m_188501_() * 0.4f);
                BackpackAbilities.sendParticlesPacket((ParticleOptions)ParticleTypes.f_123744_, player, 3);
                fireball.m_146870_();
                event.setCanceled(true);
            }
        }
    }

    public static void ghastAbility(LivingChangeTargetEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Ghast) {
            Player player;
            Ghast ghast = (Ghast)livingEntity;
            livingEntity = event.getNewTarget();
            if (livingEntity instanceof Player && ABILITIES.checkBackpack(player = (Player)livingEntity, (Item)ModItems.GHAST_TRAVELERS_BACKPACK.get()) && ghast.m_21188_() != player) {
                event.setCanceled(true);
            }
        }
    }

    public void spiderAbility(Player player) {
        if (player.f_19862_ && !player.isInFluidType()) {
            if (player.m_21255_()) {
                player.m_36321_();
            }
            if (!player.m_20096_() && player.m_6047_()) {
                player.m_20334_(player.m_20184_().f_82479_, 0.0, player.m_20184_().f_82481_);
            } else {
                player.m_20334_(player.m_20184_().f_82479_, 0.2, player.m_20184_().f_82481_);
                Level level = player.m_9236_();
                BlockState state = level.m_8055_(player.m_20183_().m_121945_(player.m_6350_()));
                try {
                    player.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state).setPos(player.m_20183_()), player.m_20185_() + (level.f_46441_.m_188500_() - 0.5) * (double)player.m_6972_((Pose)Pose.STANDING).f_20377_, player.m_20186_() + 0.1, player.m_20189_() + (level.f_46441_.m_188500_() - 0.5) * (double)player.m_6972_((Pose)Pose.STANDING).f_20377_, 0.0, 1.5, 0.0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void witherAbility(AttackEntityEvent event) {
        Entity entity;
        if (ABILITIES.checkBackpack(event.getEntity(), (Item)ModItems.WITHER_TRAVELERS_BACKPACK.get()) && (entity = event.getTarget()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 60, 1));
        }
    }

    public static void wardenAbility(AttackEntityEvent event) {
        Entity entity;
        if (ABILITIES.checkBackpack(event.getEntity(), (Item)ModItems.WARDEN_TRAVELERS_BACKPACK.get()) && (entity = event.getTarget()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 1));
        }
    }

    public static void witherAbilityTick(Player player) {
        if (ABILITIES.checkBackpack(player, (Item)ModItems.WITHER_TRAVELERS_BACKPACK.get()) && player.m_21023_(MobEffects.f_19615_)) {
            player.m_21195_(MobEffects.f_19615_);
        }
    }

    public static void beeAbility(AttackEntityEvent event) {
        if (ABILITIES.checkBackpack(event.getEntity(), (Item)ModItems.BEE_TRAVELERS_BACKPACK.get())) {
            DamageSource damageSource = event.getEntity().m_269291_().m_269396_((LivingEntity)event.getEntity());
            boolean flag = event.getTarget().m_6469_(damageSource, 1.0f);
            if (flag) {
                event.getEntity().m_19970_((LivingEntity)event.getEntity(), event.getTarget());
                Entity entity = event.getTarget();
                if (entity instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity;
                    living.m_21321_(living.m_21235_() + 1);
                    living.m_147207_(new MobEffectInstance(MobEffects.f_19614_, 80, 0), (Entity)event.getEntity());
                }
            }
        }
    }

    public void ocelotAbility(Player player) {
        if (player.m_9236_().m_45963_(Monster.class, this.ocelotAbilityTargeting, (LivingEntity)player, player.m_20185_(), player.m_20186_(), player.m_20189_(), player.m_20191_().m_82377_(6.0, 2.0, 6.0)) != null) {
            this.addTimedMobEffect(player, MobEffects.f_19596_, 20, 30, 0, false, false, false);
        }
    }

    public void cowAbility(ItemStack stack, Player player) {
        if (!player.m_21220_().isEmpty() && !BackpackAbilities.hasCooldown(stack) && player.m_21220_().stream().anyMatch(effect -> effect.m_19544_().m_19483_() == MobEffectCategory.HARMFUL)) {
            BackpackWrapper wrapper = CapabilityUtils.getBackpackWrapperArtificial(player);
            if (!player.m_9236_().f_46443_) {
                player.m_9236_().m_46796_(2007, player.m_20183_(), 0xFFFFFF);
                BackpackAbilities.setCooldown(wrapper, stack.m_41720_());
            }
            player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_144178_, SoundSource.PLAYERS, 1.0f, player.m_217043_().m_188501_() * 0.1f + 0.9f);
            this.removeAllNegativeEffects(player.m_9236_(), player);
        }
    }

    public boolean removeAllNegativeEffects(Level level, Player player) {
        if (level.f_46443_) {
            return false;
        }
        if (player.m_21220_().isEmpty()) {
            return false;
        }
        List<MobEffectInstance> negativeEffects = player.m_21220_().stream().filter(effect -> effect.m_19544_().m_19483_() == MobEffectCategory.HARMFUL).toList();
        for (MobEffectInstance instance : negativeEffects) {
            player.m_21195_(instance.m_19544_());
        }
        return true;
    }

    public void squidAbility(ItemStack stack, Player player, int minDuration, int maxDuration, int amplifier) {
        if (player.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get()) && !BackpackAbilities.hasCooldown(stack)) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19608_, CooldownHelper.createCooldown(minDuration, maxDuration), amplifier, false, false, true));
            player.m_9236_().m_5594_(player, player.m_20183_(), SoundEvents.f_12441_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public void magmaCubeAbility(ItemStack stack, Player player, int minDuration, int maxDuration, int amplifier) {
        if (player.m_6060_() && !BackpackAbilities.hasCooldown(stack)) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, CooldownHelper.createCooldown(minDuration, maxDuration), amplifier, false, false, true));
            player.m_9236_().m_5594_(player, player.m_20183_(), SoundEvents.f_12112_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    private boolean isUnderRain(BlockPos pos, Level level) {
        return level.m_45527_(pos) && level.m_46471_();
    }

    public static boolean isAbilityEnabledInConfig(ItemStack stack) {
        return (Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.enableBackpackAbilities.get() != false && ALLOWED_ABILITIES.contains(stack.m_41720_());
    }

    public boolean checkBackpack(Player player, Item item) {
        if (!((Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.enableBackpackAbilities.get()).booleanValue() || !ALLOWED_ABILITIES.contains(item)) {
            return false;
        }
        return CapabilityUtils.isWearingBackpack(player) && CapabilityUtils.getWearingBackpack(player).m_41720_() == item && NbtHelper.getOrDefault(CapabilityUtils.getWearingBackpack(player), "AbilityEnabled", true) != false;
    }

    public void addTimedMobEffect(Player player, MobEffect effect, int minDuration, int maxDuration, int amplifier, boolean ambient, boolean showParticle, boolean showIcon) {
        if (!player.m_21023_(effect)) {
            player.m_7292_(new MobEffectInstance(effect, maxDuration, amplifier, ambient, showParticle, showIcon));
        } else if (player.m_21023_(effect) && player.m_21124_(effect) != null && player.m_21124_(effect).m_19557_() <= minDuration) {
            player.m_7292_(new MobEffectInstance(effect, maxDuration, amplifier, ambient, showParticle, showIcon));
        }
    }

    public static void sendParticlesPacket(ParticleOptions type, Player player, int count) {
        for (int i = 0; i < count; ++i) {
            double d0 = player.m_9236_().f_46441_.m_188583_() * 0.02;
            double d1 = player.m_9236_().f_46441_.m_188583_() * 0.02;
            double d2 = player.m_9236_().f_46441_.m_188583_() * 0.02;
            Level level = player.m_9236_();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel server = (ServerLevel)level;
            server.m_8767_(type, player.m_20208_(1.0), player.m_20187_() + 0.5, player.m_20262_(1.0), 1, d0, d1, d2, 0.0);
        }
    }

    public static boolean isOnList(List<Item> list, ItemStack stackToCheck) {
        return list.stream().anyMatch(s -> s == stackToCheck.m_41720_());
    }

    public static boolean hasCooldown(ItemStack stack) {
        return NbtHelper.getOrDefault(stack, "Cooldown", 0) > 0;
    }

    public static void setCooldown(BackpackWrapper wrapper, Item item) {
        if (BackpackAbilities.getCooldowns().containsKey(item)) {
            Cooldown cooldown = BackpackAbilities.getCooldowns().get(item);
            wrapper.setCooldown(CooldownHelper.createCooldown(cooldown.minCooldown(), cooldown.maxCooldown()));
        }
    }

    public static Map<Item, Cooldown> getCooldowns() {
        return COOLDOWNS;
    }

    public static Multimap<Item, BackpackEffect> getBackpackEffects() {
        return BACKPACK_EFFECTS;
    }
}

