/*
 * Decompiled with CFR 0.152.
 */
package reliquary.pedestal.wrappers;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.network.PacketDistributor;
import reliquary.api.IPedestal;
import reliquary.api.IPedestalActionItemWrapper;
import reliquary.entity.EntityXRFakePlayer;
import reliquary.network.PacketHandler;
import reliquary.network.PacketPedestalFishHook;
import reliquary.reference.Settings;
import reliquary.util.LogHelper;

public class PedestalFishingRodWrapper
implements IPedestalActionItemWrapper {
    private static final int PACKET_RANGE = 50;
    private static final int RANGE = 4;
    private static final int NO_WATER_COOLDOWN = 100;
    private static final int BAD_THROW_TIMEOUT = 60;
    private static final int ABSOLUTE_TIMEOUT = 1200;
    private EntityXRFakePlayer fakePlayer;
    private boolean badThrowChecked;
    private int ticksSinceLastThrow;
    private boolean retractFail = false;
    private static final Field BOBBER_CURRENT_STATE = ObfuscationReflectionHelper.findField(FishingHook.class, (String)"f_37095_");

    @Override
    public void update(ItemStack stack, Level level, IPedestal pedestal) {
        ++this.ticksSinceLastThrow;
        if (this.fakePlayer != null && this.fakePlayer.f_36083_ != null) {
            this.handleHookStates(stack, level, pedestal);
            this.syncHookData(level, pedestal);
        } else {
            this.setupFakePlayer(level, pedestal.getBlockPosition());
            Optional<BlockPos> p = this.getBestWaterBlock(level, pedestal);
            if (p.isPresent()) {
                this.updateHeldItem(stack);
                this.setPitchYaw(p.get());
                this.spawnFishHook(level, pedestal);
                this.badThrowChecked = false;
                this.ticksSinceLastThrow = 0;
            } else {
                pedestal.setActionCoolDown(100);
            }
        }
    }

    private void handleHookStates(ItemStack stack, Level level, IPedestal pedestal) {
        if (this.retractFail) {
            if (this.getTicksCatchable(this.fakePlayer.f_36083_) == 0) {
                this.retractHook(pedestal, stack);
                this.retractFail = false;
            }
        } else if (!this.badThrowChecked && this.ticksSinceLastThrow > 60) {
            FishingHook fishingHook = this.fakePlayer.f_36083_;
            if (this.getCurrentState(fishingHook) != FishingHook.FishHookState.BOBBING) {
                this.retractHook(pedestal, stack);
            } else {
                this.badThrowChecked = true;
            }
        } else if (this.ticksSinceLastThrow > 1200) {
            this.retractHook(pedestal, stack);
        } else if (this.getTicksCatchable(this.fakePlayer.f_36083_) > 0 || this.fakePlayer.f_36083_.m_37170_() != null) {
            if (level.f_46441_.m_188503_(100) <= (Integer)Settings.COMMON.blocks.pedestal.fishingWrapperSuccessRate.get()) {
                this.retractHook(pedestal, stack);
            } else {
                this.retractFail = true;
            }
        }
    }

    private void updateHeldItem(ItemStack fishingRod) {
        ItemStack heldItem = this.fakePlayer.m_21205_();
        if (heldItem.m_41619_()) {
            this.fakePlayer.m_21008_(InteractionHand.MAIN_HAND, fishingRod);
            return;
        }
        if (heldItem.m_41720_() != fishingRod.m_41720_()) {
            this.fakePlayer.m_21008_(InteractionHand.MAIN_HAND, fishingRod);
        }
    }

    private void retractHook(IPedestal pedestal, ItemStack stack) {
        int i = this.fakePlayer.f_36083_.m_37156_(stack);
        this.fakePlayer.f_36083_ = null;
        stack.m_41622_(i, (LivingEntity)this.fakePlayer, p -> {});
        if (stack.m_41613_() == 0) {
            pedestal.destroyItem();
        }
        pedestal.setActionCoolDown((Integer)Settings.COMMON.blocks.pedestal.fishingWrapperRetractDelay.get() * 20);
    }

    private Optional<BlockPos> getBestWaterBlock(Level level, IPedestal pedestal) {
        ArrayList<List<BlockPos>> connectedGroups = new ArrayList<List<BlockPos>>();
        ArrayList<BlockPos> visitedBlocks = new ArrayList<BlockPos>();
        BlockPos pos = pedestal.getBlockPosition();
        int pedestalX = pos.m_123341_();
        int pedestalY = pos.m_123342_();
        int pedestalZ = pos.m_123343_();
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos(pedestalX, pedestalY, pedestalZ);
        for (int y = pedestalY - 4; y < pedestalY; ++y) {
            checkPos.m_142448_(y);
            for (int r = 1; r <= 4; ++r) {
                int x;
                int z = pedestalZ - r;
                checkPos.m_142443_(z);
                for (x = pedestalX - r; x <= pedestalX + r; ++x) {
                    checkPos.m_142451_(x);
                    this.checkForAndAddWaterBlocks(level, pedestal, visitedBlocks, connectedGroups, pos, (BlockPos)checkPos);
                }
                --x;
                while (z <= pedestalZ + r) {
                    checkPos.m_142443_(z);
                    this.checkForAndAddWaterBlocks(level, pedestal, visitedBlocks, connectedGroups, pos, (BlockPos)checkPos);
                    ++z;
                }
                --z;
                while (x >= pedestalX - r) {
                    checkPos.m_142451_(x);
                    this.checkForAndAddWaterBlocks(level, pedestal, visitedBlocks, connectedGroups, pos, (BlockPos)checkPos);
                    --x;
                }
                while (z >= pedestalZ - r) {
                    checkPos.m_142443_(z);
                    this.checkForAndAddWaterBlocks(level, pedestal, visitedBlocks, connectedGroups, pos, (BlockPos)checkPos);
                    --z;
                }
            }
        }
        return this.getClosestBlock(connectedGroups, pedestalX, pedestalY, pedestalZ);
    }

    private Optional<BlockPos> getClosestBlock(List<List<BlockPos>> connectedGroups, int pedestalX, int pedestalY, int pedestalZ) {
        BlockPos closestBlockInLargestGroup = null;
        int closestSqDistance = Integer.MAX_VALUE;
        int mostBlocks = 0;
        for (List<BlockPos> group : connectedGroups) {
            if (group.size() <= mostBlocks) continue;
            mostBlocks = group.size();
            for (BlockPos waterPos : group) {
                int zDiff;
                int yDiff;
                int xDiff = waterPos.m_123341_() - pedestalX;
                int sqDistance = xDiff * xDiff + (yDiff = waterPos.m_123342_() - pedestalY) * yDiff + (zDiff = waterPos.m_123343_() - pedestalZ) * zDiff;
                if (sqDistance >= closestSqDistance) continue;
                closestSqDistance = sqDistance;
                closestBlockInLargestGroup = waterPos;
            }
        }
        return Optional.ofNullable(closestBlockInLargestGroup);
    }

    private void checkForAndAddWaterBlocks(Level level, IPedestal pedestal, List<BlockPos> visitedBlocks, List<List<BlockPos>> connectedGroups, BlockPos pedestalPos, BlockPos checkPos) {
        if (!visitedBlocks.contains(checkPos)) {
            ArrayList<BlockPos> group = new ArrayList<BlockPos>();
            this.checkForWaterAndSearchNeighbors(level, pedestal, visitedBlocks, pedestalPos, checkPos, group);
            if (!group.isEmpty()) {
                connectedGroups.add(group);
            }
        }
    }

    private void checkForWaterAndSearchNeighbors(Level level, IPedestal pedestal, List<BlockPos> visitedBlocks, BlockPos pedestalPos, BlockPos blockPos, List<BlockPos> group) {
        visitedBlocks.add(blockPos.m_7949_());
        BlockState blockState = level.m_8055_(blockPos);
        if (blockState.m_60734_() == Blocks.f_49990_) {
            double startZ;
            double startY;
            int x = blockPos.m_123341_();
            int y = blockPos.m_123342_();
            int z = blockPos.m_123343_();
            double startX = this.fakePlayer.m_20185_();
            BlockHitResult raytraceresult = level.m_45547_(new ClipContext(new Vec3(startX, startY = this.fakePlayer.m_20186_(), startZ = this.fakePlayer.m_20189_()), new Vec3((double)x + 0.5, (double)y + 0.8, (double)z + 0.5), ClipContext.Block.COLLIDER, ClipContext.Fluid.SOURCE_ONLY, (Entity)this.fakePlayer));
            if (raytraceresult.m_6662_() != HitResult.Type.MISS && raytraceresult.m_82425_().equals((Object)blockPos)) {
                group.add(blockPos);
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    BlockPos neighborPos = blockPos.m_121945_(direction);
                    if (neighborPos.m_123341_() > pedestalPos.m_123341_() + 4 || neighborPos.m_123341_() < pedestalPos.m_123341_() - 4 || neighborPos.m_123342_() > pedestalPos.m_123342_() + 4 || neighborPos.m_123342_() < pedestalPos.m_123342_() - 4) continue;
                    this.addNeighboringWater(level, pedestal, visitedBlocks, group, pedestalPos, neighborPos);
                }
            }
        }
    }

    private FishingHook.FishHookState getCurrentState(FishingHook fishingHook) {
        try {
            return (FishingHook.FishHookState)BOBBER_CURRENT_STATE.get(fishingHook);
        }
        catch (IllegalAccessException e) {
            LogHelper.error("Error getting fishing bobber state", e);
            return FishingHook.FishHookState.FLYING;
        }
    }

    private void addNeighboringWater(Level level, IPedestal pedestal, List<BlockPos> visitedBlocks, List<BlockPos> group, BlockPos pedestalPos, BlockPos blockPos) {
        if (!visitedBlocks.contains(blockPos)) {
            this.checkForWaterAndSearchNeighbors(level, pedestal, visitedBlocks, pedestalPos, blockPos, group);
        }
    }

    private void spawnFishHook(Level level, IPedestal pedestal) {
        level.m_5594_(null, pedestal.getBlockPosition(), SoundEvents.f_11941_, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.f_46441_.m_188501_() * 0.4f + 0.8f));
        level.m_7967_((Entity)new FishingHook((Player)this.fakePlayer, level, 0, 0){

            @Nullable
            public Entity m_19749_() {
                return PedestalFishingRodWrapper.this.fakePlayer;
            }

            public boolean m_6459_(ServerPlayer pPlayer) {
                return false;
            }
        });
    }

    private void syncHookData(Level level, IPedestal pedestal) {
        FishingHook hook = this.fakePlayer.f_36083_;
        BlockPos pedestalPos = pedestal.getBlockPosition();
        if (hook == null) {
            PacketHandler.sendToAllAround(new PacketPedestalFishHook(pedestal.getBlockPosition(), -1.0, -1.0, -1.0), new PacketDistributor.TargetPoint((double)pedestalPos.m_123341_(), (double)pedestalPos.m_123342_(), (double)pedestalPos.m_123343_(), 50.0, level.m_46472_()));
        } else {
            PacketHandler.sendToAllAround(new PacketPedestalFishHook(pedestal.getBlockPosition(), hook.m_20185_(), hook.m_20186_(), hook.m_20189_()), new PacketDistributor.TargetPoint((double)pedestalPos.m_123341_(), (double)pedestalPos.m_123342_(), (double)pedestalPos.m_123343_(), 50.0, level.m_46472_()));
        }
    }

    @Override
    public void onRemoved(ItemStack stack, Level level, IPedestal pedestal) {
        if (this.fakePlayer != null && this.fakePlayer.f_36083_ != null) {
            this.fakePlayer.f_36083_.m_146870_();
        }
    }

    @Override
    public void stop(ItemStack stack, Level level, IPedestal pedestal) {
        if (this.fakePlayer != null && this.fakePlayer.f_36083_ != null) {
            this.fakePlayer.f_36083_.m_146870_();
            this.syncHookData(level, pedestal);
        }
    }

    private void setupFakePlayer(Level world, BlockPos pos) {
        if (this.fakePlayer == null) {
            this.fakePlayer = new EntityXRFakePlayer((ServerLevel)world);
            this.fakePlayer.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 2.0, (double)pos.m_123343_() + 0.5);
        }
    }

    private int getTicksCatchable(@Nullable FishingHook hook) {
        return (Integer)ObfuscationReflectionHelper.getPrivateValue(FishingHook.class, (Object)hook, (String)"f_37089_");
    }

    private void setPitchYaw(BlockPos pos) {
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        double degree = 57.29577951308232;
        double dx = this.fakePlayer.m_20185_() - ((double)x + 0.5);
        double dy = this.fakePlayer.m_20186_() - (double)y;
        double dz = this.fakePlayer.m_20189_() - ((double)z + 0.5);
        this.fakePlayer.m_146922_((float)(-(Math.atan2(dx, dz) * degree + 180.0)));
        this.fakePlayer.m_146926_((float)(Math.atan2(dy, Math.sqrt(dx * dx + dz * dz)) * degree));
    }

    @Override
    public Optional<Vec3> getRenderBoundingBoxOuterPosition() {
        return this.fakePlayer != null && this.fakePlayer.f_36083_ != null ? Optional.of(this.fakePlayer.f_36083_.m_20182_()) : Optional.empty();
    }
}

