/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.registries.ForgeRegistries;
import reliquary.init.ModItems;
import reliquary.item.MobCharmDefinition;
import reliquary.item.MobCharmFragmentItem;
import reliquary.item.MobCharmItem;
import reliquary.reference.Settings;
import reliquary.util.RegistryHelper;

public class MobCharmRegistry {
    private static final Map<String, MobCharmDefinition> REGISTERED_CHARM_DEFINITIONS = new HashMap<String, MobCharmDefinition>();
    private static final Map<String, MobCharmDefinition> ENTITY_NAME_CHARM_DEFINITIONS = new HashMap<String, MobCharmDefinition>();
    private static final Set<String> DYNAMICALLY_REGISTERED = new HashSet<String>();

    private MobCharmRegistry() {
    }

    public static void registerMobCharmDefinition(MobCharmDefinition charmDefinition) {
        REGISTERED_CHARM_DEFINITIONS.put(charmDefinition.getRegistryName(), charmDefinition);
        for (String registryName : charmDefinition.getEntities()) {
            ENTITY_NAME_CHARM_DEFINITIONS.put(registryName, charmDefinition);
        }
    }

    static Optional<MobCharmDefinition> getCharmDefinitionFor(Entity entity) {
        return Optional.ofNullable(ENTITY_NAME_CHARM_DEFINITIONS.get(RegistryHelper.getRegistryName(entity).toString()));
    }

    public static Optional<MobCharmDefinition> getCharmDefinitionFor(ItemStack stack) {
        if (stack.m_41720_() != ModItems.MOB_CHARM.get()) {
            return Optional.empty();
        }
        return Optional.ofNullable(ENTITY_NAME_CHARM_DEFINITIONS.get(MobCharmItem.getEntityRegistryName(stack)));
    }

    public static Set<String> getRegisteredNames() {
        return REGISTERED_CHARM_DEFINITIONS.keySet();
    }

    public static void registerDynamicCharmDefinitions() {
        for (EntityType entityType : ForgeRegistries.ENTITY_TYPES) {
            String registryName = RegistryHelper.getRegistryName(entityType).toString();
            HashSet blockedEntities = new HashSet((Collection)Settings.COMMON.items.mobCharm.entityBlockList.get());
            if (ENTITY_NAME_CHARM_DEFINITIONS.containsKey(registryName) || entityType.m_20674_() != MobCategory.MONSTER || blockedEntities.contains(registryName)) continue;
            MobCharmRegistry.registerMobCharmDefinition(new MobCharmDefinition(registryName));
            DYNAMICALLY_REGISTERED.add(registryName);
        }
    }

    public static void handleAddingFragmentDrops(LivingDropsEvent evt) {
        if (Boolean.TRUE.equals(Settings.COMMON.disable.disableCharms.get()) || !evt.getSource().m_19385_().equals("player")) {
            return;
        }
        LivingEntity entity = evt.getEntity();
        ResourceLocation regName = RegistryHelper.getRegistryName((Entity)entity);
        if (!DYNAMICALLY_REGISTERED.contains(regName.toString())) {
            return;
        }
        double dynamicDropChance = (Double)Settings.COMMON.items.mobCharmFragment.dropChance.get() + (double)evt.getLootingLevel() * (Double)Settings.COMMON.items.mobCharmFragment.lootingMultiplier.get();
        if ((double)entity.m_9236_().f_46441_.m_188501_() < dynamicDropChance) {
            ItemEntity fragmentItemEntity = new ItemEntity(entity.m_9236_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), ((MobCharmFragmentItem)ModItems.MOB_CHARM_FRAGMENT.get()).getStackFor(regName.toString()));
            fragmentItemEntity.m_32060_();
            evt.getDrops().add(fragmentItemEntity);
        }
    }

    static {
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.ZOMBIE);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.SKELETON);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.WITHER_SKELETON);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.CREEPER);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.WITCH);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.ZOMBIFIED_PIGLIN);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.CAVE_SPIDER);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.SPIDER);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.ENDERMAN);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.GHAST);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.SLIME);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.MAGMA_CUBE);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.BLAZE);
        MobCharmRegistry.registerMobCharmDefinition(MobCharmDefinition.GUARDIAN);
    }
}

