/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import reliquary.item.ItemBase;
import reliquary.item.MobCharmRegistry;
import reliquary.util.NBTHelper;

public class MobCharmFragmentItem
extends ItemBase {
    public MobCharmFragmentItem() {
        super(new Item.Properties());
    }

    @Override
    public void addCreativeTabItems(Consumer<ItemStack> itemConsumer) {
        for (String entityRegistryName : MobCharmRegistry.getRegisteredNames()) {
            itemConsumer.accept(this.getStackFor(entityRegistryName));
        }
    }

    public ItemStack getStackFor(String entityRegistryName) {
        ItemStack ret = new ItemStack((ItemLike)this);
        NBTHelper.putString("entity", ret, entityRegistryName);
        return ret;
    }

    public static String getEntityRegistryName(ItemStack charm) {
        return NBTHelper.getString("entity", charm);
    }

    public static ResourceLocation getEntityEggRegistryName(ItemStack charm) {
        return new ResourceLocation(MobCharmFragmentItem.getEntityRegistryName(charm));
    }

    @Override
    public MutableComponent getName(ItemStack stack) {
        EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(MobCharmFragmentItem.getEntityEggRegistryName(stack));
        if (entityType == null) {
            return super.getName(stack);
        }
        return Component.m_237110_((String)this.m_5524_(), (Object[])new Object[]{entityType.m_20676_().getString()}).m_130940_(ChatFormatting.GREEN);
    }
}

