/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import reliquary.handler.CommonEventHandler;
import reliquary.handler.HandlerPriority;
import reliquary.handler.IPlayerDeathHandler;
import reliquary.init.ModItems;
import reliquary.item.ItemBase;
import reliquary.network.PacketHandler;
import reliquary.network.SpawnAngelheartVialParticlesPacket;
import reliquary.reference.Settings;
import reliquary.util.EntityHelper;
import reliquary.util.InventoryHelper;

public class AngelheartVialItem
extends ItemBase {
    public AngelheartVialItem() {
        super(new Item.Properties());
        CommonEventHandler.registerPlayerDeathHandler(new IPlayerDeathHandler(){

            @Override
            public boolean canApply(Player player, LivingDeathEvent event) {
                return InventoryHelper.playerHasItem(player, (Item)ModItems.ANGELHEART_VIAL.get());
            }

            @Override
            public boolean apply(Player player, LivingDeathEvent event) {
                AngelheartVialItem.decreaseAngelHeartByOne(player);
                PacketHandler.sendToClient((ServerPlayer)player, new SpawnAngelheartVialParticlesPacket());
                player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_11983_, SoundSource.NEUTRAL, 1.0f, player.m_9236_().f_46441_.m_188501_() * 0.1f + 0.9f);
                float amountHealed = player.m_21233_() * (float)((Integer)Settings.COMMON.items.angelHeartVial.healPercentageOfMaxLife.get()).intValue() / 100.0f;
                player.m_21153_(amountHealed);
                if (Boolean.TRUE.equals(Settings.COMMON.items.angelHeartVial.removeNegativeStatus.get())) {
                    EntityHelper.removeNegativeStatusEffects((LivingEntity)player);
                }
                return true;
            }

            @Override
            public HandlerPriority getPriority() {
                return HandlerPriority.LOW;
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_5812_(ItemStack stack) {
        return true;
    }

    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        return new ItemStack((ItemLike)ModItems.EMPTY_POTION_VIAL.get());
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }

    private static void decreaseAngelHeartByOne(Player player) {
        for (int slot = 0; slot < player.m_150109_().f_35974_.size(); ++slot) {
            if (((ItemStack)player.m_150109_().f_35974_.get(slot)).m_41619_() || ((ItemStack)player.m_150109_().f_35974_.get(slot)).m_41720_() != ModItems.ANGELHEART_VIAL.get()) continue;
            player.m_150109_().m_7407_(slot, 1);
            return;
        }
    }
}

