/*
 * Decompiled with CFR 0.152.
 */
package reliquary.compat.jei.magazines;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import reliquary.init.ModItems;
import reliquary.item.BulletItem;
import reliquary.item.MagazineItem;
import reliquary.reference.Settings;
import reliquary.util.RegistryHelper;
import reliquary.util.potions.PotionEssence;
import reliquary.util.potions.PotionMap;
import reliquary.util.potions.XRPotionHelper;

public class MagazineRecipeMaker {
    private MagazineRecipeMaker() {
    }

    public static List<CraftingRecipe> getRecipes() {
        ArrayList<CraftingRecipe> recipes = new ArrayList<CraftingRecipe>();
        MagazineRecipeMaker.addRegularMagazines(recipes);
        if (Boolean.FALSE.equals(Settings.COMMON.disable.disablePotions.get())) {
            MagazineRecipeMaker.addPotionMagazines(recipes);
        }
        return recipes;
    }

    private static void addRegularMagazines(ArrayList<CraftingRecipe> recipes) {
        ImmutableMap bulletMagazines = new ImmutableMap.Builder().put((Object)((BulletItem)ModItems.NEUTRAL_BULLET.get()), (Object)((MagazineItem)ModItems.NEUTRAL_MAGAZINE.get())).put((Object)((BulletItem)ModItems.EXORCISM_BULLET.get()), (Object)((MagazineItem)ModItems.EXORCISM_MAGAZINE.get())).put((Object)((BulletItem)ModItems.BLAZE_BULLET.get()), (Object)((MagazineItem)ModItems.BLAZE_MAGAZINE.get())).put((Object)((BulletItem)ModItems.ENDER_BULLET.get()), (Object)((MagazineItem)ModItems.ENDER_MAGAZINE.get())).put((Object)((BulletItem)ModItems.CONCUSSIVE_BULLET.get()), (Object)((MagazineItem)ModItems.CONCUSSIVE_MAGAZINE.get())).put((Object)((BulletItem)ModItems.BUSTER_BULLET.get()), (Object)((MagazineItem)ModItems.BUSTER_MAGAZINE.get())).put((Object)((BulletItem)ModItems.SEEKER_BULLET.get()), (Object)((MagazineItem)ModItems.SEEKER_MAGAZINE.get())).put((Object)((BulletItem)ModItems.SAND_BULLET.get()), (Object)((MagazineItem)ModItems.SAND_MAGAZINE.get())).put((Object)((BulletItem)ModItems.STORM_BULLET.get()), (Object)((MagazineItem)ModItems.STORM_MAGAZINE.get())).build();
        for (Map.Entry bulletMagazine : bulletMagazines.entrySet()) {
            NonNullList inputs = NonNullList.m_122779_();
            MagazineRecipeMaker.addShots((List<Ingredient>)inputs, (BulletItem)bulletMagazine.getKey());
            inputs.add((Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ModItems.EMPTY_MAGAZINE.get())}));
            MagazineRecipeMaker.addShots((List<Ingredient>)inputs, (BulletItem)bulletMagazine.getKey());
            ItemStack output = new ItemStack((ItemLike)bulletMagazine.getValue());
            recipes.add((CraftingRecipe)new ShapedRecipe(RegistryHelper.getRegistryName(output.m_41720_()), "reliquary.magazine", CraftingBookCategory.MISC, 3, 3, inputs, output));
        }
    }

    private static void addPotionMagazines(ArrayList<CraftingRecipe> recipes) {
        for (PotionEssence essence : PotionMap.uniquePotions) {
            List<MobEffectInstance> effects = XRPotionHelper.changePotionEffectsDuration(essence.getEffects(), 0.2f);
            NonNullList inputs = NonNullList.m_122779_();
            MagazineRecipeMaker.addShots((List<Ingredient>)inputs, effects);
            inputs.add((Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ModItems.EMPTY_MAGAZINE.get())}));
            MagazineRecipeMaker.addShots((List<Ingredient>)inputs, effects);
            ItemStack output = new ItemStack((ItemLike)ModItems.NEUTRAL_MAGAZINE.get());
            XRPotionHelper.addPotionEffectsToStack(output, effects);
            recipes.add((CraftingRecipe)new ShapedRecipe(RegistryHelper.getRegistryName(output.m_41720_()), "reliquary.potion.magazine", CraftingBookCategory.MISC, 3, 3, inputs, output));
        }
    }

    private static void addShots(List<Ingredient> inputs, List<MobEffectInstance> effects) {
        MagazineRecipeMaker.addShots(inputs, effects, (BulletItem)ModItems.NEUTRAL_BULLET.get());
    }

    private static void addShots(List<Ingredient> inputs, BulletItem shotType) {
        MagazineRecipeMaker.addShots(inputs, Collections.emptyList(), shotType);
    }

    private static void addShots(List<Ingredient> inputs, List<MobEffectInstance> effects, BulletItem shotType) {
        ItemStack shot = new ItemStack((ItemLike)shotType);
        if (!effects.isEmpty()) {
            XRPotionHelper.addPotionEffectsToStack(shot, effects);
        }
        for (int i = 0; i < 4; ++i) {
            inputs.add(Ingredient.m_43927_((ItemStack[])new ItemStack[]{shot}));
        }
    }
}

