/*
 * Decompiled with CFR 0.152.
 */
package reliquary.block;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import reliquary.block.tile.AlkahestryAltarBlockEntity;
import reliquary.init.ModBlocks;
import reliquary.item.AlkahestryTomeItem;
import reliquary.item.ICreativeTabItemGenerator;
import reliquary.reference.Settings;
import reliquary.util.BlockEntityHelper;

public class AlkahestryAltarBlock
extends Block
implements EntityBlock,
ICreativeTabItemGenerator {
    private static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");

    public AlkahestryAltarBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60913_(1.5f, 5.0f));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public void addCreativeTabItems(Consumer<ItemStack> itemConsumer) {
        itemConsumer.accept(new ItemStack((ItemLike)this));
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return Boolean.TRUE.equals(state.m_61143_((Property)ACTIVE)) ? AlkahestryAltarBlock.getAltarActiveLightLevel() : 0;
    }

    private static int getAltarActiveLightLevel() {
        return (Integer)Settings.COMMON.blocks.altar.outputLightLevelWhileActive.get();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ACTIVE});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new AlkahestryAltarBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.f_46443_) {
            return null;
        }
        return BlockEntityHelper.createTickerHelper(blockEntityType, (BlockEntityType)ModBlocks.ALKAHESTRY_ALTAR_TILE_TYPE.get(), (l, p, s, be) -> be.serverTick(l, p));
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        if (Boolean.FALSE.equals(state.m_61143_((Property)ACTIVE)) || level.m_46468_() >= 12000L || !level.m_46861_(pos.m_7494_()) || rand.m_188503_(3) != 0) {
            return;
        }
        level.m_7106_((ParticleOptions)ParticleTypes.f_123811_, (double)pos.m_123341_() + 0.5 + rand.m_188583_() / 8.0, (double)pos.m_123342_() + 1.1, (double)pos.m_123343_() + 0.5 + rand.m_188583_() / 8.0, 0.9, 0.9, 0.0);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(hand);
        if (Boolean.TRUE.equals(state.m_61143_((Property)ACTIVE))) {
            return InteractionResult.CONSUME;
        }
        AlkahestryAltarBlockEntity altar = (AlkahestryAltarBlockEntity)level.m_7702_(pos);
        if (altar == null || heldItem.m_41619_()) {
            return InteractionResult.SUCCESS;
        }
        if (heldItem.m_41720_() == Items.f_42451_) {
            int slot = this.getSlotWithRedstoneDust(player);
            if (slot == -1) {
                return InteractionResult.SUCCESS;
            }
            this.playSoundAndSpawnParticles(level, pos, altar);
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            player.m_150109_().m_7407_(slot, 1);
            altar.addRedstone(level, pos);
        } else if (heldItem.m_41720_() instanceof AlkahestryTomeItem && AlkahestryTomeItem.getCharge(heldItem) > 0) {
            this.playSoundAndSpawnParticles(level, pos, altar);
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            AlkahestryTomeItem.useCharge(heldItem, 1);
            altar.addRedstone(level, pos);
        }
        return InteractionResult.CONSUME;
    }

    private void playSoundAndSpawnParticles(Level level, BlockPos pos, AlkahestryAltarBlockEntity altar) {
        level.m_5594_(null, pos, SoundEvents.f_12031_, SoundSource.BLOCKS, 0.3f, 0.5f + 0.5f * (float)altar.getRedstoneCount() + (float)(level.f_46441_.m_188583_() / 8.0));
        for (int particles = level.f_46441_.m_188503_(3); particles < 3 + altar.getRedstoneCount() * 4 + altar.getRedstoneCount(); ++particles) {
            level.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, (double)pos.m_123341_() + 0.5 + level.f_46441_.m_188583_() / 5.0, (double)pos.m_123342_() + 1.2, (double)pos.m_123343_() + 0.5 + level.f_46441_.m_188583_() / 5.0, 1.0, 0.0, 0.0);
        }
    }

    private int getSlotWithRedstoneDust(Player player) {
        for (int slot = 0; slot < player.m_150109_().f_35974_.size(); ++slot) {
            if (((ItemStack)player.m_150109_().f_35974_.get(slot)).m_41619_() || ((ItemStack)player.m_150109_().f_35974_.get(slot)).m_41720_() != Items.f_42451_) continue;
            return slot;
        }
        return -1;
    }

    public static void updateAltarBlockState(boolean active, Level level, BlockPos pos) {
        level.m_46597_(pos, (BlockState)level.m_8055_(pos).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(active)));
        AlkahestryAltarBlockEntity te = (AlkahestryAltarBlockEntity)level.m_7702_(pos);
        if (te != null) {
            if (active) {
                te.startCycle(level);
            } else {
                te.stopCycle();
            }
        }
    }
}

