/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.api.common.helper;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelShapeHelper {
    public static VoxelShape combineAll(Collection<VoxelShape> shapes) {
        VoxelShape result = Shapes.m_83040_();
        for (VoxelShape shape : shapes) {
            result = Shapes.m_83113_((VoxelShape)result, (VoxelShape)shape, (BooleanOp)BooleanOp.f_82695_);
        }
        return result.m_83296_();
    }

    public static VoxelShape combineAll(VoxelShape ... shapes) {
        VoxelShape result = Shapes.m_83040_();
        for (VoxelShape shape : shapes) {
            result = Shapes.m_83113_((VoxelShape)result, (VoxelShape)shape, (BooleanOp)BooleanOp.f_82695_);
        }
        return result.m_83296_();
    }

    public static Map<Direction, VoxelShape> getRotatedShapes(VoxelShape shape) {
        return Arrays.stream(Direction.values()).collect(Collectors.toMap(Function.identity(), direction -> VoxelShapeHelper.rotateShape(shape, direction)));
    }

    public static Map<Direction, VoxelShape> getHorizontalRotatedShapes(VoxelShape shape) {
        return (Map)Util.m_137469_(new EnumMap(Direction.class), map -> {
            map.put(Direction.NORTH, shape);
            map.put(Direction.EAST, VoxelShapeHelper.rotateShapeHorizontal(shape, Direction.EAST));
            map.put(Direction.SOUTH, VoxelShapeHelper.rotateShapeHorizontal(shape, Direction.SOUTH));
            map.put(Direction.WEST, VoxelShapeHelper.rotateShapeHorizontal(shape, Direction.WEST));
        });
    }

    public static VoxelShape rotateShape(VoxelShape shape, Direction direction) {
        ArrayList rotatedPieces = new ArrayList();
        Vec3 vec3 = new Vec3(-0.5, -0.5, -0.5);
        shape.m_83299_().forEach(aabb -> {
            aabb = aabb.m_82386_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            AABB rotated = switch (direction) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.DOWN -> aabb;
                case Direction.UP -> new AABB(aabb.f_82288_, -aabb.f_82289_, -aabb.f_82290_, aabb.f_82291_, -aabb.f_82292_, -aabb.f_82293_);
                case Direction.NORTH -> new AABB(aabb.f_82288_, -aabb.f_82290_, aabb.f_82289_, aabb.f_82291_, -aabb.f_82293_, aabb.f_82292_);
                case Direction.SOUTH -> new AABB(-aabb.f_82288_, -aabb.f_82290_, -aabb.f_82289_, -aabb.f_82291_, -aabb.f_82293_, -aabb.f_82292_);
                case Direction.WEST -> new AABB(aabb.f_82289_, -aabb.f_82290_, -aabb.f_82288_, aabb.f_82292_, -aabb.f_82293_, -aabb.f_82291_);
                case Direction.EAST -> new AABB(-aabb.f_82289_, -aabb.f_82290_, aabb.f_82288_, -aabb.f_82292_, -aabb.f_82293_, aabb.f_82291_);
            };
            rotatedPieces.add(Shapes.m_83064_((AABB)rotated.m_82386_(-vec3.f_82479_, -vec3.f_82481_, -vec3.f_82481_)));
        });
        return rotatedPieces.stream().reduce(Shapes.m_83040_(), Shapes::m_83110_);
    }

    public static VoxelShape rotateShapeHorizontal(VoxelShape shape, Direction direction) {
        ArrayList rotatedPieces = new ArrayList();
        Vec3 vec3 = new Vec3(-0.5, -0.5, -0.5);
        shape.m_83299_().forEach(aabb -> {
            aabb = aabb.m_82386_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            AABB rotated = switch (direction) {
                case Direction.NORTH -> aabb;
                case Direction.SOUTH -> new AABB(-aabb.f_82288_, aabb.f_82289_, -aabb.f_82290_, -aabb.f_82291_, aabb.f_82292_, -aabb.f_82293_);
                case Direction.WEST -> new AABB(aabb.f_82290_, aabb.f_82289_, -aabb.f_82288_, aabb.f_82293_, aabb.f_82292_, -aabb.f_82291_);
                case Direction.EAST -> new AABB(-aabb.f_82290_, aabb.f_82289_, aabb.f_82288_, -aabb.f_82293_, aabb.f_82292_, aabb.f_82291_);
                default -> throw new IllegalStateException("Unexpected value: " + direction);
            };
            rotatedPieces.add(Shapes.m_83064_((AABB)rotated.m_82386_(-vec3.f_82479_, -vec3.f_82481_, -vec3.f_82481_)));
        });
        return rotatedPieces.stream().reduce(Shapes.m_83040_(), Shapes::m_83110_);
    }

    private static double[] adjustValues(Direction direction, double minX, double minZ, double maxX, double maxZ) {
        switch (direction) {
            case WEST: {
                double temp_minX = minX;
                minX = 1.0 - maxX;
                double temp_minZ = minZ;
                minZ = 1.0 - maxZ;
                maxX = 1.0 - temp_minX;
                maxZ = 1.0 - temp_minZ;
                break;
            }
            case NORTH: {
                double temp_minX = minX;
                minX = minZ;
                minZ = 1.0 - maxX;
                maxX = maxZ;
                maxZ = 1.0 - temp_minX;
                break;
            }
            case SOUTH: {
                double temp_minX = minX;
                minX = 1.0 - maxZ;
                double temp_minZ = minZ;
                minZ = temp_minX;
                double temp_maxX = maxX;
                maxX = 1.0 - temp_minZ;
                maxZ = temp_maxX;
            }
        }
        return new double[]{minX, minZ, maxX, maxZ};
    }

    public static EnumMap<Direction.Axis, VoxelShape> rotateAxis(VoxelShape shape) {
        return new EnumMap<Direction.Axis, VoxelShape>((Map<Direction.Axis, VoxelShape>)ImmutableMap.of((Object)Direction.Axis.Y, (Object)shape, (Object)Direction.Axis.X, (Object)VoxelShapeHelper.rotateAxis(shape, Direction.Axis.X), (Object)Direction.Axis.Z, (Object)VoxelShapeHelper.rotateAxis(shape, Direction.Axis.Z)));
    }

    public static VoxelShape rotateAxis(VoxelShape shape, Direction.Axis axis) {
        if (axis == Direction.Axis.Y) {
            return shape;
        }
        HashSet rotatedShapes = new HashSet();
        shape.m_83286_((x1, y1, z1, x2, y2, z2) -> {
            y1 *= 16.0;
            y2 *= 16.0;
            x1 *= 16.0;
            x2 *= 16.0;
            z1 *= 16.0;
            z2 *= 16.0;
            if (axis == Direction.Axis.X) {
                rotatedShapes.add(Block.m_49796_((double)y1, (double)x1, (double)z1, (double)y2, (double)x2, (double)z2));
            } else {
                rotatedShapes.add(Block.m_49796_((double)x1, (double)z1, (double)y1, (double)x2, (double)z2, (double)y2));
            }
        });
        return (VoxelShape)rotatedShapes.stream().reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    }

    public static VoxelShape add(double x1, double y1, double z1, double x2, double y2, double z2, VoxelShape ... shapes) {
        HashSet result = new HashSet();
        for (VoxelShape shape : shapes) {
            shape.m_83286_((x, y, z, x3, y3, z3) -> result.add(Block.m_49796_((double)((x *= 16.0) + x1), (double)((y *= 16.0) + y1), (double)((z *= 16.0) + z1), (double)((x3 *= 16.0) + x2), (double)((y3 *= 16.0) + y2), (double)((z3 *= 16.0) + z2))));
        }
        return result.stream().reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).orElse(Shapes.m_83040_());
    }
}

