/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.client.model;

import com.starfish_studios.naturalist.common.entity.Vulture;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

@OnlyIn(value=Dist.CLIENT)
public class VultureModel
extends GeoModel<Vulture> {
    public ResourceLocation getModelResource(Vulture vulture) {
        return new ResourceLocation("naturalist", "geo/vulture.geo.json");
    }

    public ResourceLocation getTextureResource(Vulture vulture) {
        return new ResourceLocation("naturalist", "textures/entity/vulture.png");
    }

    public ResourceLocation getAnimationResource(Vulture vulture) {
        return new ResourceLocation("naturalist", "animations/vulture.animation.json");
    }

    public void setCustomAnimations(Vulture animatable, long instanceId, AnimationState<Vulture> animationState) {
        super.setCustomAnimations((GeoAnimatable)animatable, instanceId, animationState);
        if (animationState == null) {
            return;
        }
        EntityModelData extraDataOfType = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        head.setRotX(extraDataOfType.headPitch() * ((float)Math.PI / 180));
        head.setRotY(extraDataOfType.netHeadYaw() * ((float)Math.PI / 180));
    }
}

