/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items.tools;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.misc.ILevelData;
import de.ellpeck.naturesaura.data.ItemModelGenerator;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.misc.LevelData;
import de.ellpeck.naturesaura.reg.ICustomItemModel;
import de.ellpeck.naturesaura.reg.IModItem;
import de.ellpeck.naturesaura.reg.ModRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemPickaxe
extends PickaxeItem
implements IModItem,
ICustomItemModel {
    private final String baseName;

    public ItemPickaxe(String baseName, Tier material, int damage, float speed) {
        super(material, damage, speed, new Item.Properties());
        this.baseName = baseName;
        ModRegistry.ALL_ITEMS.add(this);
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (this == ModItems.INFUSED_IRON_PICKAXE) {
            Player player = context.m_43723_();
            Level level = context.m_43725_();
            BlockPos pos = context.m_8083_();
            ItemStack stack = player.m_21120_(context.m_43724_());
            BlockState state = level.m_8055_(pos);
            BlockState result = (BlockState)NaturesAuraAPI.BOTANIST_PICKAXE_CONVERSIONS.get((Object)state);
            if (result != null) {
                if (!level.f_46443_) {
                    level.m_46597_(pos, result);
                    LevelData data = (LevelData)ILevelData.getLevelData(level);
                    data.addMossStone(pos);
                }
                level.m_5594_(player, pos, SoundEvents.f_12447_, SoundSource.BLOCKS, 1.0f, 1.0f);
                stack.m_41622_(15, (LivingEntity)player, p -> p.m_21190_(context.m_43724_()));
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_6883_(ItemStack stack, Level levelIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (this == ModItems.SKY_PICKAXE) {
            if (!(entityIn instanceof Player)) {
                return;
            }
            if (!isSelected || levelIn.f_46443_) {
                return;
            }
            AABB bounds = new AABB(entityIn.m_20183_()).m_82400_(4.0);
            for (ItemEntity item : levelIn.m_45976_(ItemEntity.class, bounds)) {
                if (item.f_19797_ >= 5 || !item.m_6084_()) continue;
                item.m_32010_(0);
                item.m_6123_((Player)entityIn);
            }
        }
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, Player player) {
        if (itemstack.m_41720_() == ModItems.DEPTH_PICKAXE && Helper.isToolEnabled(itemstack) && player.m_9236_().m_8055_(pos).m_204336_(Tags.Blocks.ORES)) {
            Helper.mineRecursively(player.m_9236_(), pos, pos, itemstack, 5, 5, s -> s.m_204336_(Tags.Blocks.ORES));
            return true;
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() == ModItems.DEPTH_PICKAXE && Helper.toggleToolEnabled(player, stack)) {
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return super.m_7203_(level, player, hand);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return Helper.makeRechargeProvider(stack, true);
    }

    @Override
    public void generateCustomItemModel(ItemModelGenerator generator) {
        if (this == ModItems.DEPTH_PICKAXE) {
            return;
        }
        ((ItemModelBuilder)generator.withExistingParent(this.getBaseName(), "item/handheld")).texture("layer0", "item/" + this.getBaseName());
    }
}

