/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.container.IAuraContainer;
import de.ellpeck.naturesaura.api.aura.container.ItemAuraContainer;
import de.ellpeck.naturesaura.api.aura.item.IAuraRecharge;
import de.ellpeck.naturesaura.api.render.ITrinketItem;
import de.ellpeck.naturesaura.enchant.ModEnchantments;
import de.ellpeck.naturesaura.items.ItemImpl;
import de.ellpeck.naturesaura.reg.ICustomCreativeTab;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class ItemAuraCache
extends ItemImpl
implements ITrinketItem,
ICustomCreativeTab {
    private final int capacity;

    public ItemAuraCache(String name, int capacity) {
        super(name, new Item.Properties().m_41487_(1));
        this.capacity = capacity;
    }

    public void m_6883_(ItemStack stackIn, Level levelIn, Entity entityIn, int itemSlot, boolean isSelected) {
        Player player;
        if (!levelIn.f_46443_ && entityIn instanceof Player && (player = (Player)entityIn).m_6144_() && stackIn.getCapability(NaturesAuraAPI.CAP_AURA_CONTAINER).isPresent()) {
            IAuraContainer container = (IAuraContainer)stackIn.getCapability(NaturesAuraAPI.CAP_AURA_CONTAINER).orElse(null);
            if (container.getStoredAura() <= 0) {
                return;
            }
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                boolean isArmor;
                ItemStack stack = player.m_150109_().m_8020_(i);
                IAuraRecharge recharge = (IAuraRecharge)stack.getCapability(NaturesAuraAPI.CAP_AURA_RECHARGE).orElse(null);
                if (recharge != null) {
                    if (!recharge.rechargeFromContainer(container, itemSlot, i, player.m_150109_().f_35977_ == i)) continue;
                    break;
                }
                if (stack.getEnchantmentLevel(ModEnchantments.AURA_MENDING) <= 0) continue;
                int mainSize = player.m_150109_().f_35974_.size();
                boolean bl = isArmor = i >= mainSize && i < mainSize + player.m_150109_().f_35975_.size();
                if ((isArmor || player.m_150109_().f_35977_ == i) && Helper.rechargeAuraItem(stack, container, 1000)) break;
            }
        }
    }

    @Override
    public List<ItemStack> getCreativeTabItems() {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((ItemLike)this));
        ItemStack full = new ItemStack((ItemLike)this);
        full.getCapability(NaturesAuraAPI.CAP_AURA_CONTAINER).ifPresent(container -> {
            container.storeAura(container.getMaxAura(), false);
            ret.add(full);
        });
        return ret;
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        if (stack.getCapability(NaturesAuraAPI.CAP_AURA_CONTAINER).isPresent()) {
            IAuraContainer container = (IAuraContainer)stack.getCapability(NaturesAuraAPI.CAP_AURA_CONTAINER).orElse(null);
            return Math.round((float)container.getStoredAura() / (float)container.getMaxAura() * 13.0f);
        }
        return 0;
    }

    public int m_142159_(ItemStack stack) {
        IAuraContainer cap = (IAuraContainer)stack.getCapability(NaturesAuraAPI.CAP_AURA_CONTAINER).orElse(null);
        return cap != null ? cap.getAuraColor() : super.m_142159_(stack);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundTag nbt) {
        return new ICapabilityProvider(){
            private final LazyOptional<ItemAuraContainer> container = LazyOptional.of(() -> new ItemAuraContainer(stack, null, ItemAuraCache.this.capacity));

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
                if (capability == NaturesAuraAPI.CAP_AURA_CONTAINER) {
                    return this.container.cast();
                }
                return LazyOptional.empty();
            }
        };
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(ItemStack stack, Player player, ITrinketItem.RenderType type, PoseStack matrices, MultiBufferSource buffer, int packedLight, boolean isHolding) {
        if (type == ITrinketItem.RenderType.BODY && !isHolding) {
            boolean legs;
            boolean chest = !((ItemStack)player.m_150109_().f_35975_.get(EquipmentSlot.CHEST.m_20749_())).m_41619_();
            boolean bl = legs = !((ItemStack)player.m_150109_().f_35975_.get(EquipmentSlot.LEGS.m_20749_())).m_41619_();
            matrices.m_252880_(-0.15f, 0.65f, chest ? -0.195f : (legs ? -0.165f : -0.1475f));
            matrices.m_85841_(0.5f, 0.5f, 0.5f);
            matrices.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            Minecraft.m_91087_().m_91291_().m_269128_(stack, ItemDisplayContext.GROUND, packedLight, OverlayTexture.f_118083_, matrices, buffer, player.m_9236_(), 0);
        }
    }
}

