/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.chunk.effect;

import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.chunk.IDrainSpotEffect;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.chunk.AuraChunk;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EggItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.tuple.Pair;

public class AnimalEffect
implements IDrainSpotEffect {
    public static final ResourceLocation NAME = new ResourceLocation("naturesaura", "animal");
    private int chance;
    private AABB bb;

    private boolean calcValues(Level level, BlockPos pos, Integer spot) {
        if (spot <= 0) {
            return false;
        }
        Pair<Integer, Integer> auraAndSpots = IAuraChunk.getAuraAndSpotAmountInArea(level, pos, 30);
        int aura = (Integer)auraAndSpots.getLeft();
        if (aura < 1500000) {
            return false;
        }
        this.chance = Math.min(50, Mth.m_14167_((float)((float)Math.abs(aura) / 500000.0f / (float)((Integer)auraAndSpots.getRight()).intValue())));
        if (this.chance <= 0) {
            return false;
        }
        int dist = Mth.m_14045_((int)(Math.abs(aura) / 150000), (int)5, (int)35);
        this.bb = new AABB(pos).m_82400_((double)dist);
        return true;
    }

    @Override
    public IDrainSpotEffect.ActiveType isActiveHere(Player player, LevelChunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        if (!this.calcValues(player.m_9236_(), pos, spot)) {
            return IDrainSpotEffect.ActiveType.INACTIVE;
        }
        if (!this.bb.m_82390_(player.m_146892_())) {
            return IDrainSpotEffect.ActiveType.INACTIVE;
        }
        if (!NaturesAuraAPI.instance().isEffectPowderActive(player.m_9236_(), player.m_20183_(), NAME)) {
            return IDrainSpotEffect.ActiveType.INHIBITED;
        }
        return IDrainSpotEffect.ActiveType.ACTIVE;
    }

    @Override
    public ItemStack getDisplayIcon() {
        return new ItemStack((ItemLike)Items.f_42521_);
    }

    @Override
    public void update(Level level, LevelChunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot, AuraChunk.DrainSpot actualSpot) {
        if (level.m_46467_() % 200L != 0L) {
            return;
        }
        if (!this.calcValues(level, pos, spot)) {
            return;
        }
        List animals = level.m_45976_(Animal.class, this.bb);
        if (animals.size() >= (Integer)ModConfig.instance.maxAnimalsAroundPowder.get()) {
            return;
        }
        List items = level.m_45976_(ItemEntity.class, this.bb);
        for (ItemEntity item : items) {
            ItemStack stack;
            if (!item.m_6084_() || !NaturesAuraAPI.instance().isEffectPowderActive(level, item.m_20183_(), NAME) || !((stack = item.m_32055_()).m_41720_() instanceof EggItem) || item.m_32059_() < item.lifespan / 2) continue;
            if (stack.m_41613_() <= 1) {
                item.m_6074_();
            } else {
                stack.m_41774_(1);
                item.m_32045_(stack);
            }
            Chicken chicken = new Chicken(EntityType.f_20555_, level);
            chicken.m_146762_(-24000);
            chicken.m_6034_(item.m_20185_(), item.m_20186_(), item.m_20189_());
            level.m_7967_((Entity)chicken);
            BlockPos closestSpot = IAuraChunk.getHighestSpot(level, item.m_20183_(), 35, pos);
            IAuraChunk.getAuraChunk(level, closestSpot).drainAura(closestSpot, 2000);
        }
        if (level.f_46441_.m_188503_(20) <= this.chance) {
            if (animals.size() < 2) {
                return;
            }
            Animal first = (Animal)animals.get(level.f_46441_.m_188503_(animals.size()));
            if (first.m_6162_() || first.m_27593_()) {
                return;
            }
            if (!NaturesAuraAPI.instance().isEffectPowderActive(level, first.m_20183_(), NAME)) {
                return;
            }
            Optional<Animal> secondOptional = animals.stream().filter(e -> e != first && !e.m_27593_() && !e.m_6162_()).min(Comparator.comparingDouble(e -> e.m_20280_((Entity)first)));
            if (secondOptional.isEmpty()) {
                return;
            }
            Animal second = secondOptional.get();
            if (second.m_20280_((Entity)first) > 25.0) {
                return;
            }
            this.setInLove(first);
            this.setInLove(second);
            BlockPos closestSpot = IAuraChunk.getHighestSpot(level, first.m_20183_(), 35, pos);
            IAuraChunk.getAuraChunk(level, closestSpot).drainAura(closestSpot, 3500);
        }
    }

    private void setInLove(Animal animal) {
        animal.m_27595_(null);
        for (int j = 0; j < 7; ++j) {
            animal.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, animal.m_20185_() + (double)(animal.m_9236_().f_46441_.m_188501_() * animal.m_20205_() * 2.0f) - (double)animal.m_20205_(), animal.m_20186_() + 0.5 + (double)(animal.m_9236_().f_46441_.m_188501_() * animal.m_20206_()), animal.m_20189_() + (double)(animal.m_9236_().f_46441_.m_188501_() * animal.m_20205_() * 2.0f) - (double)animal.m_20205_(), animal.m_9236_().f_46441_.m_188583_() * 0.02, animal.m_9236_().f_46441_.m_188583_() * 0.02, animal.m_9236_().f_46441_.m_188583_() * 0.02);
        }
    }

    @Override
    public boolean appliesHere(LevelChunk chunk, IAuraChunk auraChunk, IAuraType type) {
        return (Boolean)ModConfig.instance.animalEffect.get();
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }
}

