/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ITickableBlockEntity;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;

public class BlockEntityAnimalGenerator
extends BlockEntityImpl
implements ITickableBlockEntity {
    private int timeRemaining;
    private int amountToRelease;

    public BlockEntityAnimalGenerator(BlockPos pos, BlockState state) {
        super(ModBlockEntities.ANIMAL_GENERATOR, pos, state);
    }

    @Override
    public void tick() {
        if (!this.f_58857_.f_46443_) {
            if (this.f_58857_.m_46467_() % 10L != 0L) {
                return;
            }
            if (this.timeRemaining <= 0) {
                return;
            }
            int remain = this.amountToRelease;
            if (this.canGenerateRightNow(remain)) {
                this.generateAura(remain);
                PacketHandler.sendToAllAround(this.f_58857_, this.f_58858_, 32, new PacketParticles(this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_(), PacketParticles.Type.ANIMAL_GEN_CREATE, new int[0]));
            }
            this.timeRemaining -= 10;
        }
    }

    @Override
    public boolean wantsLimitRemover() {
        return true;
    }

    public boolean isBusy() {
        return this.timeRemaining > 0;
    }

    public void setGenerationValues(int time, int amount) {
        this.timeRemaining = time;
        this.amountToRelease = amount;
    }
}

