/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.api.misc.ILevelData;
import de.ellpeck.naturesaura.blocks.BlockContainerImpl;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityEnderCrate;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import de.ellpeck.naturesaura.blocks.tiles.render.RenderEnderCrate;
import de.ellpeck.naturesaura.data.BlockStateGenerator;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.reg.ICustomBlockState;
import de.ellpeck.naturesaura.reg.ITESRProvider;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.NetworkHooks;

public class BlockEnderCrate
extends BlockContainerImpl
implements ITESRProvider<BlockEntityEnderCrate>,
ICustomBlockState {
    public BlockEnderCrate() {
        super("ender_crate", BlockEntityEnderCrate.class, BlockBehaviour.Properties.m_284310_().m_60978_(5.0f).m_60953_(s -> 7).m_60918_(SoundType.f_56742_));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static String getEnderName(ItemStack stack) {
        if (!stack.m_41782_()) {
            return "";
        }
        return stack.m_41783_().m_128461_("naturesaura:ender_name");
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addEnderNameInfo(ItemStack stack, List<Component> tooltip) {
        String name = BlockEnderCrate.getEnderName(stack);
        if (name != null && !name.isEmpty()) {
            tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.DARK_PURPLE + I18n.m_118938_((String)"info.naturesaura.ender_name", (Object[])new Object[]{ChatFormatting.ITALIC + name + ChatFormatting.RESET}))));
        } else {
            tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.DARK_PURPLE + I18n.m_118938_((String)"info.naturesaura.ender_name.missing", (Object[])new Object[0]))));
        }
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        ItemStack stack = event.getLeft();
        if (stack.m_41720_() != this.m_5456_() && stack.m_41720_() != ModItems.ENDER_ACCESS) {
            return;
        }
        ItemStack second = event.getRight();
        if (second.m_41720_() != Items.f_42545_ || second.m_41613_() < stack.m_41613_()) {
            return;
        }
        String name = event.getName();
        if (name == null || name.isEmpty()) {
            return;
        }
        if (ILevelData.getOverworldData(player.m_9236_()).isEnderStorageLocked(name)) {
            return;
        }
        ItemStack output = stack.m_41777_();
        output.m_41784_().m_128359_("naturesaura:ender_name", name);
        event.setOutput(output);
        event.setMaterialCost(stack.m_41613_());
        event.setCost(1);
    }

    public InteractionResult m_6227_(BlockState state, Level levelIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntityEnderCrate crate;
        BlockEntity tile;
        if (!levelIn.f_46443_ && (tile = levelIn.m_7702_(pos)) instanceof BlockEntityEnderCrate && (crate = (BlockEntityEnderCrate)tile).canOpen() && crate.canUseRightNow(2500)) {
            crate.drainAura(2500);
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)crate, (BlockPos)pos);
        }
        return InteractionResult.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, @Nullable BlockGetter levelIn, List<Component> tooltip, TooltipFlag flagIn) {
        BlockEnderCrate.addEnderNameInfo(stack, tooltip);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState stateIn, Level levelIn, BlockPos pos, RandomSource rand) {
        for (int i = 0; i < 3; ++i) {
            int j = rand.m_188503_(2) * 2 - 1;
            int k = rand.m_188503_(2) * 2 - 1;
            double d0 = (double)pos.m_123341_() + 0.5 + 0.25 * (double)j;
            double d1 = (float)pos.m_123342_() + rand.m_188501_();
            double d2 = (double)pos.m_123343_() + 0.5 + 0.25 * (double)k;
            double d3 = rand.m_188501_() * (float)j;
            double d4 = ((double)rand.m_188501_() - 0.5) * 0.125;
            double d5 = rand.m_188501_() * (float)k;
            levelIn.m_7106_((ParticleOptions)ParticleTypes.f_123760_, d0, d1, d2, d3, d4, d5);
        }
    }

    @Override
    public void generateCustomBlockState(BlockStateGenerator generator) {
        generator.simpleBlock((Block)this, (ModelFile)generator.models().cubeBottomTop(this.getBaseName(), generator.modLoc("block/" + this.getBaseName()), generator.modLoc("block/" + this.getBaseName() + "_bottom"), generator.modLoc("block/" + this.getBaseName() + "_top")));
    }

    @Override
    public void registerTESR() {
        BlockEntityRenderers.m_173590_(ModBlockEntities.ENDER_CRATE, RenderEnderCrate::new);
    }
}

