/*
 * Decompiled with CFR 0.152.
 */
package cn.mcmod_mmf.mmlib.item;

import cn.mcmod_mmf.mmlib.item.IFoodLike;
import cn.mcmod_mmf.mmlib.item.info.FoodInfo;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ItemFoodBase
extends Item
implements IFoodLike {
    private final FoodInfo info;

    public ItemFoodBase(Item.Properties prop, FoodInfo info) {
        super(prop);
        this.info = info;
    }

    public boolean m_41472_() {
        return this.info != null;
    }

    public void m_7373_(ItemStack itemStack, Level level, List<Component> tooltips, TooltipFlag flag) {
        super.m_7373_(itemStack, level, tooltips, flag);
        if (!this.shouldAddEffectTooltips()) {
            return;
        }
        if (!this.getFoodInfo().getEffects().isEmpty()) {
            this.addEffectTooltips(tooltips);
        }
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        ItemStack itemstack = super.m_5922_(stack, level, entity);
        if (stack.m_41613_() > 0) {
            if (entity instanceof Player) {
                Player entityplayer = (Player)entity;
                if (entityplayer.m_150110_().f_35937_) {
                    return itemstack;
                }
                if (!entityplayer.m_36356_(this.getCraftingRemainingItem(stack))) {
                    entityplayer.m_36176_(this.getCraftingRemainingItem(stack), true);
                }
            }
            return itemstack;
        }
        return entity instanceof Player && ((Player)entity).m_150110_().f_35937_ ? itemstack : this.getCraftingRemainingItem(stack);
    }

    public SoundEvent m_6023_() {
        return super.m_6023_();
    }

    public SoundEvent m_6061_() {
        return super.m_6061_();
    }

    public FoodProperties m_41473_() {
        FoodProperties.Builder food = new FoodProperties.Builder().m_38760_(this.getFoodInfo().getAmount()).m_38758_(this.getFoodInfo().getCalories());
        if (this.getFoodInfo().isAlwaysEat()) {
            food.m_38765_();
        }
        if (this.getFoodInfo().getEatTime() <= 16) {
            food.m_38766_();
        }
        this.getFoodInfo().getEffects().forEach(k -> food.effect((Supplier)k.getFirst(), ((Float)k.getSecond()).floatValue()));
        return food.m_38767_();
    }

    public int m_8105_(ItemStack stack) {
        if (this.getFoodInfo() != null) {
            return this.getFoodInfo().getEatTime();
        }
        return super.m_8105_(stack);
    }

    @Override
    public FoodInfo getFoodInfo() {
        return this.info;
    }

    @Override
    public boolean shouldAddEffectTooltips() {
        return this.info != null;
    }
}

