/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.shapes;

import java.util.ArrayList;
import java.util.List;
import mcjty.lib.varia.Check32;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbuilder.modules.builder.items.ShapeCardItem;
import mcjty.rftoolsbuilder.modules.scanner.ScannerConfiguration;
import mcjty.rftoolsbuilder.shapes.IFormula;
import mcjty.rftoolsbuilder.shapes.Scan;
import mcjty.rftoolsbuilder.shapes.ScanDataManager;
import mcjty.rftoolsbuilder.shapes.ScanDataManagerClient;
import mcjty.rftoolsbuilder.shapes.ShapeBlockInfo;
import mcjty.rftoolsbuilder.shapes.ShapeModifier;
import mcjty.rftoolsbuilder.shapes.ShapeOperation;
import mcjty.rftoolsbuilder.shapes.ShapeRotation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class Formulas {
    private static float squaredDistance3D(float cx, float cy, float cz, float x1, float y1, float z1, float dx2, float dy2, float dz2) {
        return (x1 - cx) * (x1 - cx) / dx2 + (y1 - cy) * (y1 - cy) / dy2 + (z1 - cz) * (z1 - cz) / dz2;
    }

    private static float squaredDistance2D(float cx, float cz, float x1, float z1, float dx2, float dz2) {
        return (x1 - cx) * (x1 - cx) / dx2 + (z1 - cz) * (z1 - cz) / dz2;
    }

    static class FormulaPrism
    implements IFormula {
        private int x1;
        private int y1;
        private int z1;
        private int x2;
        private int y2;
        private int z2;

        FormulaPrism() {
        }

        @Override
        public void setup(Level world, BlockPos thisCoord, BlockPos dimension, BlockPos offset, CompoundTag card) {
            int dx = dimension.m_123341_();
            int dy = dimension.m_123342_();
            int dz = dimension.m_123343_();
            int xCoord = thisCoord.m_123341_();
            int yCoord = thisCoord.m_123342_();
            int zCoord = thisCoord.m_123343_();
            BlockPos tl = new BlockPos(xCoord - dx / 2 + offset.m_123341_(), yCoord - dy / 2 + offset.m_123342_(), zCoord - dz / 2 + offset.m_123343_());
            this.x1 = tl.m_123341_();
            this.y1 = tl.m_123342_();
            this.z1 = tl.m_123343_();
            this.x2 = this.x1 + dx;
            this.y2 = this.y1 + dy;
            this.z2 = this.z1 + dz;
        }

        @Override
        public boolean isInside(int x, int y, int z) {
            if (y < this.y1 || y >= this.y2) {
                return false;
            }
            int dy = y - this.y1;
            return x >= this.x1 + dy && x < this.x2 - dy && z >= this.z1 + dy && z < this.z2 - dy;
        }
    }

    static class FormulaCone
    implements IFormula {
        private float centerx;
        private float centerz;
        private float dx2;
        private float dz2;
        private float dy;
        private float topy;
        private int davg;

        FormulaCone() {
        }

        @Override
        public void setup(Level world, BlockPos thisCoord, BlockPos dimension, BlockPos offset, CompoundTag card) {
            int dx = dimension.m_123341_();
            int dy = dimension.m_123342_();
            int dz = dimension.m_123343_();
            int xCoord = thisCoord.m_123341_();
            int yCoord = thisCoord.m_123342_();
            int zCoord = thisCoord.m_123343_();
            this.centerx = (float)(xCoord + offset.m_123341_()) + (dx % 2 != 0 ? 0.0f : -0.5f);
            this.centerz = (float)(zCoord + offset.m_123343_()) + (dz % 2 != 0 ? 0.0f : -0.5f);
            float factor = 1.7f;
            this.dx2 = dx == 0 ? 0.5f : ((float)dx + factor) * ((float)dx + factor) / 4.0f;
            this.dz2 = dz == 0 ? 0.5f : ((float)dz + factor) * ((float)dz + factor) / 4.0f;
            this.davg = (int)(((float)(dx + dz) + factor * 2.0f) / 2.0f);
            this.dy = (float)dy + 0.5f;
            this.topy = yCoord + offset.m_123342_() + dy / 2;
        }

        @Override
        public boolean isInside(int x, int y, int z) {
            double distance = Math.sqrt(Formulas.squaredDistance2D(this.centerx, this.centerz, x, z, this.dx2, this.dz2));
            return (float)((int)(distance * (double)(this.davg / 2 + 1))) <= (float)(this.davg / 2 - 1) * (this.topy - (float)y) / this.dy;
        }
    }

    static class FormulaCylinder
    implements IFormula {
        private float centerx;
        private float centerz;
        private float dx2;
        private float dz2;
        private int davg;

        FormulaCylinder() {
        }

        @Override
        public void setup(Level world, BlockPos thisCoord, BlockPos dimension, BlockPos offset, CompoundTag card) {
            int dx = dimension.m_123341_();
            int dy = dimension.m_123342_();
            int dz = dimension.m_123343_();
            int xCoord = thisCoord.m_123341_();
            int yCoord = thisCoord.m_123342_();
            int zCoord = thisCoord.m_123343_();
            this.centerx = (float)(xCoord + offset.m_123341_()) + (dx % 2 != 0 ? 0.0f : -0.5f);
            this.centerz = (float)(zCoord + offset.m_123343_()) + (dz % 2 != 0 ? 0.0f : -0.5f);
            float factor = 1.7f;
            this.dx2 = dx == 0 ? 0.5f : ((float)dx + factor) * ((float)dx + factor) / 4.0f;
            this.dz2 = dz == 0 ? 0.5f : ((float)dz + factor) * ((float)dz + factor) / 4.0f;
            this.davg = (int)(((float)(dx + dz) + factor * 2.0f) / 2.0f);
        }

        @Override
        public boolean isInside(int x, int y, int z) {
            double distance = Math.sqrt(Formulas.squaredDistance2D(this.centerx, this.centerz, x, z, this.dx2, this.dz2));
            return (int)(distance * (double)(this.davg / 2 + 1)) <= this.davg / 2 - 1;
        }
    }

    static class FormulaCappedCylinder
    implements IFormula {
        private float centerx;
        private float centerz;
        private float dx2;
        private float dz2;
        private int davg;
        private int y1;
        private int y2;

        FormulaCappedCylinder() {
        }

        @Override
        public void setup(Level world, BlockPos thisCoord, BlockPos dimension, BlockPos offset, CompoundTag card) {
            int dx = dimension.m_123341_();
            int dy = dimension.m_123342_();
            int dz = dimension.m_123343_();
            int xCoord = thisCoord.m_123341_();
            int yCoord = thisCoord.m_123342_();
            int zCoord = thisCoord.m_123343_();
            this.centerx = (float)(xCoord + offset.m_123341_()) + (dx % 2 != 0 ? 0.0f : -0.5f);
            this.centerz = (float)(zCoord + offset.m_123343_()) + (dz % 2 != 0 ? 0.0f : -0.5f);
            float factor = 1.7f;
            this.dx2 = dx == 0 ? 0.5f : ((float)dx + factor) * ((float)dx + factor) / 4.0f;
            this.dz2 = dz == 0 ? 0.5f : ((float)dz + factor) * ((float)dz + factor) / 4.0f;
            this.davg = (int)(((float)(dx + dz) + factor * 2.0f) / 2.0f);
            this.y1 = yCoord - dy / 2 + offset.m_123342_();
            this.y2 = this.y1 + dy;
        }

        @Override
        public boolean isInside(int x, int y, int z) {
            if (y < this.y1 || y >= this.y2) {
                return false;
            }
            double distance = Math.sqrt(Formulas.squaredDistance2D(this.centerx, this.centerz, x, z, this.dx2, this.dz2));
            return (int)(distance * (double)(this.davg / 2 + 1)) <= this.davg / 2 - 1;
        }
    }

    static class FormulaBox
    implements IFormula {
        private int x1;
        private int y1;
        private int z1;
        private int x2;
        private int y2;
        private int z2;

        FormulaBox() {
        }

        @Override
        public void setup(Level world, BlockPos thisCoord, BlockPos dimension, BlockPos offset, CompoundTag card) {
            int dx = dimension.m_123341_();
            int dy = dimension.m_123342_();
            int dz = dimension.m_123343_();
            int xCoord = thisCoord.m_123341_();
            int yCoord = thisCoord.m_123342_();
            int zCoord = thisCoord.m_123343_();
            BlockPos tl = new BlockPos(xCoord - dx / 2 + offset.m_123341_(), yCoord - dy / 2 + offset.m_123342_(), zCoord - dz / 2 + offset.m_123343_());
            this.x1 = tl.m_123341_();
            this.y1 = tl.m_123342_();
            this.z1 = tl.m_123343_();
            this.x2 = this.x1 + dx;
            this.y2 = this.y1 + dy;
            this.z2 = this.z1 + dz;
        }

        @Override
        public boolean isInside(int x, int y, int z) {
            return x >= this.x1 && x < this.x2 && y >= this.y1 && y < this.y2 && z >= this.z1 && z < this.z2;
        }

        @Override
        public boolean isBorder(int x, int y, int z) {
            return x == this.x1 || x == this.x2 - 1 || y == this.y1 || y == this.y2 - 1 || z == this.z1 || z == this.z2 - 1;
        }
    }

    static class FormulaBottomDome
    implements IFormula {
        private float centerx;
        private float centery;
        private float centerz;
        private float dx2;
        private float dy2;
        private float dz2;
        private int davg;

        FormulaBottomDome() {
        }

        @Override
        public void setup(Level world, BlockPos thisCoord, BlockPos dimension, BlockPos offset, CompoundTag card) {
            int dx = dimension.m_123341_();
            int dy = dimension.m_123342_();
            int dz = dimension.m_123343_();
            int xCoord = thisCoord.m_123341_();
            int yCoord = thisCoord.m_123342_();
            int zCoord = thisCoord.m_123343_();
            this.centerx = (float)(xCoord + offset.m_123341_()) + (dx % 2 != 0 ? 0.0f : -0.5f);
            this.centery = (float)(yCoord + offset.m_123342_()) + (dy % 2 != 0 ? 0.0f : -0.5f);
            this.centerz = (float)(zCoord + offset.m_123343_()) + (dz % 2 != 0 ? 0.0f : -0.5f);
            float factor = 1.8f;
            this.dx2 = dx == 0 ? 0.5f : ((float)dx + factor) * ((float)dx + factor) / 4.0f;
            this.dy2 = dy == 0 ? 0.5f : ((float)dy + factor) * ((float)dy + factor) / 4.0f;
            this.dz2 = dz == 0 ? 0.5f : ((float)dz + factor) * ((float)dz + factor) / 4.0f;
            this.davg = (int)(((float)(dx + dy + dz) + factor * 3.0f) / 3.0f);
        }

        @Override
        public boolean isInside(int x, int y, int z) {
            if ((float)y > this.centery) {
                return false;
            }
            double distance = Math.sqrt(Formulas.squaredDistance3D(this.centerx, this.centery, this.centerz, x, y, z, this.dx2, this.dy2, this.dz2));
            return (int)(distance * (double)(this.davg / 2 + 1)) <= this.davg / 2 - 1;
        }
    }

    static class FormulaTopDome
    implements IFormula {
        private float centerx;
        private float centery;
        private float centerz;
        private float dx2;
        private float dy2;
        private float dz2;
        private int davg;

        FormulaTopDome() {
        }

        @Override
        public void setup(Level world, BlockPos thisCoord, BlockPos dimension, BlockPos offset, CompoundTag card) {
            int dx = dimension.m_123341_();
            int dy = dimension.m_123342_();
            int dz = dimension.m_123343_();
            int xCoord = thisCoord.m_123341_();
            int yCoord = thisCoord.m_123342_();
            int zCoord = thisCoord.m_123343_();
            this.centerx = (float)(xCoord + offset.m_123341_()) + (dx % 2 != 0 ? 0.0f : -0.5f);
            this.centery = (float)(yCoord + offset.m_123342_()) + (dy % 2 != 0 ? 0.0f : -0.5f);
            this.centerz = (float)(zCoord + offset.m_123343_()) + (dz % 2 != 0 ? 0.0f : -0.5f);
            float factor = 1.8f;
            this.dx2 = dx == 0 ? 0.5f : ((float)dx + factor) * ((float)dx + factor) / 4.0f;
            this.dy2 = dy == 0 ? 0.5f : ((float)dy + factor) * ((float)dy + factor) / 4.0f;
            this.dz2 = dz == 0 ? 0.5f : ((float)dz + factor) * ((float)dz + factor) / 4.0f;
            this.davg = (int)(((float)(dx + dy + dz) + factor * 3.0f) / 3.0f);
        }

        @Override
        public boolean isInside(int x, int y, int z) {
            if ((float)y < this.centery) {
                return false;
            }
            double distance = Math.sqrt(Formulas.squaredDistance3D(this.centerx, this.centery, this.centerz, x, y, z, this.dx2, this.dy2, this.dz2));
            return (int)(distance * (double)(this.davg / 2 + 1)) <= this.davg / 2 - 1;
        }
    }

    static class FormulaSphere
    implements IFormula {
        private float centerx;
        private float centery;
        private float centerz;
        private float dx2;
        private float dy2;
        private float dz2;
        private int davg;

        FormulaSphere() {
        }

        @Override
        public void setup(Level world, BlockPos thisCoord, BlockPos dimension, BlockPos offset, CompoundTag card) {
            int dx = dimension.m_123341_();
            int dy = dimension.m_123342_();
            int dz = dimension.m_123343_();
            int xCoord = thisCoord.m_123341_();
            int yCoord = thisCoord.m_123342_();
            int zCoord = thisCoord.m_123343_();
            this.centerx = (float)(xCoord + offset.m_123341_()) + (dx % 2 != 0 ? 0.0f : -0.5f);
            this.centery = (float)(yCoord + offset.m_123342_()) + (dy % 2 != 0 ? 0.0f : -0.5f);
            this.centerz = (float)(zCoord + offset.m_123343_()) + (dz % 2 != 0 ? 0.0f : -0.5f);
            float factor = 1.8f;
            this.dx2 = dx == 0 ? 0.5f : ((float)dx + factor) * ((float)dx + factor) / 4.0f;
            this.dy2 = dy == 0 ? 0.5f : ((float)dy + factor) * ((float)dy + factor) / 4.0f;
            this.dz2 = dz == 0 ? 0.5f : ((float)dz + factor) * ((float)dz + factor) / 4.0f;
            this.davg = (int)(((float)(dx + dy + dz) + factor * 3.0f) / 3.0f);
        }

        @Override
        public boolean isInside(int x, int y, int z) {
            double distance = Math.sqrt(Formulas.squaredDistance3D(this.centerx, this.centery, this.centerz, x, y, z, this.dx2, this.dy2, this.dz2));
            return (int)(distance * (double)(this.davg / 2 + 1)) <= this.davg / 2 - 1;
        }
    }

    static class FormulaHeart
    implements IFormula {
        private float centerx;
        private float centery;
        private float centerz;
        private int dx;
        private int dy;
        private int dz;

        FormulaHeart() {
        }

        @Override
        public void setup(Level world, BlockPos thisCoord, BlockPos dimension, BlockPos offset, CompoundTag card) {
            this.dx = dimension.m_123341_();
            this.dy = dimension.m_123342_();
            this.dz = dimension.m_123343_();
            int xCoord = thisCoord.m_123341_();
            int yCoord = thisCoord.m_123342_();
            int zCoord = thisCoord.m_123343_();
            this.centerx = (float)(xCoord + offset.m_123341_()) + (this.dx % 2 != 0 ? 0.0f : -0.5f);
            this.centery = (float)(yCoord + offset.m_123342_()) + (this.dy % 2 != 0 ? 0.0f : -0.5f);
            this.centerz = (float)(zCoord + offset.m_123343_()) + (this.dz % 2 != 0 ? 0.0f : -0.5f);
        }

        @Override
        public boolean isInside(int x, int y, int z) {
            double f3;
            double f2;
            double xx = (double)((float)x - this.centerx) * 2.6 / (double)this.dx + 0.1;
            double yy = (double)((float)z - this.centerz) * 1.6 / (double)this.dz + 0.1;
            double zz = (double)((float)y - this.centery) * 2.4 / (double)this.dy + 0.2;
            double f1 = Math.pow(xx * xx + 2.25 * yy * yy + zz * zz - 1.0, 3.0);
            double f = f1 - (f2 = xx * xx * zz * zz * zz) - (f3 = 0.1125 * yy * yy * zz * zz * zz);
            return f < 0.0;
        }
    }

    static class FormulaTorus
    implements IFormula {
        private float smallRadius;
        private float bigRadius;
        private float centerx;
        private float centery;
        private float centerz;

        FormulaTorus() {
        }

        @Override
        public void setup(Level world, BlockPos thisCoord, BlockPos dimension, BlockPos offset, CompoundTag card) {
            int dx = dimension.m_123341_();
            int dy = dimension.m_123342_();
            int dz = dimension.m_123343_();
            this.smallRadius = (float)(dy - 2) / 2.0f;
            this.bigRadius = (float)(dx - 2) / 2.0f - this.smallRadius;
            int xCoord = thisCoord.m_123341_();
            int yCoord = thisCoord.m_123342_();
            int zCoord = thisCoord.m_123343_();
            this.centerx = (float)(xCoord + offset.m_123341_()) + (dx % 2 != 0 ? 0.0f : -0.5f);
            this.centery = (float)(yCoord + offset.m_123342_()) + (dy % 2 != 0 ? 0.0f : -0.5f);
            this.centerz = (float)(zCoord + offset.m_123343_()) + (dz % 2 != 0 ? 0.0f : -0.5f);
        }

        @Override
        public boolean isInside(int x, int y, int z) {
            double rr = (double)this.bigRadius - Math.sqrt(((float)x - this.centerx) * ((float)x - this.centerx) + ((float)z - this.centerz) * ((float)z - this.centerz));
            double f = rr * rr + (double)(((float)y - this.centery) * ((float)y - this.centery)) - (double)(this.smallRadius * this.smallRadius);
            return f < 0.0;
        }
    }

    static class FormulaComposition
    implements IFormula {
        private BlockPos thisCoord;
        private BlockState blockState;
        private List<IFormula> formulas = new ArrayList<IFormula>();
        private List<Bounds> bounds = new ArrayList<Bounds>();
        private List<ShapeModifier> modifiers = new ArrayList<ShapeModifier>();
        private List<BlockState> blockStates = new ArrayList<BlockState>();

        FormulaComposition() {
        }

        @Override
        public void setup(Level world, BlockPos thisCoord, BlockPos dimension, BlockPos offset, CompoundTag card) {
            this.thisCoord = thisCoord;
            if (card == null) {
                return;
            }
            int dx = dimension.m_123341_();
            int dy = dimension.m_123342_();
            int dz = dimension.m_123343_();
            if (dx <= 0 || dy <= 0 || dz <= 0) {
                return;
            }
            ListTag children = card.m_128437_("children", 10);
            for (int i = 0; i < children.size(); ++i) {
                Block block;
                CompoundTag childTag = children.m_128728_(i);
                IFormula formula = ShapeCardItem.createCorrectFormula(childTag);
                String op = childTag.m_128461_("mod_op");
                ShapeOperation operation = ShapeOperation.getByName(op);
                boolean flip = childTag.m_128471_("mod_flipy");
                String rot = childTag.m_128461_("mod_rot");
                ShapeRotation rotation = ShapeRotation.getByName(rot);
                this.modifiers.add(new ShapeModifier(operation, flip, rotation));
                BlockPos dim = ShapeCardItem.getClampedDimension(childTag, (int)((Integer)ScannerConfiguration.maxScannerDimension.get()));
                BlockPos off = ShapeCardItem.getClampedOffset(childTag, (int)((Integer)ScannerConfiguration.maxScannerOffset.get()));
                BlockPos o = off.m_121955_((Vec3i)offset);
                formula.setup(world, thisCoord, dim, o, childTag);
                this.formulas.add(formula);
                dim = rotation.transformDimension(dim);
                BlockPos tl = new BlockPos(o.m_123341_() - dim.m_123341_() / 2, o.m_123342_() - dim.m_123342_() / 2, o.m_123343_() - dim.m_123343_() / 2);
                this.bounds.add(new Bounds(tl, tl.m_121955_((Vec3i)dim), o));
                BlockState state = null;
                if (childTag.m_128441_("ghost_block") && (block = Tools.getBlock((ResourceLocation)new ResourceLocation(childTag.m_128461_("ghost_block")))) != null) {
                    state = block.m_49966_();
                }
                this.blockStates.add(state);
            }
        }

        @Override
        public void getCheckSumClient(CompoundTag tc, Check32 crc) {
            ShapeCardItem.getLocalChecksum(tc, crc);
            ListTag children = tc.m_128437_("children", 10);
            for (int i = 0; i < children.size(); ++i) {
                CompoundTag childTag = children.m_128728_(i);
                IFormula formula = ShapeCardItem.createCorrectFormula(childTag);
                formula.getCheckSumClient(childTag, crc);
                crc.add(childTag.m_128471_("mod_flipy") ? 1 : 0);
                String rot = childTag.m_128461_("mod_rot");
                ShapeRotation rotation = ShapeRotation.getByName(rot);
                crc.add(rotation.ordinal());
                String op = childTag.m_128461_("mod_op");
                ShapeOperation operation = ShapeOperation.getByName(op);
                crc.add(operation.ordinal());
                if (!childTag.m_128441_("ghost_block")) continue;
                Object state = null;
                Block block = Tools.getBlock((ResourceLocation)new ResourceLocation(childTag.m_128461_("ghost_block")));
                if (block == null) continue;
                crc.add(Block.m_49956_((BlockState)block.m_49966_()));
            }
        }

        @Override
        public BlockState getLastState() {
            return this.blockState;
        }

        @Override
        public boolean isInside(int x, int y, int z) {
            this.blockState = null;
            x -= this.thisCoord.m_123341_();
            y -= this.thisCoord.m_123342_();
            z -= this.thisCoord.m_123343_();
            boolean ok = false;
            block10: for (int i = 0; i < this.formulas.size(); ++i) {
                IFormula formula = this.formulas.get(i);
                Bounds bounds = this.bounds.get(i);
                ShapeModifier modifier = this.modifiers.get(i);
                boolean inside = false;
                if (bounds.in(x, y, z)) {
                    int tx = x;
                    int ty = y;
                    int tz = z;
                    BlockPos o = bounds.getOffset();
                    switch (modifier.getRotation()) {
                        case X: {
                            tx = x;
                            ty = z - o.m_123343_() + o.m_123342_();
                            tz = y - o.m_123342_() + o.m_123343_();
                            break;
                        }
                        case Y: {
                            tx = z - o.m_123343_() + o.m_123341_();
                            ty = y;
                            tz = x - o.m_123341_() + o.m_123343_();
                            break;
                        }
                        case Z: {
                            tx = y - o.m_123342_() + o.m_123341_();
                            ty = x - o.m_123341_() + o.m_123342_();
                            tz = z;
                            break;
                        }
                    }
                    if (modifier.isFlipY()) {
                        ty = bounds.getP1().m_123342_() + bounds.getP2().m_123342_() - 1 - ty;
                    }
                    inside = formula.isInside(tx + this.thisCoord.m_123341_(), ty + this.thisCoord.m_123342_(), tz + this.thisCoord.m_123343_());
                }
                switch (modifier.getOperation()) {
                    case UNION: {
                        if (!inside) continue block10;
                        ok = true;
                        this.blockState = this.blockStates.get(i);
                        if (this.blockState != null) continue block10;
                        this.blockState = formula.getLastState();
                        continue block10;
                    }
                    case SUBTRACT: {
                        if (!inside) continue block10;
                        ok = false;
                        continue block10;
                    }
                    case INTERSECT: {
                        if (inside && ok) {
                            if (this.blockState != null) continue block10;
                            this.blockState = this.blockStates.get(i);
                            if (this.blockState != null) continue block10;
                            this.blockState = formula.getLastState();
                            continue block10;
                        }
                        ok = false;
                    }
                }
            }
            return ok;
        }

        @Override
        public boolean isCustom() {
            return true;
        }
    }

    static class FormulaScan
    implements IFormula {
        private byte[] data;
        private List<BlockState> palette = new ArrayList<BlockState>();
        private int x1;
        private int y1;
        private int z1;
        private int dx;
        private int dy;
        private int dz;
        private BlockState lastState = null;

        FormulaScan() {
        }

        @Override
        public void getCheckSumClient(CompoundTag tc, Check32 crc) {
            ShapeCardItem.getLocalChecksum(tc, crc);
            int scanId = tc.m_128451_("scanid");
            crc.add(scanId);
            crc.add(ScanDataManagerClient.getScansClient().getScanDirtyCounterClient(scanId));
        }

        @Override
        public void setup(Level world, BlockPos thisCoord, BlockPos dimension, BlockPos offset, CompoundTag card) {
            this.data = null;
            if (card == null) {
                return;
            }
            this.dx = dimension.m_123341_();
            this.dy = dimension.m_123342_();
            this.dz = dimension.m_123343_();
            if (this.dx <= 0 || this.dy <= 0 || this.dz <= 0) {
                return;
            }
            int xCoord = thisCoord.m_123341_();
            int yCoord = thisCoord.m_123342_();
            int zCoord = thisCoord.m_123343_();
            BlockPos tl = new BlockPos(xCoord - this.dx / 2 + offset.m_123341_(), yCoord - this.dy / 2 + offset.m_123342_(), zCoord - this.dz / 2 + offset.m_123343_());
            this.x1 = tl.m_123341_();
            this.y1 = tl.m_123342_();
            this.z1 = tl.m_123343_();
            this.palette.clear();
            int scanId = card.m_128451_("scanid");
            if (scanId != 0) {
                Scan scan = ScanDataManager.get(world).loadScan(world, scanId);
                this.palette = new ArrayList<BlockState>(scan.getMaterialPalette());
                byte[] datas = scan.getRledata();
                this.data = new byte[this.dx * this.dy * this.dz];
                int j = 0;
                for (int i = 0; i < datas.length / 2; ++i) {
                    int cnt = datas[i * 2] & 0xFF;
                    int c = datas[i * 2 + 1] & 0xFF;
                    if (c == 255) {
                        c = 0;
                    }
                    while (cnt > 0 && j < this.data.length) {
                        this.data[j++] = (byte)c;
                        --cnt;
                    }
                    if (j >= this.data.length) break;
                }
            }
        }

        @Override
        public boolean isBorder(int x, int y, int z) {
            if (x <= this.x1 || x >= this.x1 + this.dx - 1 || y <= this.y1 || y >= this.y1 + this.dy - 1 || z <= this.z1 || z >= this.z1 + this.dz - 1) {
                return this.isInsideSafe(x, y, z);
            }
            if (this.data == null) {
                return false;
            }
            int index = (x - this.x1) * this.dy * this.dz + (z - this.z1) * this.dy + (y - this.y1);
            if (!(this.isInsideInternal(index - 1) && this.isInsideInternal(index + 1) && this.isInsideInternal(index - this.dy) && this.isInsideInternal(index + this.dy) && this.isInsideInternal(index - this.dy * this.dz) && this.isInsideInternal(index + this.dy * this.dz))) {
                return this.isInsideInternal(index);
            }
            return false;
        }

        @Override
        public boolean isVisible(int x, int y, int z) {
            int index = (x - this.x1) * this.dy * this.dz + (z - this.z1) * this.dy + (y - this.y1);
            return this.isClear(index - 1) || this.isClear(index + 1) || this.isClear(index - this.dy) || this.isClear(index + this.dy) || this.isClear(index - this.dy * this.dz) || this.isClear(index + this.dy * this.dz);
        }

        public boolean isClear(int index) {
            if (!this.isInsideInternal(index)) {
                return true;
            }
            BlockState state = this.getLastState();
            if (state != null) {
                return ShapeBlockInfo.isNonSolidBlock(state.m_60734_());
            }
            return false;
        }

        private boolean isInsideInternal(int index) {
            if (this.data[index] == 0) {
                return false;
            }
            int idx = (this.data[index] & 0xFF) - 1;
            this.lastState = this.palette.get(idx);
            return true;
        }

        @Override
        public boolean isInsideSafe(int x, int y, int z) {
            if (x < this.x1 || x >= this.x1 + this.dx || y < this.y1 || y >= this.y1 + this.dy || z < this.z1 || z >= this.z1 + this.dz) {
                return false;
            }
            return this.isInside(x, y, z);
        }

        @Override
        public boolean isInside(int x, int y, int z) {
            if (this.data == null) {
                return false;
            }
            int index = (x - this.x1) * this.dy * this.dz + (z - this.z1) * this.dy + (y - this.y1);
            return this.isInsideInternal(index);
        }

        @Override
        public BlockState getLastState() {
            return this.lastState;
        }
    }

    public static class Bounds {
        private BlockPos p1;
        private BlockPos p2;
        private BlockPos offset;

        public Bounds(BlockPos p1, BlockPos p2, BlockPos offset) {
            this.p1 = p1;
            this.p2 = p2;
            this.offset = offset;
        }

        public BlockPos getP1() {
            return this.p1;
        }

        public BlockPos getP2() {
            return this.p2;
        }

        public BlockPos getOffset() {
            return this.offset;
        }

        public boolean in(BlockPos p) {
            int x = p.m_123341_();
            int y = p.m_123342_();
            int z = p.m_123343_();
            return this.in(x, y, z);
        }

        public boolean in(int x, int y, int z) {
            return x >= this.p1.m_123341_() && x < this.p2.m_123341_() && y >= this.p1.m_123342_() && y < this.p2.m_123342_() && z >= this.p1.m_123343_() && z < this.p2.m_123343_();
        }
    }
}

