/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.shield.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.client.AbstractDynamicBakedModel;
import mcjty.rftoolsbuilder.modules.shield.ShieldModule;
import mcjty.rftoolsbuilder.modules.shield.ShieldRenderingMode;
import mcjty.rftoolsbuilder.modules.shield.ShieldTexture;
import mcjty.rftoolsbuilder.modules.shield.blocks.ShieldingBlock;
import mcjty.rftoolsbuilder.modules.shield.blocks.ShieldingTileEntity;
import mcjty.rftoolsbuilder.modules.shield.client.ShieldRenderData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

public class ShieldBakedModel
extends AbstractDynamicBakedModel {
    public static final ResourceLocation TEXTURE_TRANSPARENT = new ResourceLocation("rftoolsbuilder", "block/shield/shieldtransparent");
    public static final ResourceLocation TEXTURE_FULL = new ResourceLocation("rftoolsbuilder", "block/shield/shieldfull");
    private static Map<ShieldTexture, TextureAtlasSprite[]> shields;
    private static TextureAtlasSprite shieldtransparent;
    private static TextureAtlasSprite shieldfull;
    private static final ChunkRenderTypeSet RT_TRANSLUCENT;
    private static final ChunkRenderTypeSet RT_CUTOUT;
    private static final ChunkRenderTypeSet RT_SOLID;

    private static void initTextures() {
        if (shields == null) {
            shields = new HashMap<ShieldTexture, TextureAtlasSprite[]>();
            for (ShieldTexture texture : ShieldTexture.values()) {
                TextureAtlasSprite[] sprites = new TextureAtlasSprite[]{ShieldBakedModel.getTexture((ResourceLocation)new ResourceLocation("rftoolsbuilder", "block/" + texture.getPath() + "/shield0")), ShieldBakedModel.getTexture((ResourceLocation)new ResourceLocation("rftoolsbuilder", "block/" + texture.getPath() + "/shield1")), ShieldBakedModel.getTexture((ResourceLocation)new ResourceLocation("rftoolsbuilder", "block/" + texture.getPath() + "/shield2")), ShieldBakedModel.getTexture((ResourceLocation)new ResourceLocation("rftoolsbuilder", "block/" + texture.getPath() + "/shield3"))};
                shields.put(texture, sprites);
            }
            shieldtransparent = ShieldBakedModel.getTexture((ResourceLocation)TEXTURE_TRANSPARENT);
            shieldfull = ShieldBakedModel.getTexture((ResourceLocation)TEXTURE_FULL);
        }
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
        ShieldBakedModel.initTextures();
        ShieldRenderingMode mode = (ShieldRenderingMode)((Object)state.m_61143_(ShieldingBlock.RENDER_MODE));
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case ShieldRenderingMode.INVISIBLE -> Collections.emptyList();
            case ShieldRenderingMode.SHIELD -> this.getQuadsShield(side, extraData);
            case ShieldRenderingMode.MIMIC -> this.getQuadsMimic(state, side, rand, extraData, renderType);
            case ShieldRenderingMode.TRANSP -> this.getQuadsTextured(side, shieldtransparent, extraData);
            case ShieldRenderingMode.SOLID -> this.getQuadsTextured(side, shieldfull, extraData);
        };
    }

    private List<BakedQuad> getQuadsShield(@Nullable Direction side, ModelData extraData) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (side != null) {
            Integer iconTopdown = (Integer)extraData.get(ShieldingTileEntity.ICON_TOPDOWN);
            Integer iconSide = (Integer)extraData.get(ShieldingTileEntity.ICON_SIDE);
            ShieldRenderData renderData = (ShieldRenderData)extraData.get(ShieldingTileEntity.RENDER_DATA);
            if (renderData == null) {
                return quads;
            }
            float r = renderData.red();
            float g = renderData.green();
            float b = renderData.blue();
            float a = renderData.alpha();
            TextureAtlasSprite[] shield = shields.get((Object)renderData.shieldTexture());
            switch (side) {
                case DOWN: {
                    quads.add(this.createQuad(ShieldBakedModel.v((double)0.0, (double)0.0, (double)0.0), ShieldBakedModel.v((double)1.0, (double)0.0, (double)0.0), ShieldBakedModel.v((double)1.0, (double)0.0, (double)1.0), ShieldBakedModel.v((double)0.0, (double)0.0, (double)1.0), shield[iconTopdown], r, g, b, a));
                    break;
                }
                case UP: {
                    quads.add(this.createQuad(ShieldBakedModel.v((double)0.0, (double)1.0, (double)0.0), ShieldBakedModel.v((double)0.0, (double)1.0, (double)1.0), ShieldBakedModel.v((double)1.0, (double)1.0, (double)1.0), ShieldBakedModel.v((double)1.0, (double)1.0, (double)0.0), shield[iconTopdown], r, g, b, a));
                    break;
                }
                case NORTH: {
                    quads.add(this.createQuad(ShieldBakedModel.v((double)1.0, (double)1.0, (double)0.0), ShieldBakedModel.v((double)1.0, (double)0.0, (double)0.0), ShieldBakedModel.v((double)0.0, (double)0.0, (double)0.0), ShieldBakedModel.v((double)0.0, (double)1.0, (double)0.0), shield[iconSide], r, g, b, a));
                    break;
                }
                case SOUTH: {
                    quads.add(this.createQuad(ShieldBakedModel.v((double)0.0, (double)1.0, (double)1.0), ShieldBakedModel.v((double)0.0, (double)0.0, (double)1.0), ShieldBakedModel.v((double)1.0, (double)0.0, (double)1.0), ShieldBakedModel.v((double)1.0, (double)1.0, (double)1.0), shield[iconSide], r, g, b, a));
                    break;
                }
                case WEST: {
                    quads.add(this.createQuad(ShieldBakedModel.v((double)0.0, (double)1.0, (double)0.0), ShieldBakedModel.v((double)0.0, (double)0.0, (double)0.0), ShieldBakedModel.v((double)0.0, (double)0.0, (double)1.0), ShieldBakedModel.v((double)0.0, (double)1.0, (double)1.0), shield[iconSide], r, g, b, a));
                    break;
                }
                case EAST: {
                    quads.add(this.createQuad(ShieldBakedModel.v((double)1.0, (double)1.0, (double)1.0), ShieldBakedModel.v((double)1.0, (double)0.0, (double)1.0), ShieldBakedModel.v((double)1.0, (double)0.0, (double)0.0), ShieldBakedModel.v((double)1.0, (double)1.0, (double)0.0), shield[iconSide], r, g, b, a));
                }
            }
        }
        return quads;
    }

    private List<BakedQuad> getQuadsTextured(@Nullable Direction side, TextureAtlasSprite texture, ModelData extraData) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (side != null) {
            ShieldRenderData renderData = (ShieldRenderData)extraData.get(ShieldingTileEntity.RENDER_DATA);
            if (renderData == null) {
                return quads;
            }
            float r = renderData.red();
            float g = renderData.green();
            float b = renderData.blue();
            float a = renderData.alpha();
            switch (side) {
                case DOWN: {
                    quads.add(this.createQuad(ShieldBakedModel.v((double)0.0, (double)0.0, (double)0.0), ShieldBakedModel.v((double)1.0, (double)0.0, (double)0.0), ShieldBakedModel.v((double)1.0, (double)0.0, (double)1.0), ShieldBakedModel.v((double)0.0, (double)0.0, (double)1.0), texture, r, g, b, a));
                    break;
                }
                case UP: {
                    quads.add(this.createQuad(ShieldBakedModel.v((double)0.0, (double)1.0, (double)0.0), ShieldBakedModel.v((double)0.0, (double)1.0, (double)1.0), ShieldBakedModel.v((double)1.0, (double)1.0, (double)1.0), ShieldBakedModel.v((double)1.0, (double)1.0, (double)0.0), texture, r, g, b, a));
                    break;
                }
                case NORTH: {
                    quads.add(this.createQuad(ShieldBakedModel.v((double)1.0, (double)1.0, (double)0.0), ShieldBakedModel.v((double)1.0, (double)0.0, (double)0.0), ShieldBakedModel.v((double)0.0, (double)0.0, (double)0.0), ShieldBakedModel.v((double)0.0, (double)1.0, (double)0.0), texture, r, g, b, a));
                    break;
                }
                case SOUTH: {
                    quads.add(this.createQuad(ShieldBakedModel.v((double)0.0, (double)1.0, (double)1.0), ShieldBakedModel.v((double)0.0, (double)0.0, (double)1.0), ShieldBakedModel.v((double)1.0, (double)0.0, (double)1.0), ShieldBakedModel.v((double)1.0, (double)1.0, (double)1.0), texture, r, g, b, a));
                    break;
                }
                case WEST: {
                    quads.add(this.createQuad(ShieldBakedModel.v((double)0.0, (double)1.0, (double)0.0), ShieldBakedModel.v((double)0.0, (double)0.0, (double)0.0), ShieldBakedModel.v((double)0.0, (double)0.0, (double)1.0), ShieldBakedModel.v((double)0.0, (double)1.0, (double)1.0), texture, r, g, b, a));
                    break;
                }
                case EAST: {
                    quads.add(this.createQuad(ShieldBakedModel.v((double)1.0, (double)1.0, (double)1.0), ShieldBakedModel.v((double)1.0, (double)0.0, (double)1.0), ShieldBakedModel.v((double)1.0, (double)0.0, (double)0.0), ShieldBakedModel.v((double)1.0, (double)1.0, (double)0.0), texture, r, g, b, a));
                }
            }
        }
        return quads;
    }

    private List<BakedQuad> getQuadsMimic(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, ModelData extraData, @Nullable RenderType renderType) {
        BlockState camo = (BlockState)extraData.get(ShieldingTileEntity.MIMIC);
        if (camo == null) {
            return Collections.emptyList();
        }
        BakedModel model = this.getModel(camo);
        try {
            return model.getQuads(state, side, rand, ModelData.EMPTY, renderType);
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    private BakedModel getModel(@Nonnull BlockState facadeState) {
        ShieldBakedModel.initTextures();
        return Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(facadeState);
    }

    @Nonnull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        if (state.m_60734_() == ShieldModule.SHIELDING_SOLID.get()) {
            return RT_SOLID;
        }
        if (state.m_60734_() == ShieldModule.SHIELDING_TRANSLUCENT.get()) {
            return RT_TRANSLUCENT;
        }
        return RT_CUTOUT;
    }

    @Nonnull
    public TextureAtlasSprite m_6160_() {
        ShieldBakedModel.initTextures();
        return shieldfull;
    }

    static {
        RT_TRANSLUCENT = ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110466_()});
        RT_CUTOUT = ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110463_()});
        RT_SOLID = ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110451_()});
    }
}

