/*
 * Decompiled with CFR 0.152.
 */
package artifacts.network;

import artifacts.network.NetworkHandler;
import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class PlaySoundAtPlayerPacket {
    private final SoundEvent soundEvent;
    private final float volume;
    private final float pitch;
    private final long seed;

    public PlaySoundAtPlayerPacket(FriendlyByteBuf buffer) {
        this.soundEvent = (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(buffer.m_130281_());
        this.volume = buffer.readFloat();
        this.pitch = buffer.readFloat();
        this.seed = buffer.readLong();
    }

    public PlaySoundAtPlayerPacket(SoundEvent soundEvent, float volume, float pitch, long seed) {
        this.soundEvent = soundEvent;
        this.volume = volume;
        this.pitch = pitch;
        this.seed = seed;
    }

    public static void sendSound(ServerPlayer player, SoundEvent soundEvent, float volume, float pitch) {
        long seed = player.m_9236_().f_46441_.m_188505_();
        NetworkHandler.CHANNEL.sendToPlayer(player, (Object)new PlaySoundAtPlayerPacket(soundEvent, volume, pitch, seed));
        player.m_9236_().m_213890_((Player)player, (Entity)player, BuiltInRegistries.f_256894_.m_263177_((Object)soundEvent), SoundSource.PLAYERS, volume, pitch, seed);
    }

    void encode(FriendlyByteBuf buffer) {
        buffer.m_130085_(BuiltInRegistries.f_256894_.m_7981_((Object)this.soundEvent));
        buffer.writeFloat(this.volume);
        buffer.writeFloat(this.pitch);
        buffer.writeLong(this.seed);
    }

    void apply(Supplier<NetworkManager.PacketContext> context) {
        Player player = context.get().getPlayer();
        player.m_9236_().m_213890_(player, (Entity)player, BuiltInRegistries.f_256894_.m_263177_((Object)this.soundEvent), SoundSource.PLAYERS, this.volume, this.pitch, this.seed);
    }
}

