/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.syncdata.managed;

import com.lowdragmc.lowdraglib.syncdata.managed.ManagedField;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.nbt.CompoundTag;

public class ReadOnlyManagedField
extends ManagedField {
    protected final Method onDirtyMethod;
    protected final Method serializeMethod;
    protected final Method deserializeMethod;

    protected ReadOnlyManagedField(Field field, Object instance, Method onDirtyMethod, Method serializeMethod, Method deserializeMethod) {
        super(field, instance);
        this.onDirtyMethod = onDirtyMethod;
        this.serializeMethod = serializeMethod;
        this.deserializeMethod = deserializeMethod;
    }

    public static ReadOnlyManagedField of(Field field, Object instance, Method onDirtyMethod, Method serializeMethod, Method deserializeMethod) {
        return new ReadOnlyManagedField(field, instance, onDirtyMethod, serializeMethod, deserializeMethod);
    }

    public boolean isDirty(Object obj) {
        try {
            return (Boolean)this.onDirtyMethod.invoke(this.instance, obj);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public CompoundTag serializeUid(Object obj) {
        try {
            return (CompoundTag)this.serializeMethod.invoke(this.instance, obj);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public Object deserializeUid(CompoundTag uid) {
        try {
            return this.deserializeMethod.invoke(this.instance, uid);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

