/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.syncdata.managed;

import com.lowdragmc.lowdraglib.syncdata.SyncUtils;
import com.lowdragmc.lowdraglib.syncdata.managed.IArrayRef;
import com.lowdragmc.lowdraglib.syncdata.managed.IManagedVar;
import com.lowdragmc.lowdraglib.syncdata.managed.ManagedRef;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.lang.reflect.Array;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ManagedArrayLikeRef
extends ManagedRef
implements IArrayRef {
    private final IntSet dirty = new IntOpenHashSet();
    protected Object oldValue;
    protected int oldLength;
    protected final boolean isArray;

    public ManagedArrayLikeRef(IManagedVar<?> field, boolean lazy) {
        super(field);
        this.lazy = lazy;
        this.isArray = field.getType().isArray();
        if (!this.isArray && !Collection.class.isAssignableFrom(field.getType())) {
            throw new IllegalArgumentException("Field %s is not an array or collection".formatted(field));
        }
        Object value = this.getField().value();
        if (value != null) {
            Object array;
            this.oldValue = array = SyncUtils.copyArrayLike(value, this.isArray);
            this.oldLength = Array.getLength(array);
        }
    }

    @Override
    public void update() {
        Object newValue = this.getField().value();
        if (this.oldValue == null && newValue != null || this.oldValue != null && newValue == null || this.oldValue != null && this.checkArrayLikeChanges(this.oldValue, newValue)) {
            if (newValue != null) {
                Object array;
                this.oldValue = array = SyncUtils.copyArrayLike(newValue, this.isArray);
                this.oldLength = Array.getLength(array);
            } else {
                this.oldValue = null;
                this.oldLength = 0;
            }
            this.markAsDirty();
        }
    }

    protected boolean checkArrayLikeChanges(@NotNull Object oldValue, @NotNull Object newValue) {
        if (this.isArray) {
            if (Array.getLength(newValue) != this.oldLength) {
                this.markAsDirty();
                this.dirty.clear();
                return true;
            }
            boolean dirty = false;
            for (int i = 0; i < Array.getLength(oldValue); ++i) {
                if (!SyncUtils.isChanged(Array.get(oldValue, i), Array.get(newValue, i))) continue;
                this.setChanged(i);
                dirty = true;
            }
            return dirty;
        }
        if (newValue instanceof Collection) {
            Collection collection = (Collection)newValue;
            if (collection.size() != this.oldLength) {
                this.markAsDirty();
                this.dirty.clear();
                return true;
            }
            int i = 0;
            boolean dirty = false;
            for (Object item : collection) {
                Object oldItem = Array.get(oldValue, i);
                if (oldItem == null && item != null || oldItem != null && item == null || oldItem != null && SyncUtils.isChanged(oldItem, item)) {
                    this.setChanged(i);
                    dirty = true;
                }
                ++i;
            }
            return dirty;
        }
        throw new IllegalArgumentException("Value %s is not an array or collection".formatted(newValue));
    }

    @Override
    public void markAsDirty() {
        super.markAsDirty();
    }

    @Override
    public void setChanged(int index) {
        this.markAsDirty();
        this.dirty.add(index);
    }

    @Override
    public IntSet getChanged() {
        return this.dirty;
    }
}

