/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget.codeeditor.language;

import com.lowdragmc.lowdraglib.gui.widget.codeeditor.language.ILanguageDefinition;
import com.lowdragmc.lowdraglib.gui.widget.codeeditor.language.Languages;
import com.lowdragmc.lowdraglib.gui.widget.codeeditor.language.Token;
import com.lowdragmc.lowdraglib.gui.widget.codeeditor.language.TokenType;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SyntaxParser {
    private ILanguageDefinition languageDefinition = Languages.JAVASCRIPT;

    public List<Token> parseLine(String lineText) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        Pattern pattern = this.languageDefinition.getTokenPattern();
        Matcher matcher = pattern.matcher(lineText);
        while (matcher.find()) {
            String text = matcher.group();
            TokenType type = this.languageDefinition.getTokenType(matcher);
            tokens.add(new Token(text, type, matcher.start(), matcher.end()));
        }
        return tokens;
    }

    public ILanguageDefinition getLanguageDefinition() {
        return this.languageDefinition;
    }

    public void setLanguageDefinition(ILanguageDefinition languageDefinition) {
        this.languageDefinition = languageDefinition;
    }
}

