/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.graphprocessor.nodes.logic;

import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.CustomPortBehavior;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.CustomPortInput;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.CustomPortOutput;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.InputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.OutputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.NodePort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.PortData;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.PortEdge;
import java.util.ArrayList;
import java.util.List;

@LDLRegister(name="switch", group="graph_processor.node.logic")
public class SwitchNode
extends BaseNode {
    @InputPort
    public int index = 0;
    @InputPort
    public List inputs = new ArrayList();
    @OutputPort
    public Object out;
    protected Class<?> listType = Object.class;

    @Override
    public void process() {
        this.out = null;
        if (this.inputs != null && this.index < this.inputs.size() && this.index >= 0) {
            this.out = this.inputs.get(this.index);
        }
    }

    @CustomPortBehavior(field="inputs")
    public List<PortData> listPortBehavior(List<PortEdge> edges) {
        ArrayList<PortData> ports = new ArrayList<PortData>();
        if (!edges.isEmpty()) {
            for (PortEdge edge : edges) {
                if (edge.outputPort.portData.displayType == null) continue;
                this.listType = edge.outputPort.portData.displayType;
                break;
            }
        } else {
            this.listType = Object.class;
        }
        for (int i = 0; i < edges.size() + 1; ++i) {
            String identifier = String.valueOf(i);
            if (i < edges.size()) {
                PortEdge edge = edges.get(i);
                edge.inputPortIdentifier = identifier;
                PortData existingPort = edges.get((int)i).inputPort.portData;
                if (identifier.equals(existingPort.identifier)) {
                    existingPort.displayType = this.listType;
                    ports.add(existingPort);
                    continue;
                }
            }
            ports.add(new PortData().displayName("in " + i).identifier(String.valueOf(i)).displayType(this.listType));
        }
        if (this.inputs == null) {
            this.inputs = new ArrayList();
        }
        this.inputs.clear();
        while (this.inputs.size() + 1 < ports.size()) {
            this.inputs.add(null);
        }
        return ports;
    }

    @CustomPortBehavior(field="out")
    public List<PortData> modifyOutPort(List<PortEdge> edges) {
        return List.of(new PortData().displayName("out").identifier("out").acceptMultipleEdges(true).displayType(this.listType));
    }

    @CustomPortInput(field="inputs")
    public void pullInputs(List<PortEdge> inputEdges, NodePort inputPort) {
        if (inputEdges.isEmpty()) {
            return;
        }
        Object value = null;
        for (PortEdge inputEdge : inputEdges) {
            value = inputEdge.passThroughBuffer;
        }
        int index = inputPort.owner.getInputPorts().indexOf(inputPort) - 1;
        while (this.inputs.size() <= index) {
            this.inputs.add(value);
        }
        this.inputs.set(index, value);
    }

    @CustomPortOutput(field="out")
    public void pushOut(List<PortEdge> outputEdges, NodePort outputPort) {
        for (PortEdge edge : outputEdges) {
            edge.passThroughBuffer = this.out;
        }
    }
}

