/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.graphprocessor.data;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.NodePort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.PortEdge;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;

public abstract class NodePortContainer
extends ArrayList<NodePort> {
    protected BaseNode node;

    public NodePortContainer(BaseNode node) {
        this.node = node;
    }

    public void remove(PortEdge edge) {
        this.forEach((? super E p) -> p.remove(edge));
    }

    public void add(PortEdge edge) {
        String portFieldName = edge.inputNode == this.node ? edge.inputFieldName : edge.outputFieldName;
        String portIdentifier = edge.inputNode == this.node ? edge.inputPortIdentifier : edge.outputPortIdentifier;
        String identifier = portIdentifier == null || portIdentifier.isEmpty() ? null : portIdentifier;
        Optional<NodePort> port = this.stream().filter(p -> Objects.equals(p.fieldName, portFieldName) && Objects.equals(p.portData.identifier, identifier)).findFirst();
        if (port.isEmpty()) {
            LDLib.LOGGER.error("The edge can't be properly connected because it's ports can't be found");
            return;
        }
        port.get().add(edge);
    }

    public static class NodeOutputPortContainer
    extends NodePortContainer {
        public NodeOutputPortContainer(BaseNode node) {
            super(node);
        }

        public void PushDatas() {
            this.forEach(NodePort::PushData);
        }
    }

    public static class NodeInputPortContainer
    extends NodePortContainer {
        public NodeInputPortContainer(BaseNode node) {
            super(node);
        }

        public void PullDatas() {
            this.forEach(NodePort::PullData);
        }
    }
}

