/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.data;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigSetter;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.sceneobject.ISceneObject;
import com.lowdragmc.lowdraglib.syncdata.IPersistedSerializable;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class Transform
implements IPersistedSerializable,
IConfigurable {
    @Persisted
    private UUID id = UUID.randomUUID();
    @Configurable(name="transform.position", tips={"transform.position.tips"})
    @NumberRange(range={-3.4028234663852886E38, 3.4028234663852886E38})
    private Vector3f localPosition = new Vector3f();
    @Configurable(name="transform.rotation", tips={"transform.rotation.tips"}, forceUpdate=false)
    @NumberRange(range={-3.4028234663852886E38, 3.4028234663852886E38}, wheel=1.0)
    private Quaternionf localRotation = new Quaternionf();
    @Configurable(name="transform.scale", tips={"transform.scale.tips"})
    @NumberRange(range={-3.4028234663852886E38, 3.4028234663852886E38})
    private Vector3f localScale = new Vector3f(1.0f, 1.0f, 1.0f);
    @Nullable
    private Transform parent;
    @Persisted
    private UUID _parentId;
    private List<Transform> children = new ArrayList<Transform>();
    @Nonnull
    private final ISceneObject sceneObject;
    @Nullable
    private Vector3f position = null;
    @Nullable
    private Quaternionf rotation = null;
    @Nullable
    private Vector3f scale = null;
    @Nullable
    private Matrix4f localTransformMatrix = null;
    @Nullable
    private Matrix4f worldToLocalMatrix = null;
    private Matrix4f localToWorldMatrix = null;

    public Transform(@Nonnull ISceneObject sceneObject) {
        this.sceneObject = sceneObject;
    }

    private void onTransformChanged() {
        this.position = null;
        this.rotation = null;
        this.scale = null;
        this.localTransformMatrix = null;
        this.worldToLocalMatrix = null;
        this.localToWorldMatrix = null;
        for (Transform child : this.children) {
            child.onTransformChanged();
        }
        this.sceneObject.onTransformChanged();
    }

    public void parent(@Nullable Transform parent) {
        this.parent(parent, true);
    }

    public void parent(@Nullable Transform parent, boolean keepWorldTransform) {
        Vector3f lastScale;
        if (this.parent == parent) {
            return;
        }
        if (parent != null && parent.isInheritedParent(this)) {
            throw new IllegalArgumentException("Cannot set parent to a child transform.");
        }
        Vector3f lastPosition = keepWorldTransform ? this.position() : null;
        Quaternionf lastRotation = keepWorldTransform ? this.rotation() : null;
        Vector3f vector3f = lastScale = keepWorldTransform ? this.scale() : null;
        if (this.parent != null) {
            this.parent.children.remove(this);
            this.parent.sceneObject.onChildChanged();
        }
        this.parent = parent;
        UUID uUID = this._parentId = parent == null ? null : parent.id();
        if (parent != null) {
            parent.children.add(this);
            this.sceneObject.setScene(parent.sceneObject.getScene());
            parent.sceneObject.onChildChanged();
        }
        if (keepWorldTransform) {
            this.onTransformChanged();
            this.position(lastPosition);
            this.rotation(lastRotation);
            this.scale(lastScale);
        } else {
            this.onTransformChanged();
        }
        this.sceneObject.onParentChanged();
    }

    public boolean isInheritedParent(Transform parent) {
        if (this.parent == null) {
            return false;
        }
        if (this.parent == parent) {
            return true;
        }
        return this.parent.isInheritedParent(parent);
    }

    public Matrix4f localTransformMatrix() {
        if (this.localTransformMatrix == null) {
            this.localTransformMatrix = new Matrix4f().translate((Vector3fc)this.localPosition).rotate((Quaternionfc)this.localRotation).scale((Vector3fc)this.localScale);
        }
        return this.localTransformMatrix;
    }

    public Matrix4f localToWorldMatrix() {
        if (this.localToWorldMatrix == null) {
            this.localToWorldMatrix = this.parent == null ? this.localTransformMatrix() : new Matrix4f((Matrix4fc)this.parent.localToWorldMatrix()).mul((Matrix4fc)this.localTransformMatrix());
        }
        return this.localToWorldMatrix;
    }

    public Matrix4f worldToLocalMatrix() {
        if (this.worldToLocalMatrix == null) {
            this.worldToLocalMatrix = this.localToWorldMatrix().invert(new Matrix4f());
        }
        return this.worldToLocalMatrix;
    }

    public Transform set(Transform transform) {
        return this.set(transform, false);
    }

    public Transform set(Transform transform, boolean local) {
        if (local) {
            this.localPosition(transform.localPosition());
            this.localRotation(transform.localRotation());
            this.localScale(transform.localScale());
        } else {
            this.position(transform.position());
            this.rotation(transform.rotation());
            this.scale(transform.scale());
        }
        return this;
    }

    public Vector3f position() {
        if (this.position == null) {
            this.position = this.parent == null ? this.localPosition : this.parent.localToWorldMatrix().transformPosition(new Vector3f((Vector3fc)this.localPosition));
        }
        return new Vector3f((Vector3fc)this.position);
    }

    public void position(Vector3f position) {
        this.onTransformChanged();
        this.position = new Vector3f((Vector3fc)position);
        this.localPosition = this.parent == null ? new Vector3f((Vector3fc)position) : this.parent.worldToLocalMatrix().transformPosition(new Vector3f((Vector3fc)position));
    }

    @ConfigSetter(field="localPosition")
    public void localPosition(Vector3f localPosition) {
        this.localPosition = localPosition;
        this.onTransformChanged();
    }

    public Quaternionf rotation() {
        if (this.rotation == null) {
            this.rotation = this.parent == null ? this.localRotation : this.parent.rotation().mul((Quaternionfc)this.localRotation);
        }
        return new Quaternionf((Quaternionfc)this.rotation);
    }

    public void rotation(Quaternionf rotation) {
        this.onTransformChanged();
        this.rotation = new Quaternionf((Quaternionfc)rotation);
        this.localRotation = this.parent == null ? new Quaternionf((Quaternionfc)rotation) : this.parent.rotation().invert().mul((Quaternionfc)rotation);
    }

    @ConfigSetter(field="localRotation")
    public void localRotation(Quaternionf localRotation) {
        this.localRotation = localRotation;
        this.onTransformChanged();
    }

    public Vector3f scale() {
        if (this.scale == null) {
            this.scale = this.parent == null ? this.localScale : new Vector3f((Vector3fc)this.localScale).mul((Vector3fc)this.parent.scale());
        }
        return new Vector3f((Vector3fc)this.scale);
    }

    public void scale(Vector3f scale) {
        this.onTransformChanged();
        this.scale = new Vector3f((Vector3fc)scale);
        this.localScale = this.parent == null ? new Vector3f((Vector3fc)scale) : new Vector3f((Vector3fc)scale).div((Vector3fc)this.parent.scale());
    }

    @ConfigSetter(field="localScale")
    public void localScale(Vector3f localScale) {
        this.localScale = localScale;
        this.onTransformChanged();
    }

    public void awake() {
        if (this._parentId != null && this.sceneObject.getScene() != null) {
            ISceneObject parent = this.sceneObject.getScene().getSceneObject(this._parentId);
            if (parent != null) {
                this.parent(parent.transform(), false);
            } else {
                LDLib.LOGGER.warn("Parent transform {} not found.", (Object)this._parentId);
            }
        }
    }

    public void _setInternalID(UUID uuid) {
        this.id = uuid;
    }

    public void _refreshInternalID() {
        this.id = UUID.randomUUID();
    }

    public void _setInternalParentID(UUID uuid) {
        this._parentId = uuid;
    }

    public UUID _getInternalParentID() {
        return this._parentId;
    }

    public void copyTransformFrom(Transform transform, boolean local, boolean copyHierarchy) {
        this.set(transform, local);
        if (copyHierarchy) {
            this.parent(transform.parent());
            this._setInternalParentID(transform._getInternalParentID());
        }
    }

    public UUID id() {
        return this.id;
    }

    public Vector3f localPosition() {
        return this.localPosition;
    }

    public Quaternionf localRotation() {
        return this.localRotation;
    }

    public Vector3f localScale() {
        return this.localScale;
    }

    @Nullable
    public Transform parent() {
        return this.parent;
    }

    public List<Transform> children() {
        return this.children;
    }

    @Nonnull
    public ISceneObject sceneObject() {
        return this.sceneObject;
    }
}

