/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.data;

import com.lowdragmc.lowdraglib.gui.editor.ILDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.data.Resources;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.util.TreeBuilder;
import com.lowdragmc.lowdraglib.syncdata.ITagSerializable;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;

public interface IProject
extends ILDLRegister,
ITagSerializable<CompoundTag> {
    public Resources getResources();

    default public void saveProject(File file) {
        try {
            NbtIo.m_128955_((CompoundTag)((CompoundTag)this.serializeNBT()), (File)file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Nullable
    default public IProject loadProject(File file) {
        try {
            CompoundTag tag = NbtIo.m_128953_((File)file);
            if (tag != null) {
                this.deserializeNBT(tag);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    public IProject newEmptyProject();

    default public File getProjectWorkSpace(Editor editor) {
        return new File(editor.getWorkSpace(), "projects/" + this.name());
    }

    default public String getSuffix() {
        return this.name();
    }

    default public void onClosed(Editor editor) {
    }

    default public void onLoad(Editor editor) {
        editor.getResourcePanel().loadResource(this.getResources(), false);
    }

    default public void attachMenu(Editor editor, String name, TreeBuilder.Menu menu) {
    }

    default public Resources loadResources(CompoundTag tag) {
        return Resources.fromNBT(tag);
    }
}

