/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.configurator;

import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.client.renderer.block.RendererBlock;
import com.lowdragmc.lowdraglib.client.renderer.block.RendererBlockEntity;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ValueConfigurator;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.SceneWidget;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.lowdraglib.utils.TrackedDummyWorld;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;

public class IRendererConfigurator
extends ValueConfigurator<IRenderer> {
    private ImageWidget frame;
    private RendererBlockEntity holder;

    public IRendererConfigurator(String name, Supplier<IRenderer> supplier, Consumer<IRenderer> onUpdate, IRenderer defaultRenderer, boolean forceUpdate) {
        super(name, supplier, onUpdate, defaultRenderer, forceUpdate);
        if (this.value == null) {
            this.value = this.defaultValue;
        }
    }

    @Override
    protected void onValueUpdate(IRenderer newValue) {
        if (Objects.equals(newValue, this.value)) {
            return;
        }
        super.onValueUpdate(newValue);
        this.holder.setRenderer(newValue);
    }

    @Override
    public void computeHeight() {
        super.computeHeight();
        this.setSize(new Size(this.getSize().width, 15 + this.frame.getSize().height + 6));
    }

    @Override
    public void init(int width) {
        super.init(width);
        int w = Math.min(width - 6, 100);
        int x = (width - w) / 2;
        this.frame = new ImageWidget(x, 17, w, w, IGuiTexture.EMPTY).setBorder(2, ColorPattern.T_WHITE.color);
        this.addWidget(this.frame);
        TrackedDummyWorld level = new TrackedDummyWorld();
        level.addBlock(BlockPos.f_121853_, BlockInfo.fromBlock(RendererBlock.BLOCK));
        this.holder = (RendererBlockEntity)level.m_7702_(BlockPos.f_121853_);
        assert (this.holder != null);
        this.holder.setRenderer((IRenderer)this.value);
        SceneWidget sceneWidget = new SceneWidget(x, 17, w, w, level);
        sceneWidget.setRenderFacing(false);
        sceneWidget.setRenderSelect(false);
        sceneWidget.createScene(level);
        sceneWidget.getRenderer().setOnLookingAt(null);
        sceneWidget.setRenderedCore(Collections.singleton(BlockPos.f_121853_), null);
        this.addWidget(sceneWidget);
        sceneWidget.setDraggingConsumer(o -> o instanceof IRenderer, o -> this.frame.setBorder(2, ColorPattern.GREEN.color), o -> this.frame.setBorder(2, ColorPattern.T_WHITE.color), o -> {
            if (o instanceof IRenderer) {
                IRenderer renderer = (IRenderer)o;
                this.onValueUpdate(renderer);
                this.updateValue();
            }
            this.frame.setBorder(2, ColorPattern.T_WHITE.color);
        });
    }
}

