/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.accessors;

import com.lowdragmc.lowdraglib.gui.editor.accessors.CompoundTagAccessor;
import com.lowdragmc.lowdraglib.gui.editor.accessors.TypesAccessor;
import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigAccessor;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.DefaultValue;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ItemConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.NumberConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.WrapperConfigurator;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import java.lang.reflect.Field;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

@ConfigAccessor
public class ItemStackAccessor
extends TypesAccessor<ItemStack> {
    public ItemStackAccessor() {
        super(ItemStack.class);
    }

    @Override
    public ItemStack defaultValue(Field field, Class<?> type) {
        if (field.isAnnotationPresent(DefaultValue.class)) {
            DefaultValue annotation = field.getAnnotation(DefaultValue.class);
            return new ItemStack((ItemLike)((Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(annotation.stringValue()[0]))).m_5456_(), (int)annotation.numberValue()[0]);
        }
        return ItemStack.f_41583_;
    }

    @Override
    public Configurator create(String name, Supplier<ItemStack> supplier, Consumer<ItemStack> consumer, boolean forceUpdate, Field field) {
        ConfiguratorGroup group = new ConfiguratorGroup(name);
        if (field.isAnnotationPresent(Configurable.class)) {
            Configurable configurable = field.getAnnotation(Configurable.class);
            group.setCollapse(configurable.collapse());
            group.setCanCollapse(configurable.canCollapse());
            group.setTips(configurable.tips());
        }
        ItemStackTransfer itemHandler = new ItemStackTransfer(supplier.get());
        SlotWidget slot = new SlotWidget(itemHandler, 0, 0, 0, false, false);
        slot.setClientSideWidget();
        Consumer<ItemStack> updateStack = stack -> {
            consumer.accept((ItemStack)stack);
            itemHandler.setStackInSlot(0, (ItemStack)stack);
        };
        group.addConfigurators(new ItemConfigurator("id", () -> ((ItemStack)supplier.get()).m_41720_(), item -> {
            ItemStack last = (ItemStack)supplier.get();
            CompoundTag tag = last.m_41783_();
            int count = last.m_41613_();
            ItemStack newStack = new ItemStack((ItemLike)item, Math.max(count, 1));
            newStack.m_41751_(tag);
            updateStack.accept(newStack);
        }, Items.f_41852_, forceUpdate));
        int min = 1;
        int max = 64;
        if (field.isAnnotationPresent(NumberRange.class)) {
            min = (int)field.getAnnotation(NumberRange.class).range()[0];
            max = (int)field.getAnnotation(NumberRange.class).range()[1];
        }
        group.addConfigurators(new NumberConfigurator("ldlib.gui.editor.configurator.count", () -> ((ItemStack)supplier.get()).m_41613_(), count -> updateStack.accept(((ItemStack)supplier.get()).m_255036_(count.intValue())), 1, forceUpdate).setRange(min, max));
        group.addConfigurators(new CompoundTagAccessor().create("ldlib.gui.editor.configurator.nbt", () -> ((ItemStack)supplier.get()).m_41782_() ? ((ItemStack)supplier.get()).m_41783_() : new CompoundTag(), (CompoundTag tag) -> {
            ItemStack last = (ItemStack)supplier.get();
            Item item = last.m_41720_();
            int count = last.m_41613_();
            ItemStack newStack = new ItemStack((ItemLike)item, Math.max(count, 1));
            if (tag.m_128456_()) {
                newStack.m_41751_(null);
            } else {
                newStack.m_41751_(tag);
            }
            updateStack.accept(newStack);
        }, false, field));
        group.addConfigurators(new WrapperConfigurator("ldlib.gui.editor.group.preview", slot));
        return group;
    }
}

