/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.model.forge;

import com.lowdragmc.lowdraglib.client.model.custommodel.Connections;
import com.lowdragmc.lowdraglib.client.model.custommodel.CustomBakedModel;
import com.lowdragmc.lowdraglib.client.model.forge.LDLRendererModel;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CustomBakedModelImpl
extends CustomBakedModel {
    public CustomBakedModelImpl(BakedModel parent) {
        super(parent);
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData modelData, @Nullable RenderType renderType) {
        BlockAndTintGetter level = (BlockAndTintGetter)modelData.get(LDLRendererModel.RendererBakedModel.WORLD);
        BlockPos pos = (BlockPos)modelData.get(LDLRendererModel.RendererBakedModel.POS);
        ModelData parentModelData = (ModelData)modelData.get(LDLRendererModel.RendererBakedModel.MODEL_DATA);
        if (parentModelData == null) {
            parentModelData = ModelData.EMPTY;
        }
        if (level != null && pos != null && state != null) {
            return this.getCustomQuads(level, pos, state, side, rand, parentModelData, renderType);
        }
        return this.parent.getQuads(state, side, rand, parentModelData, renderType);
    }

    @NotNull
    public List<BakedQuad> getCustomQuads(BlockAndTintGetter level, BlockPos pos, @NotNull BlockState state, @Nullable Direction side, RandomSource rand, ModelData parentModelData, @Nullable RenderType renderType) {
        Connections connections = Connections.checkConnections(level, pos, state, side);
        if (renderType != null || !parentModelData.getProperties().isEmpty()) {
            return CustomBakedModelImpl.buildCustomQuads(connections, this.parent.getQuads(state, side, rand, parentModelData, renderType), 0.0f);
        }
        return super.getCustomQuads(level, pos, state, side, rand);
    }

    @NotNull
    public ModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData modelData) {
        return modelData.derive().with(LDLRendererModel.RendererBakedModel.WORLD, (Object)level).with(LDLRendererModel.RendererBakedModel.POS, (Object)pos).with(LDLRendererModel.RendererBakedModel.MODEL_DATA, (Object)this.parent.getModelData(level, pos, state, modelData)).build();
    }
}

