/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client;

import com.lowdragmc.lowdraglib.client.forge.ClientCommandsImpl;
import com.lowdragmc.lowdraglib.client.shader.Shaders;
import com.lowdragmc.lowdraglib.client.shader.management.ShaderManager;
import com.lowdragmc.lowdraglib.gui.compass.CompassManager;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegisterClient;
import com.lowdragmc.lowdraglib.gui.editor.runtime.AnnotationDetector;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.modular.ModularUIGuiContainer;
import com.lowdragmc.lowdraglib.test.ui.IUITest;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.Commands;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientCommands {
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static LiteralArgumentBuilder createLiteral(String command) {
        return ClientCommandsImpl.createLiteral(command);
    }

    public static <S> List<LiteralArgumentBuilder<S>> createClientCommands() {
        return List.of((LiteralArgumentBuilder)ClientCommands.createLiteral("ldlib_client").then(ClientCommands.createLiteral("reload_shader").executes(context -> {
            Shaders.reload();
            ShaderManager.getInstance().reload();
            return 1;
        })), (LiteralArgumentBuilder)ClientCommands.createLiteral("compass").then(ClientCommands.createLiteral("dev_mode").then(Commands.m_82129_((String)"mode", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            CompassManager.INSTANCE.devMode = BoolArgumentType.getBool((CommandContext)context, (String)"mode");
            return 1;
        }))), ClientCommands.createTestCommands());
    }

    private static LiteralArgumentBuilder createTestCommands() {
        LiteralArgumentBuilder builder = Commands.m_82127_((String)"ldlib_test");
        for (AnnotationDetector.Wrapper<LDLRegisterClient, IUITest> uiTest : AnnotationDetector.REGISTER_UI_TESTS) {
            builder = (LiteralArgumentBuilder)builder.then(ClientCommands.createLiteral(uiTest.annotation().name()).executes(context -> {
                IUIHolder holder = IUIHolder.EMPTY;
                IUITest test = (IUITest)uiTest.creator().get();
                Minecraft minecraft = Minecraft.m_91087_();
                LocalPlayer entityPlayer = minecraft.f_91074_;
                ModularUI uiTemplate = test.createUI(holder, (Player)entityPlayer);
                uiTemplate.initWidgets();
                ModularUIGuiContainer ModularUIGuiContainer2 = new ModularUIGuiContainer(uiTemplate, entityPlayer.f_36096_.f_38840_);
                minecraft.m_91152_((Screen)ModularUIGuiContainer2);
                entityPlayer.f_36096_ = ModularUIGuiContainer2.m_6262_();
                return 1;
            }));
        }
        return builder;
    }
}

