/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.scanner.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.client.GuiTools;
import mcjty.lib.container.GhostOutputSlot;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.WindowManager;
import mcjty.lib.gui.events.BlockRenderEvent;
import mcjty.lib.gui.events.DefaultSelectionEvent;
import mcjty.lib.gui.events.SelectionEvent;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.AbstractWidget;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.ImageLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.ScrollableLabel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.network.Networking;
import mcjty.lib.network.PacketRequestDataFromServer;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.ClientTools;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.SafeClientTools;
import mcjty.lib.varia.TagTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsstorage.RFToolsStorage;
import mcjty.rftoolsstorage.craftinggrid.GuiCraftingGrid;
import mcjty.rftoolsstorage.modules.scanner.StorageScannerConfiguration;
import mcjty.rftoolsstorage.modules.scanner.StorageScannerModule;
import mcjty.rftoolsstorage.modules.scanner.blocks.StorageScannerBlock;
import mcjty.rftoolsstorage.modules.scanner.blocks.StorageScannerContainer;
import mcjty.rftoolsstorage.modules.scanner.blocks.StorageScannerTileEntity;
import mcjty.rftoolsstorage.modules.scanner.network.PacketGetInventoryInfo;
import mcjty.rftoolsstorage.modules.scanner.network.PacketRequestItem;
import mcjty.rftoolsstorage.modules.scanner.network.PacketReturnInventoryInfo;
import mcjty.rftoolsstorage.modules.scanner.tools.SortingMode;
import mcjty.rftoolsstorage.setup.CommandHandler;
import mcjty.rftoolsstorage.setup.RFToolsStorageMessages;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class GuiStorageScanner
extends GenericGuiContainer<StorageScannerTileEntity, StorageScannerContainer> {
    private static final int STORAGE_MONITOR_WIDTH = 256;
    private static final int STORAGE_MONITOR_HEIGHT = 244;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftoolsstorage", "textures/gui/storagescanner.png");
    private static final ResourceLocation guielements = new ResourceLocation("rftoolsbase", "textures/gui/guielements.png");
    public static final int LIST_HEIGHT = 152;
    private WidgetList storageList;
    private WidgetList itemList;
    private ToggleButton openViewButton;
    private EnergyBar energyBar;
    private Button topButton;
    private Button upButton;
    private Button downButton;
    private Button bottomButton;
    private ChoiceLabel sortChoice;
    private Button removeButton;
    private TextField searchField;
    private ImageChoiceLabel exportToStarred;
    private Panel storagePanel;
    private Panel itemPanel;
    private ScrollableLabel radiusLabel;
    private Label visibleRadiusLabel;
    private final GuiCraftingGrid craftingGrid = new GuiCraftingGrid();
    private int listDirty = 0;
    private boolean init = false;
    public static List<PacketReturnInventoryInfo.InventoryInfo> fromServer_inventories = new ArrayList<PacketReturnInventoryInfo.InventoryInfo>();
    public static Set<BlockPos> fromServer_foundInventories = new HashSet<BlockPos>();
    public static List<ItemStack> fromServer_inventory = new ArrayList<ItemStack>();
    public static List<ItemStack> fromServer_craftable = new ArrayList<ItemStack>();
    private static long lastTime = 0L;

    public GuiStorageScanner(StorageScannerTileEntity te, StorageScannerContainer container, Inventory playerInventory) {
        super((GenericTileEntity)te, (AbstractContainerMenu)container, playerInventory, ((StorageScannerBlock)StorageScannerModule.STORAGE_SCANNER.get()).getManualEntry());
        this.f_97726_ = 256;
        this.f_97727_ = 244;
    }

    protected void registerWindows(WindowManager mgr) {
        super.registerWindows(mgr);
        mgr.addWindow(this.craftingGrid.getWindow());
    }

    public static void register() {
        GuiStorageScanner.register(StorageScannerModule.CONTAINER_STORAGE_SCANNER.get(), GuiStorageScanner::new);
        MenuScreens.ScreenConstructor factory = (container, inventory, title) -> {
            GenericTileEntity te = container.getTe();
            return (GuiStorageScanner)((Object)((Object)Tools.safeMap((Object)te, tile -> new GuiStorageScanner((StorageScannerTileEntity)tile, (StorageScannerContainer)container, inventory), (String)"Invalid tile entity!")));
        };
        MenuScreens.m_96206_(StorageScannerModule.CONTAINER_STORAGE_SCANNER_REMOTE.get(), (MenuScreens.ScreenConstructor)factory);
    }

    public void m_7856_() {
        super.m_7856_();
        this.energyBar = ((EnergyBar)((EnergyBar)((EnergyBar)new EnergyBar().filledRectThickness(1)).vertical().desiredWidth(10)).desiredHeight(50)).showText(false);
        this.openViewButton = (ToggleButton)((ToggleButton)new ToggleButton().checkMarker(false).text("V")).tooltips(new String[]{"Toggle wide storage list"});
        this.openViewButton.pressed(((StorageScannerTileEntity)this.tileEntity).isOpenWideView());
        this.openViewButton.event(this::toggleView);
        this.upButton = (Button)((Button)Widgets.button((String)"U").channel("up")).tooltips(new String[]{"Move inventory up"});
        this.topButton = (Button)((Button)Widgets.button((String)"T").channel("top")).tooltips(new String[]{"Move inventory to the top"});
        this.downButton = (Button)((Button)Widgets.button((String)"D").channel("down")).tooltips(new String[]{"Move inventory down"});
        this.bottomButton = (Button)((Button)Widgets.button((String)"B").channel("bottom")).tooltips(new String[]{"Move inventory to the bottom"});
        this.removeButton = (Button)((Button)Widgets.button((String)"R").channel("remove")).tooltips(new String[]{"Remove inventory from list"});
        Panel energyPanel = (Panel)Widgets.vertical((int)0, (int)1).desiredWidth(10);
        energyPanel.children(new Widget[]{this.openViewButton, this.energyBar, this.topButton, this.upButton, this.downButton, this.bottomButton, Widgets.label((String)" "), Widgets.label((String)" "), this.removeButton});
        this.exportToStarred = (ImageChoiceLabel)Widgets.imageChoice((int)12, (int)223, (int)13, (int)13).name("export");
        this.exportToStarred.choice("No", "Export to current container", guielements, 131, 19);
        this.exportToStarred.choice("Yes", "Export to first routable container", guielements, 115, 19);
        this.storagePanel = this.makeStoragePanel(energyPanel);
        this.itemPanel = this.makeItemPanel();
        this.radiusLabel = ((ScrollableLabel)((ScrollableLabel)((ScrollableLabel)new ScrollableLabel().hint(1, 1, 1, 1)).name("radius")).visible(false)).realMinimum(RFToolsStorage.setup.xnet ? 0 : 1).realMaximum(20);
        this.visibleRadiusLabel = (Label)((Label)Widgets.label((int)55, (int)4, (int)30, (int)13, (String)"").desiredWidth(30)).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
        this.sortChoice = (ChoiceLabel)((ChoiceLabel)((ChoiceLabel)new ChoiceLabel().hint(3, 20, 74, 12)).name("sortMode")).desiredWidth(60);
        for (SortingMode mode : SortingMode.values()) {
            this.sortChoice.choices(mode.getDescription()).choiceTooltip(mode.getName(), new String[]{mode.getTooltip()});
        }
        this.sortChoice.choice(((StorageScannerTileEntity)this.tileEntity).getSortMode().getName());
        this.searchField = ((TextField)Widgets.textfield((int)3, (int)35, (int)73, (int)14).tooltips(new String[]{"Filter the list of items"})).event(newText -> {
            this.storageList.clearHilightedRows();
            fromServer_foundInventories.clear();
            this.startSearch(newText);
        });
        Slider radiusSlider = ((Slider)((Slider)((Slider)new Slider().channel("scan")).hint(3, 4, 50, 13)).horizontal().tooltips(new String[]{"The radius that the scanner", "will use to find storages"})).minimumKnobSize(14).scrollableName("radius");
        Panel scanPanel = (Panel)((Panel)((Panel)((Panel)Widgets.positional().hint(3, 161, 80, 55)).filledRectThickness(-1)).filledBackground(StyleConfig.colorListBackground)).children(new Widget[]{this.visibleRadiusLabel, this.radiusLabel, this.searchField, this.sortChoice});
        if (!RFToolsStorage.setup.xnet || !((Boolean)StorageScannerConfiguration.xnetRequired.get()).booleanValue()) {
            scanPanel.children(new Widget[]{radiusSlider});
        }
        Panel toplevel = (Panel)((Panel)Widgets.positional().background(iconLocation)).children(new Widget[]{this.storagePanel, this.itemPanel, scanPanel, this.exportToStarred});
        toplevel.bounds(this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_);
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
        this.window.bind("export", (GenericTileEntity)((StorageScannerTileEntity)this.tileEntity), "export");
        this.window.bind("radius", (GenericTileEntity)((StorageScannerTileEntity)this.tileEntity), StorageScannerTileEntity.VALUE_RADIUS.key().name());
        this.window.bind("sortMode", (GenericTileEntity)((StorageScannerTileEntity)this.tileEntity), "sortMode");
        this.window.event("up", (source, params) -> this.moveUp());
        this.window.event("top", (source, params) -> this.moveTop());
        this.window.event("down", (source, params) -> this.moveDown());
        this.window.event("bottom", (source, params) -> this.moveBottom());
        this.window.event("remove", (source, params) -> this.removeFromList());
        this.window.event("scan", (source, params) -> RFToolsStorageMessages.sendToServer(PacketGetInventoryInfo.create(((StorageScannerTileEntity)this.tileEntity).getDimension(), ((StorageScannerTileEntity)this.tileEntity).getStorageScannerPos(), true)));
        ClientTools.enableKeyboardRepeat();
        fromServer_foundInventories.clear();
        fromServer_inventory.clear();
        fromServer_craftable.clear();
        if (((StorageScannerTileEntity)this.tileEntity).isDummy()) {
            fromServer_inventories.clear();
        }
        BlockPos pos = ((StorageScannerTileEntity)this.tileEntity).getCraftingGridContainerPos();
        this.craftingGrid.initGui(this.f_96541_, this, pos, ((StorageScannerTileEntity)this.tileEntity).getDimension(), ((StorageScannerTileEntity)this.tileEntity).getCraftingGridProvider(), this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_);
        this.sendServerCommand("rftoolsstorage", "requestGridSync", TypedMap.builder().put(CommandHandler.PARAM_POS, (Object)pos).put(CommandHandler.PARAM_DIMENSION, ((StorageScannerTileEntity)this.tileEntity).getDimension()).build());
        if (((Boolean)StorageScannerConfiguration.hilightStarredOnGuiOpen.get()).booleanValue()) {
            this.storageList.selected(0);
        }
        this.init = true;
    }

    private int getStoragePanelWidth() {
        return this.openViewButton.isPressed() ? 120 : 45;
    }

    private Panel makeItemPanel() {
        this.itemList = ((WidgetList)new WidgetList().name("items")).propagateEventsToChildren(true).invisibleSelection(true);
        Slider itemListSlider = ((Slider)new Slider().desiredWidth(9)).vertical().scrollableName("items");
        return (Panel)((Panel)Widgets.horizontal((int)1, (int)0).hint(this.getStoragePanelWidth() + 2, 4, 256 - this.getStoragePanelWidth() - 7, 152)).children(new Widget[]{this.itemList, itemListSlider});
    }

    private Panel makeStoragePanel(Panel energyPanel) {
        this.storageList = ((WidgetList)new WidgetList().name("storage")).event((SelectionEvent)new DefaultSelectionEvent(){

            public void select(int index) {
                GuiStorageScanner.this.getInventoryOnServer();
            }

            public void doubleClick(int index) {
                GuiStorageScanner.this.hilightSelectedContainer(index);
            }
        }).propagateEventsToChildren(true);
        Slider storageListSlider = ((Slider)new Slider().desiredWidth(9)).vertical().scrollableName("storage");
        return (Panel)((Panel)((Panel)Widgets.horizontal((int)1, (int)0).hint(3, 4, this.getStoragePanelWidth(), 152)).desiredHeight(152)).children(new Widget[]{energyPanel, this.storageList, storageListSlider});
    }

    private void toggleView() {
        this.storagePanel.hint(3, 4, this.getStoragePanelWidth(), 152);
        this.itemPanel.hint(this.getStoragePanelWidth() + 2, 4, 256 - this.getStoragePanelWidth() - 7, 152);
        this.window.getToplevel().markLayoutDirty();
        this.listDirty = 0;
        this.requestListsIfNeeded();
        this.sendServerCommandTyped(StorageScannerTileEntity.CMD_SETVIEW, TypedMap.builder().put(StorageScannerTileEntity.PARAM_VIEW, (Object)this.openViewButton.isPressed()).build());
    }

    public boolean m_6375_(double x, double y, int button) {
        Slot slot;
        boolean r = super.m_6375_(x, y, button);
        if (button == 1 && (slot = this.m_97744_(x, y)) instanceof GhostOutputSlot) {
            this.window.sendServerCommand(StorageScannerTileEntity.CMD_CLEARGRID, TypedMap.EMPTY);
        }
        return r;
    }

    private void moveUp() {
        this.sendServerCommandTyped(StorageScannerTileEntity.CMD_UP, TypedMap.builder().put(StorageScannerTileEntity.PARAM_INDEX, (Object)(this.storageList.getSelected() - 1)).build());
        this.storageList.selected(this.storageList.getSelected() - 1);
        this.listDirty = 0;
    }

    private void moveTop() {
        this.sendServerCommandTyped(StorageScannerTileEntity.CMD_TOP, TypedMap.builder().put(StorageScannerTileEntity.PARAM_INDEX, (Object)(this.storageList.getSelected() - 1)).build());
        this.storageList.selected(1);
        this.listDirty = 0;
    }

    private void moveDown() {
        this.sendServerCommandTyped(StorageScannerTileEntity.CMD_DOWN, TypedMap.builder().put(StorageScannerTileEntity.PARAM_INDEX, (Object)(this.storageList.getSelected() - 1)).build());
        this.storageList.selected(this.storageList.getSelected() + 1);
        this.listDirty = 0;
    }

    private void moveBottom() {
        this.sendServerCommandTyped(StorageScannerTileEntity.CMD_BOTTOM, TypedMap.builder().put(StorageScannerTileEntity.PARAM_INDEX, (Object)(this.storageList.getSelected() - 1)).build());
        this.storageList.selected(this.storageList.getChildCount() - 1);
        this.listDirty = 0;
    }

    private void removeFromList() {
        this.sendServerCommandTyped(StorageScannerTileEntity.CMD_REMOVE, TypedMap.builder().put(StorageScannerTileEntity.PARAM_INDEX, (Object)(this.storageList.getSelected() - 1)).build());
        this.listDirty = 0;
    }

    private void hilightSelectedContainer(int index) {
        if (index == -1) {
            return;
        }
        if (index == 0) {
            return;
        }
        PacketReturnInventoryInfo.InventoryInfo c = fromServer_inventories.get(index - 1);
        if (c != null) {
            Logging.message((Player)this.f_96541_.f_91074_, (String)"The inventory is now highlighted");
            this.f_96541_.f_91074_.m_6915_();
        }
    }

    private void startSearch(String text) {
        if (!text.isEmpty()) {
            this.sendServerCommand("rftoolsstorage", "scannerSearch", TypedMap.builder().put(CommandHandler.PARAM_SCANNER_DIM, (Object)((StorageScannerTileEntity)this.tileEntity).getDimension().m_135782_().toString()).put(CommandHandler.PARAM_SCANNER_POS, (Object)((StorageScannerTileEntity)this.tileEntity).getStorageScannerPos()).put(CommandHandler.PARAM_SEARCH_TEXT, (Object)text).build());
        }
    }

    private void getInventoryOnServer() {
        BlockPos c = this.getSelectedContainerPos();
        if (c != null) {
            this.sendServerCommand("rftoolsstorage", "requestScannerContents", TypedMap.builder().put(CommandHandler.PARAM_SCANNER_DIM, (Object)((StorageScannerTileEntity)this.tileEntity).getDimension().m_135782_().toString()).put(CommandHandler.PARAM_SCANNER_POS, (Object)((StorageScannerTileEntity)this.tileEntity).getStorageScannerPos()).put(CommandHandler.PARAM_INV_POS, (Object)c).build());
        }
    }

    private BlockPos getSelectedContainerPos() {
        int selected = this.storageList.getSelected();
        if (selected != -1) {
            if (selected == 0) {
                return new BlockPos(-1, -1, -1);
            }
            if (--selected < fromServer_inventories.size()) {
                PacketReturnInventoryInfo.InventoryInfo info = fromServer_inventories.get(selected);
                if (info == null) {
                    return null;
                }
                return info.pos();
            }
        }
        return null;
    }

    private void requestListsIfNeeded() {
        --this.listDirty;
        if (this.listDirty <= 0) {
            RFToolsStorageMessages.sendToServer(PacketGetInventoryInfo.create(((StorageScannerTileEntity)this.tileEntity).getDimension(), ((StorageScannerTileEntity)this.tileEntity).getStorageScannerPos(), false));
            this.getInventoryOnServer();
            this.listDirty = 20;
        }
    }

    @Nonnull
    private static ResourceLocation findLargestTag(ItemStack stack) {
        Collection tags = TagTools.getTags((Item)stack.m_41720_());
        if (tags.isEmpty()) {
            return Tools.getId((ItemStack)stack);
        }
        if (tags.size() == 1) {
            return ((TagKey)tags.iterator().next()).f_203868_();
        }
        int s = -1;
        TagKey largestTag = null;
        for (TagKey tag : tags) {
            int size = 0;
            for (Holder holder : TagTools.getItemsForTag((TagKey)tag)) {
                ++size;
            }
            if (size <= s) continue;
            s = size;
            largestTag = tag;
            break;
        }
        return largestTag.f_203868_();
    }

    private static int compareByTag(ItemStack s1, ItemStack s2) {
        ResourceLocation largest2;
        ResourceLocation largest1 = GuiStorageScanner.findLargestTag(s1);
        int rc = largest1.compareTo(largest2 = GuiStorageScanner.findLargestTag(s2));
        if (rc == 0) {
            return s1.m_41786_().getString().compareTo(s2.m_41786_().getString());
        }
        return rc;
    }

    private static int compareByMod(ItemStack s1, ItemStack s2) {
        int rc = Tools.getId((ItemStack)s1).m_135827_().compareTo(Tools.getId((ItemStack)s2).m_135827_());
        if (rc == 0) {
            return s1.m_41786_().getString().compareTo(s2.m_41786_().getString());
        }
        return rc;
    }

    private void updateContentsList() {
        this.itemList.removeChildren();
        Pair<Panel, Integer> currentPos = MutablePair.of(null, (Object)0);
        int numcolumns = this.openViewButton.isPressed() ? 6 : 10;
        int spacing = 3;
        SortingMode mode = SortingMode.byDescription(this.sortChoice.getCurrentChoice());
        if (mode != null) {
            switch (mode) {
                case AMOUNT_ASCENDING: {
                    fromServer_inventory.sort(Comparator.comparing(ItemStack::m_41613_));
                    fromServer_craftable.sort(Comparator.comparing(ItemStack::m_41613_));
                    break;
                }
                case AMOUNT_DESCENDING: {
                    fromServer_inventory.sort(Comparator.comparing(ItemStack::m_41613_).reversed());
                    fromServer_craftable.sort(Comparator.comparing(ItemStack::m_41613_).reversed());
                    break;
                }
                case MOD: {
                    fromServer_inventory.sort(GuiStorageScanner::compareByMod);
                    fromServer_craftable.sort(GuiStorageScanner::compareByMod);
                    break;
                }
                case TAG: {
                    fromServer_inventory.sort(GuiStorageScanner::compareByTag);
                    fromServer_craftable.sort(GuiStorageScanner::compareByTag);
                    break;
                }
                case NAME: {
                    fromServer_inventory.sort(Comparator.comparing(itemStack -> itemStack.m_41786_().getString()));
                    fromServer_craftable.sort(Comparator.comparing(itemStack -> itemStack.m_41786_().getString()));
                }
            }
        }
        String filterText = this.searchField.getText().toLowerCase();
        Predicate<ItemStack> matcher = StorageScannerTileEntity.getMatcher(filterText);
        for (ItemStack item : fromServer_inventory) {
            if (!filterText.isEmpty() && !matcher.test(item)) continue;
            currentPos = this.addItemToList(item, this.itemList, currentPos, numcolumns, spacing, false);
        }
        for (ItemStack item : fromServer_craftable) {
            if (!filterText.isEmpty() && !matcher.test(item)) continue;
            currentPos = this.addItemToList(item, this.itemList, currentPos, numcolumns, spacing, true);
        }
    }

    private Pair<Panel, Integer> addItemToList(ItemStack item, WidgetList itemList, Pair<Panel, Integer> currentPos, int numcolumns, int spacing, final boolean craftable) {
        Panel panel = (Panel)currentPos.getKey();
        if (panel == null || (Integer)currentPos.getValue() >= numcolumns) {
            panel = (Panel)((Panel)Widgets.horizontal((int)1, (int)spacing).desiredHeight(12)).desiredHeight(16);
            currentPos = MutablePair.of((Object)panel, (Object)0);
            itemList.children(new Widget[]{panel});
        }
        final BlockRender blockRender = ((BlockRender)new BlockRender().renderItem((Object)item).userObject((Object)craftable)).offsetX(0).offsetY(-1).hilightOnHover(true);
        if (craftable) {
            blockRender.filledBackground(-15649946, -15641310);
        }
        blockRender.event(new BlockRenderEvent(){

            public void select() {
                Object item = blockRender.getRenderItem();
                if (item != null) {
                    boolean shift = SafeClientTools.isSneaking();
                    GuiStorageScanner.this.requestItem((ItemStack)item, shift ? 1 : -1, craftable);
                }
            }

            public void doubleClick() {
            }
        });
        panel.children(new Widget[]{blockRender});
        currentPos.setValue((Object)((Integer)currentPos.getValue() + 1));
        return currentPos;
    }

    private void requestItem(ItemStack stack, int amount, boolean craftable) {
        BlockPos selectedContainerPos = this.getSelectedContainerPos();
        if (selectedContainerPos == null) {
            return;
        }
        RFToolsStorageMessages.sendToServer(PacketRequestItem.create(((StorageScannerTileEntity)this.tileEntity).getDimension(), ((StorageScannerTileEntity)this.tileEntity).getStorageScannerPos(), selectedContainerPos, stack, amount, craftable));
        this.getInventoryOnServer();
    }

    private void changeRoutable(BlockPos c) {
        this.sendServerCommandTyped(StorageScannerTileEntity.CMD_TOGGLEROUTABLE, TypedMap.builder().put(StorageScannerTileEntity.PARAM_POS, (Object)c).build());
        this.listDirty = 0;
    }

    private void updateStorageList() {
        this.storageList.removeChildren();
        this.addStorageLine(null, "All routable", false);
        for (PacketReturnInventoryInfo.InventoryInfo c : fromServer_inventories) {
            String displayName = c.name();
            boolean routable = c.routable();
            this.addStorageLine(c, displayName, routable);
        }
        this.storageList.clearHilightedRows();
        int i = 0;
        for (PacketReturnInventoryInfo.InventoryInfo c : fromServer_inventories) {
            if (fromServer_foundInventories.contains(c.pos())) {
                this.storageList.addHilightedRow(i + 1);
            }
            ++i;
        }
    }

    private void addStorageLine(PacketReturnInventoryInfo.InventoryInfo c, String displayName, boolean routable) {
        Panel panel;
        if (c == null) {
            panel = Widgets.horizontal((int)5, (int)8);
            panel.children(new Widget[]{((ImageLabel)((ImageLabel)new ImageLabel().image(guielements, 115, 19)).desiredWidth(13)).desiredHeight(13)});
        } else {
            HorizontalLayout layout = new HorizontalLayout();
            if (!this.openViewButton.isPressed()) {
                layout.setHorizontalMargin(2);
            }
            panel = new Panel().layout((Layout)layout);
            panel.children(new Widget[]{new BlockRender().renderItem((Object)c.block())});
        }
        if (this.openViewButton.isPressed()) {
            AbstractWidget label = ((Label)((Label)((Label)Widgets.label((String)displayName).color(StyleConfig.colorTextInListNormal)).dynamic(true)).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).desiredWidth(50);
            if (c == null) {
                label.tooltips(new String[]{ChatFormatting.GREEN + "All routable inventories"}).desiredWidth(74);
            } else {
                label.tooltips(new String[]{ChatFormatting.GREEN + "Block at: " + ChatFormatting.WHITE + BlockPosTools.toString((BlockPos)c.pos()), ChatFormatting.GREEN + "Name: " + ChatFormatting.WHITE + displayName, "(doubleclick to highlight)"});
            }
            panel.children(new Widget[]{label});
            if (c != null) {
                ImageChoiceLabel choiceLabel = (ImageChoiceLabel)new ImageChoiceLabel().event(newChoice -> this.changeRoutable(c.pos())).desiredWidth(13);
                choiceLabel.choice("No", "Not routable", guielements, 131, 19);
                choiceLabel.choice("Yes", "Routable", guielements, 115, 19);
                choiceLabel.setCurrentChoice(routable ? 1 : 0);
                panel.children(new Widget[]{choiceLabel});
            }
        }
        this.storageList.children(new Widget[]{panel});
    }

    protected void m_7286_(@Nonnull GuiGraphics graphics, float v, int i, int i2) {
        if (!this.init) {
            return;
        }
        this.updateStorageList();
        this.updateContentsList();
        this.requestListsIfNeeded();
        String text = this.radiusLabel.getText();
        if ("0".equals(text)) {
            text = "XNet";
        }
        this.visibleRadiusLabel.text(text);
        int selected = this.storageList.getSelected();
        this.removeButton.enabled(selected != -1);
        if (selected <= 0 || this.storageList.getChildCount() <= 2) {
            this.upButton.enabled(false);
            this.downButton.enabled(false);
            this.topButton.enabled(false);
            this.bottomButton.enabled(false);
        } else if (selected == 1) {
            this.topButton.enabled(false);
            this.upButton.enabled(false);
            this.downButton.enabled(true);
            this.bottomButton.enabled(true);
        } else if (selected == this.storageList.getChildCount() - 1) {
            this.topButton.enabled(true);
            this.upButton.enabled(true);
            this.downButton.enabled(false);
            this.bottomButton.enabled(false);
        } else {
            this.topButton.enabled(true);
            this.upButton.enabled(true);
            this.downButton.enabled(true);
            this.bottomButton.enabled(true);
        }
        if (!((StorageScannerTileEntity)this.tileEntity).isDummy()) {
            this.updateEnergyBar(this.energyBar);
            this.exportToStarred.setCurrentChoice(((StorageScannerTileEntity)this.tileEntity).isExportToCurrent() ? 0 : 1);
        } else {
            if (System.currentTimeMillis() - lastTime > 300L) {
                lastTime = System.currentTimeMillis();
                Networking.sendToServer((Object)PacketRequestDataFromServer.create(((StorageScannerTileEntity)this.tileEntity).getDimension(), (BlockPos)((StorageScannerTileEntity)this.tileEntity).m_58899_(), StorageScannerTileEntity.CMD_SCANNER_INFO, (TypedMap)TypedMap.EMPTY, (boolean)((StorageScannerTileEntity)this.tileEntity).isDummy()));
            }
            this.energyBar.value(((StorageScannerTileEntity)this.tileEntity).rfReceived);
            this.exportToStarred.setCurrentChoice(((StorageScannerTileEntity)this.tileEntity).exportToCurrentReceived ? 0 : 1);
        }
        this.drawWindow(graphics);
    }

    protected void m_280003_(@Nonnull GuiGraphics graphics, int i1, int i2) {
        if (!this.init) {
            return;
        }
        int x = GuiTools.getRelativeX((Screen)this);
        int y = GuiTools.getRelativeY((Screen)this);
        List tooltips = this.craftingGrid.getWindow().getTooltips();
        if (tooltips != null) {
            this.drawHoveringText(graphics, tooltips, this.window.getTooltipItems(), x - this.f_97735_, y - this.f_97736_, this.f_96541_.f_91062_);
        }
        super.m_280003_(graphics, i1, i2);
    }

    protected void drawStackTooltips(GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.init) {
            super.drawStackTooltips(graphics, mouseX, mouseY);
        }
    }

    protected List<Component> addCustomLines(List<Component> oldList, BlockRender blockRender, ItemStack stack) {
        Object object = blockRender.getUserObject();
        if (object instanceof Boolean) {
            Boolean craftable = (Boolean)object;
            ArrayList<Component> newlist = new ArrayList<Component>();
            if (craftable.booleanValue()) {
                newlist.add((Component)ComponentFactory.literal((String)"Craftable").m_130940_(ChatFormatting.GOLD));
            }
            newlist.add((Component)ComponentFactory.literal((String)"Click: ").m_130940_(ChatFormatting.GREEN).m_7220_((Component)ComponentFactory.literal((String)"full stack").m_130940_(ChatFormatting.WHITE)));
            newlist.add((Component)ComponentFactory.literal((String)"Shift + click: ").m_130940_(ChatFormatting.GREEN).m_7220_((Component)ComponentFactory.literal((String)"single item").m_130940_(ChatFormatting.WHITE)));
            newlist.add((Component)ComponentFactory.literal((String)""));
            newlist.addAll(oldList);
            return newlist;
        }
        return oldList;
    }

    protected void drawWindow(GuiGraphics matrixStack) {
        if (!this.init) {
            return;
        }
        super.drawWindow(matrixStack);
        this.craftingGrid.draw(matrixStack);
    }
}

