/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamicscompat.modcompat.jei.squeezer;

import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeSqueezer;
import org.cyclops.integrateddynamicscompat.modcompat.jei.squeezer.SqueezerRecipeJEI;

public class SqueezerRecipeCategory
implements IRecipeCategory<SqueezerRecipeJEI> {
    public static final RecipeType<SqueezerRecipeJEI> TYPE = RecipeType.create((String)"integrateddynamicscompat", (String)"squeezer", SqueezerRecipeJEI.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableStatic arrowDrawable;

    public SqueezerRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation resourceLocation = new ResourceLocation("integrateddynamicscompat", "textures/gui/squeezer_gui_jei.png");
        this.background = guiHelper.createDrawable(resourceLocation, 0, 0, 116, 53);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)RegistryEntries.BLOCK_SQUEEZER));
        this.arrowDrawable = guiHelper.createDrawable(resourceLocation, 41, 32, 12, 2);
    }

    public RecipeType<SqueezerRecipeJEI> getRecipeType() {
        return TYPE;
    }

    @Nonnull
    public Component getTitle() {
        return Component.m_237115_((String)RegistryEntries.BLOCK_SQUEEZER.m_7705_());
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SqueezerRecipeJEI recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 2, 18).addItemStacks(recipe.getInputItem());
        int offset = 0;
        for (int i = 0; i < recipe.getOutputItems().size(); ++i) {
            RecipeSqueezer.IngredientChance outputItem = (RecipeSqueezer.IngredientChance)recipe.getOutputItems().get(i);
            ((IRecipeSlotBuilder)builder.addSlot(outputItem.getChance() < 1.0f ? RecipeIngredientRole.RENDER_ONLY : RecipeIngredientRole.OUTPUT, 76 + (i % 2 > 0 ? 22 : 0), 8 + offset + (i > 1 ? 22 : 0)).addItemStack(outputItem.getIngredientFirst())).addTooltipCallback((view, tooltip) -> {
                float chance = outputItem.getChance();
                tooltip.add(Component.m_237113_((String)("Chance: " + chance * 100.0f + "%")).m_130940_(ChatFormatting.GRAY));
            });
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 98, 30).setFluidRenderer(1000L, true, 16, 16).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)recipe.getOutputFluid());
    }

    public void draw(SqueezerRecipeJEI recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        int height = (int)(Minecraft.m_91087_().f_91073_.m_46467_() / 4L % 7L);
        this.arrowDrawable.draw(guiGraphics, 41, 18 + height * 2);
    }
}

